#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Wed Dec 18 15:02:49 2019 by generateDS.py version 2.35.7.
# Python 3.7.4 (v3.7.4:e09359112e, Jul  8 2019, 14:54:52)  [Clang 6.0 (clang-600.0.57)]
#
# Command line options:
#   ('-o', 'sfftkrw/schema/v_0_8_0_dev0.py')
#
# Command line arguments:
#   ../EMDB-SFF/segmentation_da.xsd
#
# Command line:
#   /Users/pkorir/Envs/sfftk-rw-3.7/bin/generateDS.py -o "sfftkrw/schema/v_0_8_0_dev0.py" ../EMDB-SFF/segmentation_da.xsd
#
# Current working directory (os.getcwd()):
#   sfftk-rw
#

from six.moves import zip_longest
import os
import sys
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
try:
    from lxml import etree as etree_
except ImportError:
    from xml.etree import ElementTree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element

#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ImportError:
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_
except ImportError:
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ImportError:

    class GdsCollector_(object):

        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ImportError:
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:
    
    class GeneratedsSuper(object):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_parse_string(self, input_data, node=None, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_parse_integer(self, input_data, node=None, input_name=''):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires integer value: %s' % exp)
            return ival
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires integer value')
            return value
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integer valuess')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_parse_float(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires float or double value: %s' % exp)
            return fval_
        def gds_validate_float(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires float value')
            return value
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of float values')
            return values
        def gds_format_decimal(self, input_data, input_name=''):
            return ('%0.10f' % input_data).rstrip('0')
        def gds_parse_decimal(self, input_data, node=None, input_name=''):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return decimal_value
        def gds_validate_decimal(self, input_data, node=None, input_name=''):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires decimal value')
            return value
        def gds_format_decimal_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_decimal_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of decimal values')
            return values
        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def gds_parse_double(self, input_data, node=None, input_name=''):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, 'Requires double or float value: %s' % exp)
            return fval_
        def gds_validate_double(self, input_data, node=None, input_name=''):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, 'Requires double or float value')
            return value
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, 'Requires sequence of double or float values')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_parse_boolean(self, input_data, node=None, input_name=''):
            if input_data in ('true', '1'):
                bval = True
            elif input_data in ('false', '0'):
                bval = False
            else:
                raise_parse_error(node, 'Requires boolean value')
            return bval
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            if input_data not in (True, 1, False, 0, ):
                raise_parse_error(
                    node,
                    'Requires boolean value '
                    '(one of True, 1, False, 0)')
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in (True, 1, False, 0, ):
                    raise_parse_error(
                        node,
                        'Requires sequence of boolean values '
                        '(one of True, 1, False, 0)')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (
                    time_parts[0], "{}".format(micro_seconds).rjust(6, "0"), )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(
                                hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_check_cardinality_(
                self, value, input_name,
                min_occurs=0, max_occurs=1, required=None):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None :
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()))
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        min_occurs, length))
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(),
                        max_occurs, length))
        def gds_validate_builtin_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_validate_defined_ST_(
                self, validator, value, input_name,
                min_occurs=None, max_occurs=None, required=None):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))
        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = 'utf-8'
                return instring.encode(encoding)
            else:
                return instring
        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode('utf8')
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result
        def __eq__(self, other):
            def excl_select_objs_(obj):
                return (obj[0] != 'parent_object_' and
                        obj[0] != 'gds_collector_')
            if type(self) != type(other):
                return False
            return all(x == y for x, y in zip_longest(
                filter(excl_select_objs_, self.__dict__.items()),
                filter(excl_select_objs_, other.__dict__.items())))
        def __ne__(self, other):
            return not self.__eq__(other)
        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass
        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass
        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None
        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass
        def gds_get_node_lineno_(self):
            if (hasattr(self, "gds_elementtree_node_") and
                    self.gds_elementtree_node_ is not None):
                return ' near line {}'.format(
                    self.gds_elementtree_node_.sourceline)
            else:
                return ""
    
    
    def getSubclassFromModule_(module, class_):
        '''Get the subclass of a class from a specific module.'''
        name = class_.__name__ + 'Sub'
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ''
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, BaseStrType_) and inStr or '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace,
               pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name,
                pretty_print=pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name,
                base64.b64encode(self.value),
                self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(
                element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type,
                    self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0,
            optional=0, child_attrs=None, choice=None):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container
    def set_child_attrs(self, child_attrs): self.child_attrs = child_attrs
    def get_child_attrs(self): return self.child_attrs
    def set_choice(self, choice): self.choice = choice
    def get_choice(self): return self.choice
    def set_optional(self, optional): self.optional = optional
    def get_optional(self): return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class endian_type(Enum):
    LITTLE='little'
    BIG='big'


class formatType(Enum):
    RUN_LENGTH_ENCODING='runLengthEncoding'
    MRC='MRC'
    SEGGER='Segger'
    EMAN='EMAN'


class mode_type(Enum):
    INT_8='int8'
    UINT_8='uint8'
    INT_16='int16'
    UINT_16='uint16'
    INT_32='int32'
    UINT_32='uint32'
    INT_64='int64'
    UINT_64='uint64'
    FLOAT_32='float32'
    FLOAT_64='float64'


class primary_descriptorType(Enum):
    """Mandatory field. Designates the element type within
    'segment_list' that contains the primary description of the segments.
    Constrained to be either 'three_d_volume', 'shape_primitive_list', or
    'mesh_list'."""
    THREE_D_VOLUME='three_d_volume'
    SHAPE_PRIMITIVE_LIST='shape_primitive_list'
    MESH_LIST='mesh_list'


class segmentation(GeneratedsSuper):
    """Link to assembly or component id.
    Version History
    0.2, 2015/3/15, Ardan Patwardhan:
    1) Added support for color
    2) Added support for triangle representation of segment - this is in
    support of Amira segmentations
    0.3, 2015/10/21, Paul Korir:
    1) Added voxelTransform
    2) Added filePath for segmentLinks to HDF5 (Segger) segmentations
    3) Added segmentObjects with contours and meshes for IMOD
    0.4, 2015/11/04, Paul Korir:
    1) Added alpha for rgb color (transparency)
    0.5, 2015/12/14, Paul Korir:
    1) Removed 'voxelTransform'
    2) Moved 'numberOfCopies' as 'numberOfInstances' to be a sequence element
    within 'biologicalAnnotation'
    3) Made 'color' a choice between 'name' (X11/HTML4 sRGB colour space names)
    and 'rgba'
    4) Added a 'transform' element, which is a possibly empty list of
    transformation matrices referenced within the document by a non-
    negative identifier
    5) Renamed 'segmentLink' to 'voxelSegmentation' and added a 'transformId'
    element
    6) Renamed 'color' element to 'colour' and 'colorType' to 'colourType'
    7) Structured 'shapePrimitive' to a list of 'shapePrimitive' (substitution
    group for 'ellipsoid', 'cuboid', 'pyramid', 'cylinder')
    8) Identified and labeled deprecated data types
    9) Renamed shapePrimitive 'pyramid' to 'cone' and added tentative
    definition
    10) Removed 'origin' and 'viewVectorRotation' elements from shape
    primitives (cuboid, ellipsoid, cone, cylinder) and replaced with
    'transformId' element
    11) Renamed references to 'triangles' to 'polygons' e.g. 'triangleListType'
    now 'polygonListType'
    0.5.1, 2015/12/23, Paul Korir:
    1) Change colourType to have rgbaType minOccurs=1
    2) Added 'attribute' element (e.g. for FOM) to shapePrimitive
    3) Deleted comment: 'Are the CCP4 format masks going to be allowed? If so,
    we could represent the information of the mask (mapType) here.' from
    'voxelSegmentation'.
    4) Added segment 'format' element to 'voxelSegmentation' restricted to
    values 'runLengthEncoding', 'MRC', or 'Segger'
    5) Renamed 'voxelSegmentation' to 'threeDVolume' and deprecated
    'subTomogramAverage'.
    6) Restructured 'transforms' into a list ('transformList') of 'transform',
    which is a substitutionGroup of 'transformationMatrix',
    'canonicalEulerAngles' or 'viewVectorRotation'.
    7) Added an 'angleDegreeType' to restrict angle range in degrees [0,360].
    0.5.2, 2016/01/04, Paul Korir:
    1) Made 'transformList' optional
    2) Added 'id' attributes for 'canonicalEulerAngle' and 'viewVectorRotation'
    3) Annotations for 'filePath'
    4) Added 'other' to types for 'externalReference' and optional 'otherTypes'
    attribute
    5) Changed type of 'name' element in 'colour' from 'xs:string' to
    'xs:token'
    6) Created 'threeDVolumeType' to be used by 'threeDVolume' and
    'subtomogramAverage'
    7) Added 'id' attributes for 'shapePrimitive' and 'threeDVolumeType'
    8) Renamed 'contours' to 'contourList'
    9) Created 'meshList' as a sequence of 'mesh'. Each 'mesh' has an 'id'
    0.5.3, 2016/01/06, Paul Korir:
    1) Renamed 'transformationMatrixType' attribute from 'transformId' to 'id'
    2) Created 'dimensionType' for all 'shapePrimitive' dimensions
    0.5.4, 2016/01/06, Paul Korir:
    1) Added element 'primaryDescriptor' of type restricted string to
    'threeDVolume', 'shapePrimitiveList', 'contourList', 'meshList'
    0.5.5, 2016/01/22, Paul Korir:
    1) Changed 'vertices' and 'polygons' to 'vertexList' and 'polygonList',
    respectively.
    2) Added attribute 'designation' restricted to string 'vertex' (default)
    and 'normal' to 'vertex' element.
    0.5.6, 2016/01/25, Paul Korir:
    1) Changed attribute 'polygonID' from 'positiveInteger' to
    'nonNegativeInteger'
    0.5.7, 2016/01/26, Paul Korir:
    1) Change element names to save disk space: 'vertex' to 'v', 'vertexID' to
    'vID', 'point' to 'p', 'polygon' to 'P', 'polygonID' to 'PID'
    2) Changed 'vertexType' to have ID of type 'xs:nonNegativeInteger' (from
    'xs:positiveInteger')
    0.5.8, 2016/04/26, Paul Korir:
    1) Added 'version' element at the root.
    0.5.8, 2016/08/08, Paul Korir:
    2) Made 'shapePrimitive' element 'attribute (not present in
    'subtomogramAverage' optional (minOccurs=0)
    0.5.8, 2016/08/17, Paul Korir:
    3) Added a 'transformId' element to 'contourList' and to 'mesh'.
    0.5.8, 2016/10/04, Paul Korir:
    4) Simplified shape primitives by eliminating internal layering e.g.
    cone/dimensions/height to cone/height
    0.5.8, 2016/10/14, Paul Korir:
    5) (Finally) renamed 'surfaceType' to 'meshType' for consistency.
    0.5.8, 2016/10/20, Paul Korir:
    6) 'macromolecule' and 'complex' changed from 'positiveInteger' to 'string'
    0.6.0a1, 2017/02/28, Paul Korir:
    1) Added 'EMAN' as a 'threeDVolume' format
    0.6.0a2, 2017/05/15, Paul Korir:
    1) Restructured 'externalReferences' from simpleType to complexType
    2) Changed 'externalReference' to 'externalReferenceType' and replaced
    elements with attributes
    0.6.0a3, 2017/05/25, Paul Korir:
    1) Added element 'boundingBox' taking six integers: xmin, xmax, ymin, ymax,
    zmin, zmax; minimums default to 0
    0.6.0a4, 2017/07/31, Paul Korir:
    1) Added global (optional) external references
    0.6.0a4, 2017/09/20, Paul Korir:
    2) Renamed global external references to globalExternalReferences
    0.6.0a4, 2017/09/25, Paul Korir:
    3) Restructured global external references to have the form <ref [attrs]/>
    4) Now externalReferenceType has attributes: type (required), otherType
    (required), value (required), label (new, optional), description (new,
    optional)
    0.6.0a4, 2017/11/23, Paul Korir:
    5) Replaced all active 'token' to 'string' types
    0.7.0.dev0, 2017/11/09, Paul Korir:
    1) new 3D volume type: 'threeDVolumeType' (previous one is
    'oldThreeDVolumeType'
    supports both byte/integer lattices and density volumes (for subtomogram
    averages)
    2) embedded volume as base64 string using new 'latticeType'
    3) removed contour representation
    0.7.0.dev0, 2018/05/04, Paul Korir:
    4) segment name added
    5) removed filePath
    6) removed viewVectorRotation and canonicalEulerAngles
    7) colour has rgbaType now
    0.7.0.dev0, 2018/07/18, Paul Korir:
    8) vertex designation now 'surface' or 'normal'
    0.8.0.dev0, 2019/11/08, Paul Korir:
    1) converted all camelCase names to underscore_case
    2) 'polygon' is now 'triangle'
    3) changed 'transformation_matrix' from being a subsitution group
    4) external_reference (ref): attributes changed to 'resource', 'url',
    'accession' from
    'type', 'otherType' and 'value', respectively
    5) renamed 'macromolecules_and_complexes_type' to
    'complexes_and_macromolecules_type'
    6) restructured 'macromolecules' to 'macromolecule_list' (same for
    'complexes')
    7) now 'macromolecule_list' contains 'macromolecule' with 'id' and text
    value for accession
    0.8.0.dev0, 2019/12/18, Paul Korir:
    8) now 'transform_list' is mandatory with at least one
    'transformation_matrix' for the image-to-physical transform
    9) changed 'software' to be a 'software_list' of zero or more 'software'
    items; software 'version' now required if 'software' is defined
    10) 'complexes_and_macromolecules' are deprecated (were for annotation;
    'external_references' are sufficient)
    11) overhaul of 'mesh' field to have 'vertices', 'normals' (optional) and
    'triangles' which are base64-encoded strings of actual data
    12) 'xmax', 'ymax' and 'zmax' of 'bounding_box' are mandatory"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, schema_version='0.8.0.dev0', version=None, name=None, software_list=None, transform_list=None, primary_descriptor=None, bounding_box=None, global_external_references=None, segment_list=None, lattice_list=None, details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.schema_version = _cast(None, schema_version)
        self.schema_version_nsprefix_ = None
        self.version = version
        self.version_nsprefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.software_list = software_list
        self.software_list_nsprefix_ = None
        self.transform_list = transform_list
        self.transform_list_nsprefix_ = None
        self.primary_descriptor = primary_descriptor
        self.validate_primary_descriptorType(self.primary_descriptor)
        self.primary_descriptor_nsprefix_ = None
        self.bounding_box = bounding_box
        self.bounding_box_nsprefix_ = None
        self.global_external_references = global_external_references
        self.global_external_references_nsprefix_ = None
        self.segment_list = segment_list
        self.segment_list_nsprefix_ = None
        self.lattice_list = lattice_list
        self.lattice_list_nsprefix_ = None
        self.details = details
        self.details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, segmentation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if segmentation.subclass:
            return segmentation.subclass(*args_, **kwargs_)
        else:
            return segmentation(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_software_list(self):
        return self.software_list
    def set_software_list(self, software_list):
        self.software_list = software_list
    def get_transform_list(self):
        return self.transform_list
    def set_transform_list(self, transform_list):
        self.transform_list = transform_list
    def get_primary_descriptor(self):
        return self.primary_descriptor
    def set_primary_descriptor(self, primary_descriptor):
        self.primary_descriptor = primary_descriptor
    def get_bounding_box(self):
        return self.bounding_box
    def set_bounding_box(self, bounding_box):
        self.bounding_box = bounding_box
    def get_global_external_references(self):
        return self.global_external_references
    def set_global_external_references(self, global_external_references):
        self.global_external_references = global_external_references
    def get_segment_list(self):
        return self.segment_list
    def set_segment_list(self, segment_list):
        self.segment_list = segment_list
    def get_lattice_list(self):
        return self.lattice_list
    def set_lattice_list(self, lattice_list):
        self.lattice_list = lattice_list
    def get_details(self):
        return self.details
    def set_details(self, details):
        self.details = details
    def get_schema_version(self):
        return self.schema_version
    def set_schema_version(self, schema_version):
        self.schema_version = schema_version
    def validate_primary_descriptorType(self, value):
        result = True
        # Validate type primary_descriptorType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['three_d_volume', 'shape_primitive_list', 'mesh_list']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on primary_descriptorType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.version is not None or
            self.name is not None or
            self.software_list is not None or
            self.transform_list is not None or
            self.primary_descriptor is not None or
            self.bounding_box is not None or
            self.global_external_references is not None or
            self.segment_list is not None or
            self.lattice_list is not None or
            self.details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='segmentation', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('segmentation')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='segmentation')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='segmentation', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='segmentation'):
        if self.schema_version != "0.8.0.dev0" and 'schema_version' not in already_processed:
            already_processed.add('schema_version')
            outfile.write(' schema_version=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.schema_version), input_name='schema_version')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='segmentation', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.version is not None:
            namespaceprefix_ = self.version_nsprefix_ + ':' if (UseCapturedNS_ and self.version_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespaceprefix_ , eol_))
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.software_list is not None:
            namespaceprefix_ = self.software_list_nsprefix_ + ':' if (UseCapturedNS_ and self.software_list_nsprefix_) else ''
            self.software_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='software_list', pretty_print=pretty_print)
        if self.transform_list is not None:
            namespaceprefix_ = self.transform_list_nsprefix_ + ':' if (UseCapturedNS_ and self.transform_list_nsprefix_) else ''
            self.transform_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='transform_list', pretty_print=pretty_print)
        if self.primary_descriptor is not None:
            namespaceprefix_ = self.primary_descriptor_nsprefix_ + ':' if (UseCapturedNS_ and self.primary_descriptor_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprimary_descriptor>%s</%sprimary_descriptor>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.primary_descriptor), input_name='primary_descriptor')), namespaceprefix_ , eol_))
        if self.bounding_box is not None:
            namespaceprefix_ = self.bounding_box_nsprefix_ + ':' if (UseCapturedNS_ and self.bounding_box_nsprefix_) else ''
            self.bounding_box.export(outfile, level, namespaceprefix_, namespacedef_='', name_='bounding_box', pretty_print=pretty_print)
        if self.global_external_references is not None:
            namespaceprefix_ = self.global_external_references_nsprefix_ + ':' if (UseCapturedNS_ and self.global_external_references_nsprefix_) else ''
            self.global_external_references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='global_external_references', pretty_print=pretty_print)
        if self.segment_list is not None:
            namespaceprefix_ = self.segment_list_nsprefix_ + ':' if (UseCapturedNS_ and self.segment_list_nsprefix_) else ''
            self.segment_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='segment_list', pretty_print=pretty_print)
        if self.lattice_list is not None:
            namespaceprefix_ = self.lattice_list_nsprefix_ + ':' if (UseCapturedNS_ and self.lattice_list_nsprefix_) else ''
            self.lattice_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lattice_list', pretty_print=pretty_print)
        if self.details is not None:
            namespaceprefix_ = self.details_nsprefix_ + ':' if (UseCapturedNS_ and self.details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdetails>%s</%sdetails>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.details), input_name='details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('schema_version', node)
        if value is not None and 'schema_version' not in already_processed:
            already_processed.add('schema_version')
            self.schema_version = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'version':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'version')
            value_ = self.gds_validate_string(value_, node, 'version')
            self.version = value_
            self.version_nsprefix_ = child_.prefix
        elif nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'software_list':
            obj_ = software_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.software_list = obj_
            obj_.original_tagname_ = 'software_list'
        elif nodeName_ == 'transform_list':
            obj_ = transform_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.transform_list = obj_
            obj_.original_tagname_ = 'transform_list'
        elif nodeName_ == 'primary_descriptor':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'primary_descriptor')
            value_ = self.gds_validate_string(value_, node, 'primary_descriptor')
            self.primary_descriptor = value_
            self.primary_descriptor_nsprefix_ = child_.prefix
            # validate type primary_descriptorType
            self.validate_primary_descriptorType(self.primary_descriptor)
        elif nodeName_ == 'bounding_box':
            obj_ = bounding_box_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.bounding_box = obj_
            obj_.original_tagname_ = 'bounding_box'
        elif nodeName_ == 'global_external_references':
            obj_ = global_external_referencesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.global_external_references = obj_
            obj_.original_tagname_ = 'global_external_references'
        elif nodeName_ == 'segment_list':
            obj_ = segment_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.segment_list = obj_
            obj_.original_tagname_ = 'segment_list'
        elif nodeName_ == 'lattice_list':
            obj_ = lattice_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.lattice_list = obj_
            obj_.original_tagname_ = 'lattice_list'
        elif nodeName_ == 'details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'details')
            value_ = self.gds_validate_string(value_, node, 'details')
            self.details = value_
            self.details_nsprefix_ = child_.prefix
# end class segmentation


class software_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, version=None, processing_details=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.version = version
        self.version_nsprefix_ = None
        self.processing_details = processing_details
        self.processing_details_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, software_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if software_type.subclass:
            return software_type.subclass(*args_, **kwargs_)
        else:
            return software_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_version(self):
        return self.version
    def set_version(self, version):
        self.version = version
    def get_processing_details(self):
        return self.processing_details
    def set_processing_details(self, processing_details):
        self.processing_details = processing_details
    def hasContent_(self):
        if (
            self.name is not None or
            self.version is not None or
            self.processing_details is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='software_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('software_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='software_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='software_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='software_type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='software_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.version is not None:
            namespaceprefix_ = self.version_nsprefix_ + ':' if (UseCapturedNS_ and self.version_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sversion>%s</%sversion>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.version), input_name='version')), namespaceprefix_ , eol_))
        if self.processing_details is not None:
            namespaceprefix_ = self.processing_details_nsprefix_ + ':' if (UseCapturedNS_ and self.processing_details_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprocessing_details>%s</%sprocessing_details>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.processing_details), input_name='processing_details')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'version':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'version')
            value_ = self.gds_validate_string(value_, node, 'version')
            self.version = value_
            self.version_nsprefix_ = child_.prefix
        elif nodeName_ == 'processing_details':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'processing_details')
            value_ = self.gds_validate_string(value_, node, 'processing_details')
            self.processing_details = value_
            self.processing_details_nsprefix_ = child_.prefix
# end class software_type


class transformation_matrix_type(GeneratedsSuper):
    """data is a space-separated sequence of numbers to be converted to
    floats. The number of items in 'data' is equivalent to the product of
    'rows' and
    'cols'."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, rows=None, cols=None, data=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.rows = rows
        self.rows_nsprefix_ = None
        self.cols = cols
        self.cols_nsprefix_ = None
        self.data = data
        self.data_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, transformation_matrix_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if transformation_matrix_type.subclass:
            return transformation_matrix_type.subclass(*args_, **kwargs_)
        else:
            return transformation_matrix_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_rows(self):
        return self.rows
    def set_rows(self, rows):
        self.rows = rows
    def get_cols(self):
        return self.cols
    def set_cols(self, cols):
        self.cols = cols
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def hasContent_(self):
        if (
            self.rows is not None or
            self.cols is not None or
            self.data is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='transformation_matrix_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('transformation_matrix_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='transformation_matrix_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='transformation_matrix_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='transformation_matrix_type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='transformation_matrix_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.rows is not None:
            namespaceprefix_ = self.rows_nsprefix_ + ':' if (UseCapturedNS_ and self.rows_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srows>%s</%srows>%s' % (namespaceprefix_ , self.gds_format_integer(self.rows, input_name='rows'), namespaceprefix_ , eol_))
        if self.cols is not None:
            namespaceprefix_ = self.cols_nsprefix_ + ':' if (UseCapturedNS_ and self.cols_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scols>%s</%scols>%s' % (namespaceprefix_ , self.gds_format_integer(self.cols, input_name='cols'), namespaceprefix_ , eol_))
        if self.data is not None:
            namespaceprefix_ = self.data_nsprefix_ + ':' if (UseCapturedNS_ and self.data_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdata>%s</%sdata>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.data), input_name='data')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'rows' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'rows')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'rows')
            self.rows = ival_
            self.rows_nsprefix_ = child_.prefix
        elif nodeName_ == 'cols' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'cols')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'cols')
            self.cols = ival_
            self.cols_nsprefix_ = child_.prefix
        elif nodeName_ == 'data':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'data')
            value_ = self.gds_validate_string(value_, node, 'data')
            self.data = value_
            self.data_nsprefix_ = child_.prefix
# end class transformation_matrix_type


class bounding_box_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, xmin='0', xmax=None, ymin='0', ymax=None, zmin='0', zmax=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.xmin = _cast(float, xmin)
        self.xmin_nsprefix_ = None
        self.xmax = _cast(float, xmax)
        self.xmax_nsprefix_ = None
        self.ymin = _cast(float, ymin)
        self.ymin_nsprefix_ = None
        self.ymax = _cast(float, ymax)
        self.ymax_nsprefix_ = None
        self.zmin = _cast(float, zmin)
        self.zmin_nsprefix_ = None
        self.zmax = _cast(float, zmax)
        self.zmax_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, bounding_box_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if bounding_box_type.subclass:
            return bounding_box_type.subclass(*args_, **kwargs_)
        else:
            return bounding_box_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_xmin(self):
        return self.xmin
    def set_xmin(self, xmin):
        self.xmin = xmin
    def get_xmax(self):
        return self.xmax
    def set_xmax(self, xmax):
        self.xmax = xmax
    def get_ymin(self):
        return self.ymin
    def set_ymin(self, ymin):
        self.ymin = ymin
    def get_ymax(self):
        return self.ymax
    def set_ymax(self, ymax):
        self.ymax = ymax
    def get_zmin(self):
        return self.zmin
    def set_zmin(self, zmin):
        self.zmin = zmin
    def get_zmax(self):
        return self.zmax
    def set_zmax(self, zmax):
        self.zmax = zmax
    def validate_dimension_type(self, value):
        # Validate type dimension_type, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on dimension_type' % {"value": value, "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='bounding_box_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('bounding_box_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='bounding_box_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='bounding_box_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='bounding_box_type'):
        if self.xmin != 0 and 'xmin' not in already_processed:
            already_processed.add('xmin')
            outfile.write(' xmin="%s"' % self.gds_format_float(self.xmin, input_name='xmin'))
        if self.xmax is not None and 'xmax' not in already_processed:
            already_processed.add('xmax')
            outfile.write(' xmax="%s"' % self.gds_format_float(self.xmax, input_name='xmax'))
        if self.ymin != 0 and 'ymin' not in already_processed:
            already_processed.add('ymin')
            outfile.write(' ymin="%s"' % self.gds_format_float(self.ymin, input_name='ymin'))
        if self.ymax is not None and 'ymax' not in already_processed:
            already_processed.add('ymax')
            outfile.write(' ymax="%s"' % self.gds_format_float(self.ymax, input_name='ymax'))
        if self.zmin != 0 and 'zmin' not in already_processed:
            already_processed.add('zmin')
            outfile.write(' zmin="%s"' % self.gds_format_float(self.zmin, input_name='zmin'))
        if self.zmax is not None and 'zmax' not in already_processed:
            already_processed.add('zmax')
            outfile.write(' zmax="%s"' % self.gds_format_float(self.zmax, input_name='zmax'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='bounding_box_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xmin', node)
        if value is not None and 'xmin' not in already_processed:
            already_processed.add('xmin')
            value = self.gds_parse_float(value, node, 'xmin')
            self.xmin = value
            self.validate_dimension_type(self.xmin)    # validate type dimension_type
        value = find_attr_value_('xmax', node)
        if value is not None and 'xmax' not in already_processed:
            already_processed.add('xmax')
            value = self.gds_parse_float(value, node, 'xmax')
            self.xmax = value
            self.validate_dimension_type(self.xmax)    # validate type dimension_type
        value = find_attr_value_('ymin', node)
        if value is not None and 'ymin' not in already_processed:
            already_processed.add('ymin')
            value = self.gds_parse_float(value, node, 'ymin')
            self.ymin = value
            self.validate_dimension_type(self.ymin)    # validate type dimension_type
        value = find_attr_value_('ymax', node)
        if value is not None and 'ymax' not in already_processed:
            already_processed.add('ymax')
            value = self.gds_parse_float(value, node, 'ymax')
            self.ymax = value
            self.validate_dimension_type(self.ymax)    # validate type dimension_type
        value = find_attr_value_('zmin', node)
        if value is not None and 'zmin' not in already_processed:
            already_processed.add('zmin')
            value = self.gds_parse_float(value, node, 'zmin')
            self.zmin = value
            self.validate_dimension_type(self.zmin)    # validate type dimension_type
        value = find_attr_value_('zmax', node)
        if value is not None and 'zmax' not in already_processed:
            already_processed.add('zmax')
            value = self.gds_parse_float(value, node, 'zmax')
            self.zmax = value
            self.validate_dimension_type(self.zmax)    # validate type dimension_type
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class bounding_box_type


class segment_type(GeneratedsSuper):
    """For the root segmenƒt: parentSegmentID = 0"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, parent_id=None, biological_annotation=None, colour=None, three_d_volume=None, shape_primitive_list=None, mesh_list=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.parent_id = _cast(int, parent_id)
        self.parent_id_nsprefix_ = None
        self.biological_annotation = biological_annotation
        self.biological_annotation_nsprefix_ = None
        self.colour = colour
        self.colour_nsprefix_ = None
        self.three_d_volume = three_d_volume
        self.three_d_volume_nsprefix_ = None
        self.shape_primitive_list = shape_primitive_list
        self.shape_primitive_list_nsprefix_ = None
        self.mesh_list = mesh_list
        self.mesh_list_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, segment_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if segment_type.subclass:
            return segment_type.subclass(*args_, **kwargs_)
        else:
            return segment_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_biological_annotation(self):
        return self.biological_annotation
    def set_biological_annotation(self, biological_annotation):
        self.biological_annotation = biological_annotation
    def get_colour(self):
        return self.colour
    def set_colour(self, colour):
        self.colour = colour
    def get_three_d_volume(self):
        return self.three_d_volume
    def set_three_d_volume(self, three_d_volume):
        self.three_d_volume = three_d_volume
    def get_shape_primitive_list(self):
        return self.shape_primitive_list
    def set_shape_primitive_list(self, shape_primitive_list):
        self.shape_primitive_list = shape_primitive_list
    def get_mesh_list(self):
        return self.mesh_list
    def set_mesh_list(self, mesh_list):
        self.mesh_list = mesh_list
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_parent_id(self):
        return self.parent_id
    def set_parent_id(self, parent_id):
        self.parent_id = parent_id
    def hasContent_(self):
        if (
            self.biological_annotation is not None or
            self.colour is not None or
            self.three_d_volume is not None or
            self.shape_primitive_list is not None or
            self.mesh_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='segment_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('segment_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='segment_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='segment_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='segment_type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
        if self.parent_id is not None and 'parent_id' not in already_processed:
            already_processed.add('parent_id')
            outfile.write(' parent_id="%s"' % self.gds_format_integer(self.parent_id, input_name='parent_id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='segment_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.biological_annotation is not None:
            namespaceprefix_ = self.biological_annotation_nsprefix_ + ':' if (UseCapturedNS_ and self.biological_annotation_nsprefix_) else ''
            self.biological_annotation.export(outfile, level, namespaceprefix_, namespacedef_='', name_='biological_annotation', pretty_print=pretty_print)
        if self.colour is not None:
            namespaceprefix_ = self.colour_nsprefix_ + ':' if (UseCapturedNS_ and self.colour_nsprefix_) else ''
            self.colour.export(outfile, level, namespaceprefix_, namespacedef_='', name_='colour', pretty_print=pretty_print)
        if self.three_d_volume is not None:
            namespaceprefix_ = self.three_d_volume_nsprefix_ + ':' if (UseCapturedNS_ and self.three_d_volume_nsprefix_) else ''
            self.three_d_volume.export(outfile, level, namespaceprefix_, namespacedef_='', name_='three_d_volume', pretty_print=pretty_print)
        if self.shape_primitive_list is not None:
            namespaceprefix_ = self.shape_primitive_list_nsprefix_ + ':' if (UseCapturedNS_ and self.shape_primitive_list_nsprefix_) else ''
            self.shape_primitive_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shape_primitive_list', pretty_print=pretty_print)
        if self.mesh_list is not None:
            namespaceprefix_ = self.mesh_list_nsprefix_ + ':' if (UseCapturedNS_ and self.mesh_list_nsprefix_) else ''
            self.mesh_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mesh_list', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
        value = find_attr_value_('parent_id', node)
        if value is not None and 'parent_id' not in already_processed:
            already_processed.add('parent_id')
            self.parent_id = self.gds_parse_integer(value, node, 'parent_id')
            if self.parent_id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'biological_annotation':
            obj_ = biological_annotationType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.biological_annotation = obj_
            obj_.original_tagname_ = 'biological_annotation'
        elif nodeName_ == 'colour':
            obj_ = rgba_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.colour = obj_
            obj_.original_tagname_ = 'colour'
        elif nodeName_ == 'three_d_volume':
            obj_ = three_d_volume_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.three_d_volume = obj_
            obj_.original_tagname_ = 'three_d_volume'
        elif nodeName_ == 'shape_primitive_list':
            obj_ = shape_primitive_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shape_primitive_list = obj_
            obj_.original_tagname_ = 'shape_primitive_list'
        elif nodeName_ == 'mesh_list':
            obj_ = mesh_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.mesh_list = obj_
            obj_.original_tagname_ = 'mesh_list'
# end class segment_type


class biomolecule_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, valueOf_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, biomolecule_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if biomolecule_type.subclass:
            return biomolecule_type.subclass(*args_, **kwargs_)
        else:
            return biomolecule_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            (1 if type(self.valueOf_) in [int,float] else self.valueOf_)
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='biomolecule_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('biomolecule_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='biomolecule_type')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(self.convert_unicode(self.valueOf_))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='biomolecule_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='biomolecule_type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='biomolecule_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class biomolecule_type


class three_d_volume_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, lattice_id=None, value=None, transform_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.lattice_id = lattice_id
        self.lattice_id_nsprefix_ = None
        self.value = value
        self.value_nsprefix_ = None
        self.transform_id = transform_id
        self.transform_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, three_d_volume_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if three_d_volume_type.subclass:
            return three_d_volume_type.subclass(*args_, **kwargs_)
        else:
            return three_d_volume_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_lattice_id(self):
        return self.lattice_id
    def set_lattice_id(self, lattice_id):
        self.lattice_id = lattice_id
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def get_transform_id(self):
        return self.transform_id
    def set_transform_id(self, transform_id):
        self.transform_id = transform_id
    def hasContent_(self):
        if (
            self.lattice_id is not None or
            self.value is not None or
            self.transform_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='three_d_volume_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('three_d_volume_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='three_d_volume_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='three_d_volume_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='three_d_volume_type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='three_d_volume_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.lattice_id is not None:
            namespaceprefix_ = self.lattice_id_nsprefix_ + ':' if (UseCapturedNS_ and self.lattice_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slattice_id>%s</%slattice_id>%s' % (namespaceprefix_ , self.gds_format_integer(self.lattice_id, input_name='lattice_id'), namespaceprefix_ , eol_))
        if self.value is not None:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespaceprefix_ , self.gds_format_float(self.value, input_name='value'), namespaceprefix_ , eol_))
        if self.transform_id is not None:
            namespaceprefix_ = self.transform_id_nsprefix_ + ':' if (UseCapturedNS_ and self.transform_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransform_id>%s</%stransform_id>%s' % (namespaceprefix_ , self.gds_format_integer(self.transform_id, input_name='transform_id'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'lattice_id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'lattice_id')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'lattice_id')
            self.lattice_id = ival_
            self.lattice_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'value' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'value')
            fval_ = self.gds_validate_float(fval_, node, 'value')
            self.value = fval_
            self.value_nsprefix_ = child_.prefix
        elif nodeName_ == 'transform_id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'transform_id')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transform_id')
            self.transform_id = ival_
            self.transform_id_nsprefix_ = child_.prefix
# end class three_d_volume_type


class lattice_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, mode=None, endianness='little', size=None, start=None, data=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.mode = mode
        self.validate_mode_type(self.mode)
        self.mode_nsprefix_ = None
        self.endianness = endianness
        self.validate_endian_type(self.endianness)
        self.endianness_nsprefix_ = None
        self.size = size
        self.size_nsprefix_ = None
        self.start = start
        self.start_nsprefix_ = None
        self.data = data
        self.data_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, lattice_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if lattice_type.subclass:
            return lattice_type.subclass(*args_, **kwargs_)
        else:
            return lattice_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_mode(self):
        return self.mode
    def set_mode(self, mode):
        self.mode = mode
    def get_endianness(self):
        return self.endianness
    def set_endianness(self, endianness):
        self.endianness = endianness
    def get_size(self):
        return self.size
    def set_size(self, size):
        self.size = size
    def get_start(self):
        return self.start
    def set_start(self, start):
        self.start = start
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_mode_type(self, value):
        result = True
        # Validate type mode_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['int8', 'uint8', 'int16', 'uint16', 'int32', 'uint32', 'int64', 'uint64', 'float32', 'float64']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on mode_type' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def validate_endian_type(self, value):
        result = True
        # Validate type endian_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['little', 'big']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on endian_type' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.mode is not None or
            self.endianness != "little" or
            self.size is not None or
            self.start is not None or
            self.data is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='lattice_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('lattice_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='lattice_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='lattice_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='lattice_type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='lattice_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.mode is not None:
            namespaceprefix_ = self.mode_nsprefix_ + ':' if (UseCapturedNS_ and self.mode_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smode>%s</%smode>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.mode), input_name='mode')), namespaceprefix_ , eol_))
        if self.endianness is not None:
            namespaceprefix_ = self.endianness_nsprefix_ + ':' if (UseCapturedNS_ and self.endianness_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sendianness>%s</%sendianness>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.endianness), input_name='endianness')), namespaceprefix_ , eol_))
        if self.size is not None:
            namespaceprefix_ = self.size_nsprefix_ + ':' if (UseCapturedNS_ and self.size_nsprefix_) else ''
            self.size.export(outfile, level, namespaceprefix_, namespacedef_='', name_='size', pretty_print=pretty_print)
        if self.start is not None:
            namespaceprefix_ = self.start_nsprefix_ + ':' if (UseCapturedNS_ and self.start_nsprefix_) else ''
            self.start.export(outfile, level, namespaceprefix_, namespacedef_='', name_='start', pretty_print=pretty_print)
        if self.data is not None:
            namespaceprefix_ = self.data_nsprefix_ + ':' if (UseCapturedNS_ and self.data_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdata>%s</%sdata>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.data), input_name='data')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'mode':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'mode')
            value_ = self.gds_validate_string(value_, node, 'mode')
            self.mode = value_
            self.mode_nsprefix_ = child_.prefix
            # validate type mode_type
            self.validate_mode_type(self.mode)
        elif nodeName_ == 'endianness':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'endianness')
            value_ = self.gds_validate_string(value_, node, 'endianness')
            self.endianness = value_
            self.endianness_nsprefix_ = child_.prefix
            # validate type endian_type
            self.validate_endian_type(self.endianness)
        elif nodeName_ == 'size':
            obj_ = volume_structure_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.size = obj_
            obj_.original_tagname_ = 'size'
        elif nodeName_ == 'start':
            obj_ = volume_index_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.start = obj_
            obj_.original_tagname_ = 'start'
        elif nodeName_ == 'data':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'data')
            value_ = self.gds_validate_string(value_, node, 'data')
            self.data = value_
            self.data_nsprefix_ = child_.prefix
# end class lattice_type


class mesh_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, vertices=None, normals=None, triangles=None, transform_id=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.vertices = vertices
        self.vertices_nsprefix_ = None
        self.normals = normals
        self.normals_nsprefix_ = None
        self.triangles = triangles
        self.triangles_nsprefix_ = None
        self.transform_id = transform_id
        self.transform_id_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, mesh_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if mesh_type.subclass:
            return mesh_type.subclass(*args_, **kwargs_)
        else:
            return mesh_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_vertices(self):
        return self.vertices
    def set_vertices(self, vertices):
        self.vertices = vertices
    def get_normals(self):
        return self.normals
    def set_normals(self, normals):
        self.normals = normals
    def get_triangles(self):
        return self.triangles
    def set_triangles(self, triangles):
        self.triangles = triangles
    def get_transform_id(self):
        return self.transform_id
    def set_transform_id(self, transform_id):
        self.transform_id = transform_id
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def hasContent_(self):
        if (
            self.vertices is not None or
            self.normals is not None or
            self.triangles is not None or
            self.transform_id is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='mesh_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('mesh_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='mesh_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='mesh_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='mesh_type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='mesh_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.vertices is not None:
            namespaceprefix_ = self.vertices_nsprefix_ + ':' if (UseCapturedNS_ and self.vertices_nsprefix_) else ''
            self.vertices.export(outfile, level, namespaceprefix_, namespacedef_='', name_='vertices', pretty_print=pretty_print)
        if self.normals is not None:
            namespaceprefix_ = self.normals_nsprefix_ + ':' if (UseCapturedNS_ and self.normals_nsprefix_) else ''
            self.normals.export(outfile, level, namespaceprefix_, namespacedef_='', name_='normals', pretty_print=pretty_print)
        if self.triangles is not None:
            namespaceprefix_ = self.triangles_nsprefix_ + ':' if (UseCapturedNS_ and self.triangles_nsprefix_) else ''
            self.triangles.export(outfile, level, namespaceprefix_, namespacedef_='', name_='triangles', pretty_print=pretty_print)
        if self.transform_id is not None:
            namespaceprefix_ = self.transform_id_nsprefix_ + ':' if (UseCapturedNS_ and self.transform_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransform_id>%s</%stransform_id>%s' % (namespaceprefix_ , self.gds_format_integer(self.transform_id, input_name='transform_id'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'vertices':
            obj_ = vertices_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.vertices = obj_
            obj_.original_tagname_ = 'vertices'
        elif nodeName_ == 'normals':
            obj_ = normals_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.normals = obj_
            obj_.original_tagname_ = 'normals'
        elif nodeName_ == 'triangles':
            obj_ = triangles_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.triangles = obj_
            obj_.original_tagname_ = 'triangles'
        elif nodeName_ == 'transform_id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'transform_id')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transform_id')
            self.transform_id = ival_
            self.transform_id_nsprefix_ = child_.prefix
# end class mesh_type


class vertices_type(GeneratedsSuper):
    """The 'data' attribute is a base64-encoded binary sequence of float
    (default: float32) triples. The 0-based position is the index used when
    constructing
    triangles (see 'triangles_type' definition)."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, num_vertices=None, mode='float32', endianness='little', data=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.num_vertices = _cast(int, num_vertices)
        self.num_vertices_nsprefix_ = None
        self.mode = _cast(None, mode)
        self.mode_nsprefix_ = None
        self.endianness = _cast(None, endianness)
        self.endianness_nsprefix_ = None
        self.data = _cast(None, data)
        self.data_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, vertices_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if vertices_type.subclass:
            return vertices_type.subclass(*args_, **kwargs_)
        else:
            return vertices_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_num_vertices(self):
        return self.num_vertices
    def set_num_vertices(self, num_vertices):
        self.num_vertices = num_vertices
    def get_mode(self):
        return self.mode
    def set_mode(self, mode):
        self.mode = mode
    def get_endianness(self):
        return self.endianness
    def set_endianness(self, endianness):
        self.endianness = endianness
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def validate_mode_type(self, value):
        # Validate type mode_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['int8', 'uint8', 'int16', 'uint16', 'int32', 'uint32', 'int64', 'uint64', 'float32', 'float64']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on mode_type' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_endian_type(self, value):
        # Validate type endian_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['little', 'big']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on endian_type' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='vertices_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('vertices_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='vertices_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='vertices_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='vertices_type'):
        if self.num_vertices is not None and 'num_vertices' not in already_processed:
            already_processed.add('num_vertices')
            outfile.write(' num_vertices="%s"' % self.gds_format_integer(self.num_vertices, input_name='num_vertices'))
        if self.mode != "float32" and 'mode' not in already_processed:
            already_processed.add('mode')
            outfile.write(' mode=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.mode), input_name='mode')), ))
        if self.endianness != "little" and 'endianness' not in already_processed:
            already_processed.add('endianness')
            outfile.write(' endianness=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.endianness), input_name='endianness')), ))
        if self.data is not None and 'data' not in already_processed:
            already_processed.add('data')
            outfile.write(' data=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.data), input_name='data')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='vertices_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('num_vertices', node)
        if value is not None and 'num_vertices' not in already_processed:
            already_processed.add('num_vertices')
            self.num_vertices = self.gds_parse_integer(value, node, 'num_vertices')
            if self.num_vertices < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('mode', node)
        if value is not None and 'mode' not in already_processed:
            already_processed.add('mode')
            self.mode = value
            self.validate_mode_type(self.mode)    # validate type mode_type
        value = find_attr_value_('endianness', node)
        if value is not None and 'endianness' not in already_processed:
            already_processed.add('endianness')
            self.endianness = value
            self.validate_endian_type(self.endianness)    # validate type endian_type
        value = find_attr_value_('data', node)
        if value is not None and 'data' not in already_processed:
            already_processed.add('data')
            self.data = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class vertices_type


class normals_type(GeneratedsSuper):
    """The 'data' attribute is a base64-encoded binary sequence of float
    (default: float32) triples. The 0-based position is the index used when
    constructing
    triangles (see 'triangles_type' definition)."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, num_normals=None, mode='float32', endianness='little', data=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.num_normals = _cast(int, num_normals)
        self.num_normals_nsprefix_ = None
        self.mode = _cast(None, mode)
        self.mode_nsprefix_ = None
        self.endianness = _cast(None, endianness)
        self.endianness_nsprefix_ = None
        self.data = _cast(None, data)
        self.data_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, normals_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if normals_type.subclass:
            return normals_type.subclass(*args_, **kwargs_)
        else:
            return normals_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_num_normals(self):
        return self.num_normals
    def set_num_normals(self, num_normals):
        self.num_normals = num_normals
    def get_mode(self):
        return self.mode
    def set_mode(self, mode):
        self.mode = mode
    def get_endianness(self):
        return self.endianness
    def set_endianness(self, endianness):
        self.endianness = endianness
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def validate_mode_type(self, value):
        # Validate type mode_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['int8', 'uint8', 'int16', 'uint16', 'int32', 'uint32', 'int64', 'uint64', 'float32', 'float64']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on mode_type' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_endian_type(self, value):
        # Validate type endian_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['little', 'big']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on endian_type' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='normals_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('normals_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='normals_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='normals_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='normals_type'):
        if self.num_normals is not None and 'num_normals' not in already_processed:
            already_processed.add('num_normals')
            outfile.write(' num_normals="%s"' % self.gds_format_integer(self.num_normals, input_name='num_normals'))
        if self.mode != "float32" and 'mode' not in already_processed:
            already_processed.add('mode')
            outfile.write(' mode=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.mode), input_name='mode')), ))
        if self.endianness != "little" and 'endianness' not in already_processed:
            already_processed.add('endianness')
            outfile.write(' endianness=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.endianness), input_name='endianness')), ))
        if self.data is not None and 'data' not in already_processed:
            already_processed.add('data')
            outfile.write(' data=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.data), input_name='data')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='normals_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('num_normals', node)
        if value is not None and 'num_normals' not in already_processed:
            already_processed.add('num_normals')
            self.num_normals = self.gds_parse_integer(value, node, 'num_normals')
            if self.num_normals < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('mode', node)
        if value is not None and 'mode' not in already_processed:
            already_processed.add('mode')
            self.mode = value
            self.validate_mode_type(self.mode)    # validate type mode_type
        value = find_attr_value_('endianness', node)
        if value is not None and 'endianness' not in already_processed:
            already_processed.add('endianness')
            self.endianness = value
            self.validate_endian_type(self.endianness)    # validate type endian_type
        value = find_attr_value_('data', node)
        if value is not None and 'data' not in already_processed:
            already_processed.add('data')
            self.data = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class normals_type


class triangles_type(GeneratedsSuper):
    """The 'data' attribute is a base64-encoded binary sequence of int
    (default: uint32) triples. The values are 0-based indices of the vertices
    in the
    'vertices' mesh attribute."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, num_triangles=None, mode='uint32', endianness='little', data=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.num_triangles = _cast(int, num_triangles)
        self.num_triangles_nsprefix_ = None
        self.mode = _cast(None, mode)
        self.mode_nsprefix_ = None
        self.endianness = _cast(None, endianness)
        self.endianness_nsprefix_ = None
        self.data = _cast(None, data)
        self.data_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, triangles_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if triangles_type.subclass:
            return triangles_type.subclass(*args_, **kwargs_)
        else:
            return triangles_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_num_triangles(self):
        return self.num_triangles
    def set_num_triangles(self, num_triangles):
        self.num_triangles = num_triangles
    def get_mode(self):
        return self.mode
    def set_mode(self, mode):
        self.mode = mode
    def get_endianness(self):
        return self.endianness
    def set_endianness(self, endianness):
        self.endianness = endianness
    def get_data(self):
        return self.data
    def set_data(self, data):
        self.data = data
    def validate_mode_type(self, value):
        # Validate type mode_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['int8', 'uint8', 'int16', 'uint16', 'int32', 'uint32', 'int64', 'uint64', 'float32', 'float64']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on mode_type' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def validate_endian_type(self, value):
        # Validate type endian_type, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['little', 'big']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on endian_type' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='triangles_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('triangles_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='triangles_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='triangles_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='triangles_type'):
        if self.num_triangles is not None and 'num_triangles' not in already_processed:
            already_processed.add('num_triangles')
            outfile.write(' num_triangles="%s"' % self.gds_format_integer(self.num_triangles, input_name='num_triangles'))
        if self.mode != "uint32" and 'mode' not in already_processed:
            already_processed.add('mode')
            outfile.write(' mode=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.mode), input_name='mode')), ))
        if self.endianness != "little" and 'endianness' not in already_processed:
            already_processed.add('endianness')
            outfile.write(' endianness=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.endianness), input_name='endianness')), ))
        if self.data is not None and 'data' not in already_processed:
            already_processed.add('data')
            outfile.write(' data=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.data), input_name='data')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='triangles_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('num_triangles', node)
        if value is not None and 'num_triangles' not in already_processed:
            already_processed.add('num_triangles')
            self.num_triangles = self.gds_parse_integer(value, node, 'num_triangles')
            if self.num_triangles < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('mode', node)
        if value is not None and 'mode' not in already_processed:
            already_processed.add('mode')
            self.mode = value
            self.validate_mode_type(self.mode)    # validate type mode_type
        value = find_attr_value_('endianness', node)
        if value is not None and 'endianness' not in already_processed:
            already_processed.add('endianness')
            self.endianness = value
            self.validate_endian_type(self.endianness)    # validate type endian_type
        value = find_attr_value_('data', node)
        if value is not None and 'data' not in already_processed:
            already_processed.add('data')
            self.data = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class triangles_type


class rgba_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, red=None, green=None, blue=None, alpha=1.0, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.red = red
        self.validate_colour_channel_type(self.red)
        self.red_nsprefix_ = None
        self.green = green
        self.validate_colour_channel_type(self.green)
        self.green_nsprefix_ = None
        self.blue = blue
        self.validate_colour_channel_type(self.blue)
        self.blue_nsprefix_ = None
        self.alpha = alpha
        self.validate_colour_channel_type(self.alpha)
        self.alpha_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, rgba_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if rgba_type.subclass:
            return rgba_type.subclass(*args_, **kwargs_)
        else:
            return rgba_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_red(self):
        return self.red
    def set_red(self, red):
        self.red = red
    def get_green(self):
        return self.green
    def set_green(self, green):
        self.green = green
    def get_blue(self):
        return self.blue
    def set_blue(self, blue):
        self.blue = blue
    def get_alpha(self):
        return self.alpha
    def set_alpha(self, alpha):
        self.alpha = alpha
    def validate_colour_channel_type(self, value):
        result = True
        # Validate type colour_channel_type, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on colour_channel_type' % {"value": value, "lineno": lineno} )
                result = False
            if value > 1.0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on colour_channel_type' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.red is not None or
            self.green is not None or
            self.blue is not None or
            self.alpha != 1.0
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='rgba_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('rgba_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='rgba_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='rgba_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='rgba_type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='rgba_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.red is not None:
            namespaceprefix_ = self.red_nsprefix_ + ':' if (UseCapturedNS_ and self.red_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sred>%s</%sred>%s' % (namespaceprefix_ , self.gds_format_float(self.red, input_name='red'), namespaceprefix_ , eol_))
        if self.green is not None:
            namespaceprefix_ = self.green_nsprefix_ + ':' if (UseCapturedNS_ and self.green_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgreen>%s</%sgreen>%s' % (namespaceprefix_ , self.gds_format_float(self.green, input_name='green'), namespaceprefix_ , eol_))
        if self.blue is not None:
            namespaceprefix_ = self.blue_nsprefix_ + ':' if (UseCapturedNS_ and self.blue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sblue>%s</%sblue>%s' % (namespaceprefix_ , self.gds_format_float(self.blue, input_name='blue'), namespaceprefix_ , eol_))
        if self.alpha != 1.0:
            namespaceprefix_ = self.alpha_nsprefix_ + ':' if (UseCapturedNS_ and self.alpha_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%salpha>%s</%salpha>%s' % (namespaceprefix_ , self.gds_format_float(self.alpha, input_name='alpha'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'red' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'red')
            fval_ = self.gds_validate_float(fval_, node, 'red')
            self.red = fval_
            self.red_nsprefix_ = child_.prefix
            # validate type colour_channel_type
            self.validate_colour_channel_type(self.red)
        elif nodeName_ == 'green' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'green')
            fval_ = self.gds_validate_float(fval_, node, 'green')
            self.green = fval_
            self.green_nsprefix_ = child_.prefix
            # validate type colour_channel_type
            self.validate_colour_channel_type(self.green)
        elif nodeName_ == 'blue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'blue')
            fval_ = self.gds_validate_float(fval_, node, 'blue')
            self.blue = fval_
            self.blue_nsprefix_ = child_.prefix
            # validate type colour_channel_type
            self.validate_colour_channel_type(self.blue)
        elif nodeName_ == 'alpha' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'alpha')
            fval_ = self.gds_validate_float(fval_, node, 'alpha')
            self.alpha = fval_
            self.alpha_nsprefix_ = child_.prefix
            # validate type colour_channel_type
            self.validate_colour_channel_type(self.alpha)
# end class rgba_type


class float_vector_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, x=None, y=None, z=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.x = _cast(float, x)
        self.x_nsprefix_ = None
        self.y = _cast(float, y)
        self.y_nsprefix_ = None
        self.z = _cast(float, z)
        self.z_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, float_vector_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if float_vector_type.subclass:
            return float_vector_type.subclass(*args_, **kwargs_)
        else:
            return float_vector_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_x(self):
        return self.x
    def set_x(self, x):
        self.x = x
    def get_y(self):
        return self.y
    def set_y(self, y):
        self.y = y
    def get_z(self):
        return self.z
    def set_z(self, z):
        self.z = z
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='float_vector_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('float_vector_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='float_vector_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='float_vector_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='float_vector_type'):
        if self.x is not None and 'x' not in already_processed:
            already_processed.add('x')
            outfile.write(' x="%s"' % self.gds_format_float(self.x, input_name='x'))
        if self.y is not None and 'y' not in already_processed:
            already_processed.add('y')
            outfile.write(' y="%s"' % self.gds_format_float(self.y, input_name='y'))
        if self.z is not None and 'z' not in already_processed:
            already_processed.add('z')
            outfile.write(' z="%s"' % self.gds_format_float(self.z, input_name='z'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='float_vector_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('x', node)
        if value is not None and 'x' not in already_processed:
            already_processed.add('x')
            value = self.gds_parse_float(value, node, 'x')
            self.x = value
        value = find_attr_value_('y', node)
        if value is not None and 'y' not in already_processed:
            already_processed.add('y')
            value = self.gds_parse_float(value, node, 'y')
            self.y = value
        value = find_attr_value_('z', node)
        if value is not None and 'z' not in already_processed:
            already_processed.add('z')
            value = self.gds_parse_float(value, node, 'z')
            self.z = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class float_vector_type


class external_reference_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, resource=None, url=None, accession=None, label=None, description=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.resource = _cast(None, resource)
        self.resource_nsprefix_ = None
        self.url = _cast(None, url)
        self.url_nsprefix_ = None
        self.accession = _cast(None, accession)
        self.accession_nsprefix_ = None
        self.label = _cast(None, label)
        self.label_nsprefix_ = None
        self.description = _cast(None, description)
        self.description_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, external_reference_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if external_reference_type.subclass:
            return external_reference_type.subclass(*args_, **kwargs_)
        else:
            return external_reference_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_resource(self):
        return self.resource
    def set_resource(self, resource):
        self.resource = resource
    def get_url(self):
        return self.url
    def set_url(self, url):
        self.url = url
    def get_accession(self):
        return self.accession
    def set_accession(self, accession):
        self.accession = accession
    def get_label(self):
        return self.label
    def set_label(self, label):
        self.label = label
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='external_reference_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('external_reference_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='external_reference_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='external_reference_type', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='external_reference_type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
        if self.resource is not None and 'resource' not in already_processed:
            already_processed.add('resource')
            outfile.write(' resource=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.resource), input_name='resource')), ))
        if self.url is not None and 'url' not in already_processed:
            already_processed.add('url')
            outfile.write(' url=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.url), input_name='url')), ))
        if self.accession is not None and 'accession' not in already_processed:
            already_processed.add('accession')
            outfile.write(' accession=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.accession), input_name='accession')), ))
        if self.label is not None and 'label' not in already_processed:
            already_processed.add('label')
            outfile.write(' label=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.label), input_name='label')), ))
        if self.description is not None and 'description' not in already_processed:
            already_processed.add('description')
            outfile.write(' description=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.description), input_name='description')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='external_reference_type', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('resource', node)
        if value is not None and 'resource' not in already_processed:
            already_processed.add('resource')
            self.resource = value
        value = find_attr_value_('url', node)
        if value is not None and 'url' not in already_processed:
            already_processed.add('url')
            self.url = value
        value = find_attr_value_('accession', node)
        if value is not None and 'accession' not in already_processed:
            already_processed.add('accession')
            self.accession = value
        value = find_attr_value_('label', node)
        if value is not None and 'label' not in already_processed:
            already_processed.add('label')
            self.label = value
        value = find_attr_value_('description', node)
        if value is not None and 'description' not in already_processed:
            already_processed.add('description')
            self.description = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class external_reference_type


class volume_structure_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, cols=None, rows=None, sections=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cols = cols
        self.cols_nsprefix_ = None
        self.rows = rows
        self.rows_nsprefix_ = None
        self.sections = sections
        self.sections_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, volume_structure_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if volume_structure_type.subclass:
            return volume_structure_type.subclass(*args_, **kwargs_)
        else:
            return volume_structure_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_cols(self):
        return self.cols
    def set_cols(self, cols):
        self.cols = cols
    def get_rows(self):
        return self.rows
    def set_rows(self, rows):
        self.rows = rows
    def get_sections(self):
        return self.sections
    def set_sections(self, sections):
        self.sections = sections
    def hasContent_(self):
        if (
            self.cols is not None or
            self.rows is not None or
            self.sections is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='volume_structure_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('volume_structure_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='volume_structure_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='volume_structure_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='volume_structure_type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='volume_structure_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cols is not None:
            namespaceprefix_ = self.cols_nsprefix_ + ':' if (UseCapturedNS_ and self.cols_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scols>%s</%scols>%s' % (namespaceprefix_ , self.gds_format_integer(self.cols, input_name='cols'), namespaceprefix_ , eol_))
        if self.rows is not None:
            namespaceprefix_ = self.rows_nsprefix_ + ':' if (UseCapturedNS_ and self.rows_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srows>%s</%srows>%s' % (namespaceprefix_ , self.gds_format_integer(self.rows, input_name='rows'), namespaceprefix_ , eol_))
        if self.sections is not None:
            namespaceprefix_ = self.sections_nsprefix_ + ':' if (UseCapturedNS_ and self.sections_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssections>%s</%ssections>%s' % (namespaceprefix_ , self.gds_format_integer(self.sections, input_name='sections'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cols' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'cols')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'cols')
            self.cols = ival_
            self.cols_nsprefix_ = child_.prefix
        elif nodeName_ == 'rows' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'rows')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'rows')
            self.rows = ival_
            self.rows_nsprefix_ = child_.prefix
        elif nodeName_ == 'sections' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'sections')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'sections')
            self.sections = ival_
            self.sections_nsprefix_ = child_.prefix
# end class volume_structure_type


class volume_index_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, cols=None, rows=None, sections=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.cols = cols
        self.cols_nsprefix_ = None
        self.rows = rows
        self.rows_nsprefix_ = None
        self.sections = sections
        self.sections_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, volume_index_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if volume_index_type.subclass:
            return volume_index_type.subclass(*args_, **kwargs_)
        else:
            return volume_index_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_cols(self):
        return self.cols
    def set_cols(self, cols):
        self.cols = cols
    def get_rows(self):
        return self.rows
    def set_rows(self, rows):
        self.rows = rows
    def get_sections(self):
        return self.sections
    def set_sections(self, sections):
        self.sections = sections
    def hasContent_(self):
        if (
            self.cols is not None or
            self.rows is not None or
            self.sections is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='volume_index_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('volume_index_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='volume_index_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='volume_index_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='volume_index_type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='volume_index_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.cols is not None:
            namespaceprefix_ = self.cols_nsprefix_ + ':' if (UseCapturedNS_ and self.cols_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scols>%s</%scols>%s' % (namespaceprefix_ , self.gds_format_integer(self.cols, input_name='cols'), namespaceprefix_ , eol_))
        if self.rows is not None:
            namespaceprefix_ = self.rows_nsprefix_ + ':' if (UseCapturedNS_ and self.rows_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srows>%s</%srows>%s' % (namespaceprefix_ , self.gds_format_integer(self.rows, input_name='rows'), namespaceprefix_ , eol_))
        if self.sections is not None:
            namespaceprefix_ = self.sections_nsprefix_ + ':' if (UseCapturedNS_ and self.sections_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssections>%s</%ssections>%s' % (namespaceprefix_ , self.gds_format_integer(self.sections, input_name='sections'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'cols' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'cols')
            ival_ = self.gds_validate_integer(ival_, node, 'cols')
            self.cols = ival_
            self.cols_nsprefix_ = child_.prefix
        elif nodeName_ == 'rows' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'rows')
            ival_ = self.gds_validate_integer(ival_, node, 'rows')
            self.rows = ival_
            self.rows_nsprefix_ = child_.prefix
        elif nodeName_ == 'sections' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'sections')
            ival_ = self.gds_validate_integer(ival_, node, 'sections')
            self.sections = ival_
            self.sections_nsprefix_ = child_.prefix
# end class volume_index_type


class shape_primitive(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, shape_primitive)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if shape_primitive.subclass:
            return shape_primitive.subclass(*args_, **kwargs_)
        else:
            return shape_primitive(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='shape_primitive', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('shape_primitive')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='shape_primitive')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='shape_primitive', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='shape_primitive'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='shape_primitive', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class shape_primitive


class cuboid(GeneratedsSuper):
    """3D rectangle'attribute' could refer to figure of merit (FOM)"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, x=None, y=None, z=None, transform_id=None, attribute=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.x = x
        self.validate_dimension_type(self.x)
        self.x_nsprefix_ = None
        self.y = y
        self.validate_dimension_type(self.y)
        self.y_nsprefix_ = None
        self.z = z
        self.validate_dimension_type(self.z)
        self.z_nsprefix_ = None
        self.transform_id = transform_id
        self.transform_id_nsprefix_ = None
        self.attribute = attribute
        self.attribute_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cuboid)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cuboid.subclass:
            return cuboid.subclass(*args_, **kwargs_)
        else:
            return cuboid(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_x(self):
        return self.x
    def set_x(self, x):
        self.x = x
    def get_y(self):
        return self.y
    def set_y(self, y):
        self.y = y
    def get_z(self):
        return self.z
    def set_z(self, z):
        self.z = z
    def get_transform_id(self):
        return self.transform_id
    def set_transform_id(self, transform_id):
        self.transform_id = transform_id
    def get_attribute(self):
        return self.attribute
    def set_attribute(self, attribute):
        self.attribute = attribute
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_dimension_type(self, value):
        result = True
        # Validate type dimension_type, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on dimension_type' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None or
            self.transform_id is not None or
            self.attribute is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cuboid', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cuboid')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cuboid')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='cuboid', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='cuboid'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cuboid', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            namespaceprefix_ = self.x_nsprefix_ + ':' if (UseCapturedNS_ and self.x_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespaceprefix_ , self.gds_format_float(self.x, input_name='x'), namespaceprefix_ , eol_))
        if self.y is not None:
            namespaceprefix_ = self.y_nsprefix_ + ':' if (UseCapturedNS_ and self.y_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespaceprefix_ , self.gds_format_float(self.y, input_name='y'), namespaceprefix_ , eol_))
        if self.z is not None:
            namespaceprefix_ = self.z_nsprefix_ + ':' if (UseCapturedNS_ and self.z_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespaceprefix_ , self.gds_format_float(self.z, input_name='z'), namespaceprefix_ , eol_))
        if self.transform_id is not None:
            namespaceprefix_ = self.transform_id_nsprefix_ + ':' if (UseCapturedNS_ and self.transform_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransform_id>%s</%stransform_id>%s' % (namespaceprefix_ , self.gds_format_integer(self.transform_id, input_name='transform_id'), namespaceprefix_ , eol_))
        if self.attribute is not None:
            namespaceprefix_ = self.attribute_nsprefix_ + ':' if (UseCapturedNS_ and self.attribute_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattribute>%s</%sattribute>%s' % (namespaceprefix_ , self.gds_format_float(self.attribute, input_name='attribute'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'x' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'x')
            fval_ = self.gds_validate_float(fval_, node, 'x')
            self.x = fval_
            self.x_nsprefix_ = child_.prefix
            # validate type dimension_type
            self.validate_dimension_type(self.x)
        elif nodeName_ == 'y' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'y')
            fval_ = self.gds_validate_float(fval_, node, 'y')
            self.y = fval_
            self.y_nsprefix_ = child_.prefix
            # validate type dimension_type
            self.validate_dimension_type(self.y)
        elif nodeName_ == 'z' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'z')
            fval_ = self.gds_validate_float(fval_, node, 'z')
            self.z = fval_
            self.z_nsprefix_ = child_.prefix
            # validate type dimension_type
            self.validate_dimension_type(self.z)
        elif nodeName_ == 'transform_id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'transform_id')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transform_id')
            self.transform_id = ival_
            self.transform_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'attribute' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'attribute')
            fval_ = self.gds_validate_float(fval_, node, 'attribute')
            self.attribute = fval_
            self.attribute_nsprefix_ = child_.prefix
# end class cuboid


class ellipsoid(GeneratedsSuper):
    """3D sphere"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, x=None, y=None, z=None, transform_id=None, attribute=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.x = x
        self.validate_dimension_type(self.x)
        self.x_nsprefix_ = None
        self.y = y
        self.validate_dimension_type(self.y)
        self.y_nsprefix_ = None
        self.z = z
        self.validate_dimension_type(self.z)
        self.z_nsprefix_ = None
        self.transform_id = transform_id
        self.transform_id_nsprefix_ = None
        self.attribute = attribute
        self.attribute_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ellipsoid)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ellipsoid.subclass:
            return ellipsoid.subclass(*args_, **kwargs_)
        else:
            return ellipsoid(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_x(self):
        return self.x
    def set_x(self, x):
        self.x = x
    def get_y(self):
        return self.y
    def set_y(self, y):
        self.y = y
    def get_z(self):
        return self.z
    def set_z(self, z):
        self.z = z
    def get_transform_id(self):
        return self.transform_id
    def set_transform_id(self, transform_id):
        self.transform_id = transform_id
    def get_attribute(self):
        return self.attribute
    def set_attribute(self, attribute):
        self.attribute = attribute
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_dimension_type(self, value):
        result = True
        # Validate type dimension_type, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on dimension_type' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None or
            self.transform_id is not None or
            self.attribute is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ellipsoid', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('ellipsoid')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='ellipsoid')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='ellipsoid', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='ellipsoid'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='ellipsoid', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            namespaceprefix_ = self.x_nsprefix_ + ':' if (UseCapturedNS_ and self.x_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespaceprefix_ , self.gds_format_float(self.x, input_name='x'), namespaceprefix_ , eol_))
        if self.y is not None:
            namespaceprefix_ = self.y_nsprefix_ + ':' if (UseCapturedNS_ and self.y_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespaceprefix_ , self.gds_format_float(self.y, input_name='y'), namespaceprefix_ , eol_))
        if self.z is not None:
            namespaceprefix_ = self.z_nsprefix_ + ':' if (UseCapturedNS_ and self.z_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespaceprefix_ , self.gds_format_float(self.z, input_name='z'), namespaceprefix_ , eol_))
        if self.transform_id is not None:
            namespaceprefix_ = self.transform_id_nsprefix_ + ':' if (UseCapturedNS_ and self.transform_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransform_id>%s</%stransform_id>%s' % (namespaceprefix_ , self.gds_format_integer(self.transform_id, input_name='transform_id'), namespaceprefix_ , eol_))
        if self.attribute is not None:
            namespaceprefix_ = self.attribute_nsprefix_ + ':' if (UseCapturedNS_ and self.attribute_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattribute>%s</%sattribute>%s' % (namespaceprefix_ , self.gds_format_float(self.attribute, input_name='attribute'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'x' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'x')
            fval_ = self.gds_validate_float(fval_, node, 'x')
            self.x = fval_
            self.x_nsprefix_ = child_.prefix
            # validate type dimension_type
            self.validate_dimension_type(self.x)
        elif nodeName_ == 'y' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'y')
            fval_ = self.gds_validate_float(fval_, node, 'y')
            self.y = fval_
            self.y_nsprefix_ = child_.prefix
            # validate type dimension_type
            self.validate_dimension_type(self.y)
        elif nodeName_ == 'z' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'z')
            fval_ = self.gds_validate_float(fval_, node, 'z')
            self.z = fval_
            self.z_nsprefix_ = child_.prefix
            # validate type dimension_type
            self.validate_dimension_type(self.z)
        elif nodeName_ == 'transform_id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'transform_id')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transform_id')
            self.transform_id = ival_
            self.transform_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'attribute' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'attribute')
            fval_ = self.gds_validate_float(fval_, node, 'attribute')
            self.attribute = fval_
            self.attribute_nsprefix_ = child_.prefix
# end class ellipsoid


class cylinder(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, height=None, diameter=None, transform_id=None, attribute=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.height = height
        self.validate_dimension_type(self.height)
        self.height_nsprefix_ = None
        self.diameter = diameter
        self.validate_dimension_type(self.diameter)
        self.diameter_nsprefix_ = None
        self.transform_id = transform_id
        self.transform_id_nsprefix_ = None
        self.attribute = attribute
        self.attribute_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cylinder)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cylinder.subclass:
            return cylinder.subclass(*args_, **kwargs_)
        else:
            return cylinder(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_height(self):
        return self.height
    def set_height(self, height):
        self.height = height
    def get_diameter(self):
        return self.diameter
    def set_diameter(self, diameter):
        self.diameter = diameter
    def get_transform_id(self):
        return self.transform_id
    def set_transform_id(self, transform_id):
        self.transform_id = transform_id
    def get_attribute(self):
        return self.attribute
    def set_attribute(self, attribute):
        self.attribute = attribute
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_dimension_type(self, value):
        result = True
        # Validate type dimension_type, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on dimension_type' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.height is not None or
            self.diameter is not None or
            self.transform_id is not None or
            self.attribute is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cylinder', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cylinder')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cylinder')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='cylinder', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='cylinder'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cylinder', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.height is not None:
            namespaceprefix_ = self.height_nsprefix_ + ':' if (UseCapturedNS_ and self.height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sheight>%s</%sheight>%s' % (namespaceprefix_ , self.gds_format_float(self.height, input_name='height'), namespaceprefix_ , eol_))
        if self.diameter is not None:
            namespaceprefix_ = self.diameter_nsprefix_ + ':' if (UseCapturedNS_ and self.diameter_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdiameter>%s</%sdiameter>%s' % (namespaceprefix_ , self.gds_format_float(self.diameter, input_name='diameter'), namespaceprefix_ , eol_))
        if self.transform_id is not None:
            namespaceprefix_ = self.transform_id_nsprefix_ + ':' if (UseCapturedNS_ and self.transform_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransform_id>%s</%stransform_id>%s' % (namespaceprefix_ , self.gds_format_integer(self.transform_id, input_name='transform_id'), namespaceprefix_ , eol_))
        if self.attribute is not None:
            namespaceprefix_ = self.attribute_nsprefix_ + ':' if (UseCapturedNS_ and self.attribute_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattribute>%s</%sattribute>%s' % (namespaceprefix_ , self.gds_format_float(self.attribute, input_name='attribute'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'height' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'height')
            fval_ = self.gds_validate_float(fval_, node, 'height')
            self.height = fval_
            self.height_nsprefix_ = child_.prefix
            # validate type dimension_type
            self.validate_dimension_type(self.height)
        elif nodeName_ == 'diameter' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'diameter')
            fval_ = self.gds_validate_float(fval_, node, 'diameter')
            self.diameter = fval_
            self.diameter_nsprefix_ = child_.prefix
            # validate type dimension_type
            self.validate_dimension_type(self.diameter)
        elif nodeName_ == 'transform_id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'transform_id')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transform_id')
            self.transform_id = ival_
            self.transform_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'attribute' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'attribute')
            fval_ = self.gds_validate_float(fval_, node, 'attribute')
            self.attribute = fval_
            self.attribute_nsprefix_ = child_.prefix
# end class cylinder


class cone(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, height=None, bottom_radius=None, transform_id=None, attribute=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.height = height
        self.validate_dimension_type(self.height)
        self.height_nsprefix_ = None
        self.bottom_radius = bottom_radius
        self.validate_dimension_type(self.bottom_radius)
        self.bottom_radius_nsprefix_ = None
        self.transform_id = transform_id
        self.transform_id_nsprefix_ = None
        self.attribute = attribute
        self.attribute_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, cone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if cone.subclass:
            return cone.subclass(*args_, **kwargs_)
        else:
            return cone(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_height(self):
        return self.height
    def set_height(self, height):
        self.height = height
    def get_bottom_radius(self):
        return self.bottom_radius
    def set_bottom_radius(self, bottom_radius):
        self.bottom_radius = bottom_radius
    def get_transform_id(self):
        return self.transform_id
    def set_transform_id(self, transform_id):
        self.transform_id = transform_id
    def get_attribute(self):
        return self.attribute
    def set_attribute(self, attribute):
        self.attribute = attribute
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_dimension_type(self, value):
        result = True
        # Validate type dimension_type, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on dimension_type' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.height is not None or
            self.bottom_radius is not None or
            self.transform_id is not None or
            self.attribute is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cone', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('cone')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='cone')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='cone', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='cone'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='cone', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.height is not None:
            namespaceprefix_ = self.height_nsprefix_ + ':' if (UseCapturedNS_ and self.height_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sheight>%s</%sheight>%s' % (namespaceprefix_ , self.gds_format_float(self.height, input_name='height'), namespaceprefix_ , eol_))
        if self.bottom_radius is not None:
            namespaceprefix_ = self.bottom_radius_nsprefix_ + ':' if (UseCapturedNS_ and self.bottom_radius_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbottom_radius>%s</%sbottom_radius>%s' % (namespaceprefix_ , self.gds_format_float(self.bottom_radius, input_name='bottom_radius'), namespaceprefix_ , eol_))
        if self.transform_id is not None:
            namespaceprefix_ = self.transform_id_nsprefix_ + ':' if (UseCapturedNS_ and self.transform_id_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransform_id>%s</%stransform_id>%s' % (namespaceprefix_ , self.gds_format_integer(self.transform_id, input_name='transform_id'), namespaceprefix_ , eol_))
        if self.attribute is not None:
            namespaceprefix_ = self.attribute_nsprefix_ + ':' if (UseCapturedNS_ and self.attribute_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sattribute>%s</%sattribute>%s' % (namespaceprefix_ , self.gds_format_float(self.attribute, input_name='attribute'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'height' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'height')
            fval_ = self.gds_validate_float(fval_, node, 'height')
            self.height = fval_
            self.height_nsprefix_ = child_.prefix
            # validate type dimension_type
            self.validate_dimension_type(self.height)
        elif nodeName_ == 'bottom_radius' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'bottom_radius')
            fval_ = self.gds_validate_float(fval_, node, 'bottom_radius')
            self.bottom_radius = fval_
            self.bottom_radius_nsprefix_ = child_.prefix
            # validate type dimension_type
            self.validate_dimension_type(self.bottom_radius)
        elif nodeName_ == 'transform_id' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'transform_id')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transform_id')
            self.transform_id = ival_
            self.transform_id_nsprefix_ = child_.prefix
        elif nodeName_ == 'attribute' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'attribute')
            fval_ = self.gds_validate_float(fval_, node, 'attribute')
            self.attribute = fval_
            self.attribute_nsprefix_ = child_.prefix
# end class cone


class transform(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, transform)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if transform.subclass:
            return transform.subclass(*args_, **kwargs_)
        else:
            return transform(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='transform', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('transform')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='transform')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='transform', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='transform'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='transform', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        pass
# end class transform


class vertex_list_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, num_vertices=None, v=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.num_vertices = _cast(int, num_vertices)
        self.num_vertices_nsprefix_ = None
        if v is None:
            self.v = []
        else:
            self.v = v
        self.v_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, vertex_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if vertex_list_type.subclass:
            return vertex_list_type.subclass(*args_, **kwargs_)
        else:
            return vertex_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_v(self):
        return self.v
    def set_v(self, v):
        self.v = v
    def add_v(self, value):
        self.v.append(value)
    def insert_v_at(self, index, value):
        self.v.insert(index, value)
    def replace_v_at(self, index, value):
        self.v[index] = value
    def get_num_vertices(self):
        return self.num_vertices
    def set_num_vertices(self, num_vertices):
        self.num_vertices = num_vertices
    def hasContent_(self):
        if (
            self.v
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='vertex_list_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('vertex_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='vertex_list_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='vertex_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='vertex_list_type'):
        if self.num_vertices is not None and 'num_vertices' not in already_processed:
            already_processed.add('num_vertices')
            outfile.write(' num_vertices="%s"' % self.gds_format_integer(self.num_vertices, input_name='num_vertices'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='vertex_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for v_ in self.v:
            namespaceprefix_ = self.v_nsprefix_ + ':' if (UseCapturedNS_ and self.v_nsprefix_) else ''
            v_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='v', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('num_vertices', node)
        if value is not None and 'num_vertices' not in already_processed:
            already_processed.add('num_vertices')
            self.num_vertices = self.gds_parse_integer(value, node, 'num_vertices')
            if self.num_vertices <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'v':
            obj_ = vertex_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.v.append(obj_)
            obj_.original_tagname_ = 'v'
# end class vertex_list_type


class triangle_list_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, num_triangles=None, P=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.num_triangles = _cast(int, num_triangles)
        self.num_triangles_nsprefix_ = None
        if P is None:
            self.P = []
        else:
            self.P = P
        self.P_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, triangle_list_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if triangle_list_type.subclass:
            return triangle_list_type.subclass(*args_, **kwargs_)
        else:
            return triangle_list_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_P(self):
        return self.P
    def set_P(self, P):
        self.P = P
    def add_P(self, value):
        self.P.append(value)
    def insert_P_at(self, index, value):
        self.P.insert(index, value)
    def replace_P_at(self, index, value):
        self.P[index] = value
    def get_num_triangles(self):
        return self.num_triangles
    def set_num_triangles(self, num_triangles):
        self.num_triangles = num_triangles
    def hasContent_(self):
        if (
            self.P
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='triangle_list_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('triangle_list_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='triangle_list_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='triangle_list_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='triangle_list_type'):
        if self.num_triangles is not None and 'num_triangles' not in already_processed:
            already_processed.add('num_triangles')
            outfile.write(' num_triangles="%s"' % self.gds_format_integer(self.num_triangles, input_name='num_triangles'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='triangle_list_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for P_ in self.P:
            namespaceprefix_ = self.P_nsprefix_ + ':' if (UseCapturedNS_ and self.P_nsprefix_) else ''
            P_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='P', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('num_triangles', node)
        if value is not None and 'num_triangles' not in already_processed:
            already_processed.add('num_triangles')
            self.num_triangles = self.gds_parse_integer(value, node, 'num_triangles')
            if self.num_triangles <= 0:
                raise_parse_error(node, 'Invalid PositiveInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'P':
            obj_ = triangle_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.P.append(obj_)
            obj_.original_tagname_ = 'P'
# end class triangle_list_type


class vertex_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, designation='surface', x=None, y=None, z=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.designation = _cast(None, designation)
        self.designation_nsprefix_ = None
        self.x = x
        self.x_nsprefix_ = None
        self.y = y
        self.y_nsprefix_ = None
        self.z = z
        self.z_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, vertex_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if vertex_type.subclass:
            return vertex_type.subclass(*args_, **kwargs_)
        else:
            return vertex_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_x(self):
        return self.x
    def set_x(self, x):
        self.x = x
    def get_y(self):
        return self.y
    def set_y(self, y):
        self.y = y
    def get_z(self):
        return self.z
    def set_z(self, z):
        self.z = z
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def get_designation(self):
        return self.designation
    def set_designation(self, designation):
        self.designation = designation
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='vertex_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('vertex_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='vertex_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='vertex_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='vertex_type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
        if self.designation != "surface" and 'designation' not in already_processed:
            already_processed.add('designation')
            outfile.write(' designation=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.designation), input_name='designation')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='vertex_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            namespaceprefix_ = self.x_nsprefix_ + ':' if (UseCapturedNS_ and self.x_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespaceprefix_ , self.gds_format_float(self.x, input_name='x'), namespaceprefix_ , eol_))
        if self.y is not None:
            namespaceprefix_ = self.y_nsprefix_ + ':' if (UseCapturedNS_ and self.y_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespaceprefix_ , self.gds_format_float(self.y, input_name='y'), namespaceprefix_ , eol_))
        if self.z is not None:
            namespaceprefix_ = self.z_nsprefix_ + ':' if (UseCapturedNS_ and self.z_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespaceprefix_ , self.gds_format_float(self.z, input_name='z'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('designation', node)
        if value is not None and 'designation' not in already_processed:
            already_processed.add('designation')
            self.designation = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'x' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'x')
            fval_ = self.gds_validate_float(fval_, node, 'x')
            self.x = fval_
            self.x_nsprefix_ = child_.prefix
        elif nodeName_ == 'y' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'y')
            fval_ = self.gds_validate_float(fval_, node, 'y')
            self.y = fval_
            self.y_nsprefix_ = child_.prefix
        elif nodeName_ == 'z' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'z')
            fval_ = self.gds_validate_float(fval_, node, 'z')
            self.z = fval_
            self.z_nsprefix_ = child_.prefix
# end class vertex_type


class triangle_type(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, v=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        if v is None:
            self.v = []
        else:
            self.v = v
        self.v_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, triangle_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if triangle_type.subclass:
            return triangle_type.subclass(*args_, **kwargs_)
        else:
            return triangle_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_v(self):
        return self.v
    def set_v(self, v):
        self.v = v
    def add_v(self, value):
        self.v.append(value)
    def insert_v_at(self, index, value):
        self.v.insert(index, value)
    def replace_v_at(self, index, value):
        self.v[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def hasContent_(self):
        if (
            self.v
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='triangle_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('triangle_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='triangle_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='triangle_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='triangle_type'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='triangle_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for v_ in self.v:
            namespaceprefix_ = self.v_nsprefix_ + ':' if (UseCapturedNS_ and self.v_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sv>%s</%sv>%s' % (namespaceprefix_ , self.gds_format_integer(v_, input_name='v'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'v' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'v')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'v')
            self.v.append(ival_)
            self.v_nsprefix_ = child_.prefix
# end class triangle_type


class complexes_and_macromolecules_type(GeneratedsSuper):
    """Depending on the problem, one can either reference the sample on the
    macromolecule level or the complex level."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, macromolecule_list=None, complex_list=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.macromolecule_list = macromolecule_list
        self.macromolecule_list_nsprefix_ = None
        self.complex_list = complex_list
        self.complex_list_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, complexes_and_macromolecules_type)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if complexes_and_macromolecules_type.subclass:
            return complexes_and_macromolecules_type.subclass(*args_, **kwargs_)
        else:
            return complexes_and_macromolecules_type(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_macromolecule_list(self):
        return self.macromolecule_list
    def set_macromolecule_list(self, macromolecule_list):
        self.macromolecule_list = macromolecule_list
    def get_complex_list(self):
        return self.complex_list
    def set_complex_list(self, complex_list):
        self.complex_list = complex_list
    def hasContent_(self):
        if (
            self.macromolecule_list is not None or
            self.complex_list is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='complexes_and_macromolecules_type', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('complexes_and_macromolecules_type')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='complexes_and_macromolecules_type')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='complexes_and_macromolecules_type', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='complexes_and_macromolecules_type'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='complexes_and_macromolecules_type', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.macromolecule_list is not None:
            namespaceprefix_ = self.macromolecule_list_nsprefix_ + ':' if (UseCapturedNS_ and self.macromolecule_list_nsprefix_) else ''
            self.macromolecule_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='macromolecule_list', pretty_print=pretty_print)
        if self.complex_list is not None:
            namespaceprefix_ = self.complex_list_nsprefix_ + ':' if (UseCapturedNS_ and self.complex_list_nsprefix_) else ''
            self.complex_list.export(outfile, level, namespaceprefix_, namespacedef_='', name_='complex_list', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'macromolecule_list':
            obj_ = macromolecule_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule_list = obj_
            obj_.original_tagname_ = 'macromolecule_list'
        elif nodeName_ == 'complex_list':
            obj_ = complex_listType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.complex_list = obj_
            obj_.original_tagname_ = 'complex_list'
# end class complexes_and_macromolecules_type


class oldThreeDVolumeType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, file=None, objectPath=None, contourLevel=None, transformId=None, format=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.file = file
        self.file_nsprefix_ = None
        self.objectPath = objectPath
        self.objectPath_nsprefix_ = None
        self.contourLevel = contourLevel
        self.contourLevel_nsprefix_ = None
        self.transformId = transformId
        self.transformId_nsprefix_ = None
        self.format = format
        self.validate_formatType(self.format)
        self.format_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, oldThreeDVolumeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if oldThreeDVolumeType.subclass:
            return oldThreeDVolumeType.subclass(*args_, **kwargs_)
        else:
            return oldThreeDVolumeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_file(self):
        return self.file
    def set_file(self, file):
        self.file = file
    def get_objectPath(self):
        return self.objectPath
    def set_objectPath(self, objectPath):
        self.objectPath = objectPath
    def get_contourLevel(self):
        return self.contourLevel
    def set_contourLevel(self, contourLevel):
        self.contourLevel = contourLevel
    def get_transformId(self):
        return self.transformId
    def set_transformId(self, transformId):
        self.transformId = transformId
    def get_format(self):
        return self.format
    def set_format(self, format):
        self.format = format
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_formatType(self, value):
        result = True
        # Validate type formatType, a restriction on xs:string.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            value = value
            enumerations = ['runLengthEncoding', 'MRC', 'Segger', 'EMAN']
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on formatType' % {"value" : encode_str_2_3(value), "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.file is not None or
            self.objectPath is not None or
            self.contourLevel is not None or
            self.transformId is not None or
            self.format is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='oldThreeDVolumeType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('oldThreeDVolumeType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='oldThreeDVolumeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='oldThreeDVolumeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='oldThreeDVolumeType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='oldThreeDVolumeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.file is not None:
            namespaceprefix_ = self.file_nsprefix_ + ':' if (UseCapturedNS_ and self.file_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sfile>%s</%sfile>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.file), input_name='file')), namespaceprefix_ , eol_))
        if self.objectPath is not None:
            namespaceprefix_ = self.objectPath_nsprefix_ + ':' if (UseCapturedNS_ and self.objectPath_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sobjectPath>%s</%sobjectPath>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.objectPath), input_name='objectPath')), namespaceprefix_ , eol_))
        if self.contourLevel is not None:
            namespaceprefix_ = self.contourLevel_nsprefix_ + ':' if (UseCapturedNS_ and self.contourLevel_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scontourLevel>%s</%scontourLevel>%s' % (namespaceprefix_ , self.gds_format_float(self.contourLevel, input_name='contourLevel'), namespaceprefix_ , eol_))
        if self.transformId is not None:
            namespaceprefix_ = self.transformId_nsprefix_ + ':' if (UseCapturedNS_ and self.transformId_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stransformId>%s</%stransformId>%s' % (namespaceprefix_ , self.gds_format_integer(self.transformId, input_name='transformId'), namespaceprefix_ , eol_))
        if self.format is not None:
            namespaceprefix_ = self.format_nsprefix_ + ':' if (UseCapturedNS_ and self.format_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sformat>%s</%sformat>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.format), input_name='format')), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'file':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'file')
            value_ = self.gds_validate_string(value_, node, 'file')
            self.file = value_
            self.file_nsprefix_ = child_.prefix
        elif nodeName_ == 'objectPath':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'objectPath')
            value_ = self.gds_validate_string(value_, node, 'objectPath')
            self.objectPath = value_
            self.objectPath_nsprefix_ = child_.prefix
        elif nodeName_ == 'contourLevel' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'contourLevel')
            fval_ = self.gds_validate_float(fval_, node, 'contourLevel')
            self.contourLevel = fval_
            self.contourLevel_nsprefix_ = child_.prefix
        elif nodeName_ == 'transformId' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'transformId')
            if ival_ < 0:
                raise_parse_error(child_, 'requires nonNegativeInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'transformId')
            self.transformId = ival_
            self.transformId_nsprefix_ = child_.prefix
        elif nodeName_ == 'format':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'format')
            value_ = self.gds_validate_string(value_, node, 'format')
            self.format = value_
            self.format_nsprefix_ = child_.prefix
            # validate type formatType
            self.validate_formatType(self.format)
# end class oldThreeDVolumeType


class meshPointType(GeneratedsSuper):
    """A mesh is a sequence of trianglesDeprecated"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, index=None, designation=None, point=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.index = _cast(int, index)
        self.index_nsprefix_ = None
        self.designation = _cast(None, designation)
        self.designation_nsprefix_ = None
        if point is None:
            self.point = []
        else:
            self.point = point
        self.point_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, meshPointType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if meshPointType.subclass:
            return meshPointType.subclass(*args_, **kwargs_)
        else:
            return meshPointType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_point(self):
        return self.point
    def set_point(self, point):
        self.point = point
    def add_point(self, value):
        self.point.append(value)
    def insert_point_at(self, index, value):
        self.point.insert(index, value)
    def replace_point_at(self, index, value):
        self.point[index] = value
    def get_index(self):
        return self.index
    def set_index(self, index):
        self.index = index
    def get_designation(self):
        return self.designation
    def set_designation(self, designation):
        self.designation = designation
    def hasContent_(self):
        if (
            self.point
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='meshPointType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('meshPointType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='meshPointType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='meshPointType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='meshPointType'):
        if self.index is not None and 'index' not in already_processed:
            already_processed.add('index')
            outfile.write(' index="%s"' % self.gds_format_integer(self.index, input_name='index'))
        if self.designation is not None and 'designation' not in already_processed:
            already_processed.add('designation')
            outfile.write(' designation=%s' % (self.gds_encode(self.gds_format_string(quote_attrib(self.designation), input_name='designation')), ))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='meshPointType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for point_ in self.point:
            namespaceprefix_ = self.point_nsprefix_ + ':' if (UseCapturedNS_ and self.point_nsprefix_) else ''
            point_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='point', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('index', node)
        if value is not None and 'index' not in already_processed:
            already_processed.add('index')
            self.index = self.gds_parse_integer(value, node, 'index')
            if self.index < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('designation', node)
        if value is not None and 'designation' not in already_processed:
            already_processed.add('designation')
            self.designation = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'point':
            obj_ = float_vector_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.point.append(obj_)
            obj_.original_tagname_ = 'point'
# end class meshPointType


class hsvType(GeneratedsSuper):
    """Deprecated"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, hue=None, saturation=None, value=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.hue = hue
        self.hue_nsprefix_ = None
        self.saturation = saturation
        self.saturation_nsprefix_ = None
        self.value = value
        self.value_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, hsvType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if hsvType.subclass:
            return hsvType.subclass(*args_, **kwargs_)
        else:
            return hsvType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_hue(self):
        return self.hue
    def set_hue(self, hue):
        self.hue = hue
    def get_saturation(self):
        return self.saturation
    def set_saturation(self, saturation):
        self.saturation = saturation
    def get_value(self):
        return self.value
    def set_value(self, value):
        self.value = value
    def hasContent_(self):
        if (
            self.hue is not None or
            self.saturation is not None or
            self.value is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='hsvType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('hsvType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='hsvType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='hsvType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='hsvType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='hsvType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.hue is not None:
            namespaceprefix_ = self.hue_nsprefix_ + ':' if (UseCapturedNS_ and self.hue_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%shue>%s</%shue>%s' % (namespaceprefix_ , self.gds_format_float(self.hue, input_name='hue'), namespaceprefix_ , eol_))
        if self.saturation is not None:
            namespaceprefix_ = self.saturation_nsprefix_ + ':' if (UseCapturedNS_ and self.saturation_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssaturation>%s</%ssaturation>%s' % (namespaceprefix_ , self.gds_format_float(self.saturation, input_name='saturation'), namespaceprefix_ , eol_))
        if self.value is not None:
            namespaceprefix_ = self.value_nsprefix_ + ':' if (UseCapturedNS_ and self.value_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalue>%s</%svalue>%s' % (namespaceprefix_ , self.gds_format_float(self.value, input_name='value'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'hue' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'hue')
            fval_ = self.gds_validate_float(fval_, node, 'hue')
            self.hue = fval_
            self.hue_nsprefix_ = child_.prefix
        elif nodeName_ == 'saturation' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'saturation')
            fval_ = self.gds_validate_float(fval_, node, 'saturation')
            self.saturation = fval_
            self.saturation_nsprefix_ = child_.prefix
        elif nodeName_ == 'value' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'value')
            fval_ = self.gds_validate_float(fval_, node, 'value')
            self.value = fval_
            self.value_nsprefix_ = child_.prefix
# end class hsvType


class runLengthEncodingType(GeneratedsSuper):
    """Deprecated"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, string=None, offset=None, boxSize=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.string = string
        self.validate_stringType(self.string)
        self.string_nsprefix_ = None
        self.offset = offset
        self.offset_nsprefix_ = None
        self.boxSize = boxSize
        self.boxSize_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, runLengthEncodingType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if runLengthEncodingType.subclass:
            return runLengthEncodingType.subclass(*args_, **kwargs_)
        else:
            return runLengthEncodingType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_string(self):
        return self.string
    def set_string(self, string):
        self.string = string
    def get_offset(self):
        return self.offset
    def set_offset(self, offset):
        self.offset = offset
    def get_boxSize(self):
        return self.boxSize
    def set_boxSize(self, boxSize):
        self.boxSize = boxSize
    def validate_stringType(self, value):
        result = True
        # Validate type stringType, a restriction on xs:token.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (str)' % {"value": value, "lineno": lineno, })
                return False
            if not self.gds_validate_simple_patterns(
                    self.validate_stringType_patterns_, value):
                self.gds_collector_.add_message('Value "%s" does not match xsd pattern restrictions: %s' % (encode_str_2_3(value), self.validate_stringType_patterns_, ))
                result = False
        return result
    validate_stringType_patterns_ = [['^(\\d+(,\\d+)+)$']]
    def hasContent_(self):
        if (
            self.string is not None or
            self.offset is not None or
            self.boxSize is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='runLengthEncodingType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('runLengthEncodingType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='runLengthEncodingType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='runLengthEncodingType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='runLengthEncodingType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='runLengthEncodingType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.string is not None:
            namespaceprefix_ = self.string_nsprefix_ + ':' if (UseCapturedNS_ and self.string_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sstring>%s</%sstring>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.string), input_name='string')), namespaceprefix_ , eol_))
        if self.offset is not None:
            namespaceprefix_ = self.offset_nsprefix_ + ':' if (UseCapturedNS_ and self.offset_nsprefix_) else ''
            self.offset.export(outfile, level, namespaceprefix_, namespacedef_='', name_='offset', pretty_print=pretty_print)
        if self.boxSize is not None:
            namespaceprefix_ = self.boxSize_nsprefix_ + ':' if (UseCapturedNS_ and self.boxSize_nsprefix_) else ''
            self.boxSize.export(outfile, level, namespaceprefix_, namespacedef_='', name_='boxSize', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'string':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'string')
            value_ = self.gds_validate_string(value_, node, 'string')
            self.string = value_
            self.string_nsprefix_ = child_.prefix
            # validate type stringType
            self.validate_stringType(self.string)
        elif nodeName_ == 'offset':
            obj_ = integerVectorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.offset = obj_
            obj_.original_tagname_ = 'offset'
        elif nodeName_ == 'boxSize':
            obj_ = positiveIntegerVectorType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.boxSize = obj_
            obj_.original_tagname_ = 'boxSize'
# end class runLengthEncodingType


class integerVectorType(GeneratedsSuper):
    """Deprecated"""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, x=None, y=None, z=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.x = x
        self.x_nsprefix_ = None
        self.y = y
        self.y_nsprefix_ = None
        self.z = z
        self.z_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, integerVectorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if integerVectorType.subclass:
            return integerVectorType.subclass(*args_, **kwargs_)
        else:
            return integerVectorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_x(self):
        return self.x
    def set_x(self, x):
        self.x = x
    def get_y(self):
        return self.y
    def set_y(self, y):
        self.y = y
    def get_z(self):
        return self.z
    def set_z(self, z):
        self.z = z
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='integerVectorType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('integerVectorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='integerVectorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='integerVectorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='integerVectorType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='integerVectorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            namespaceprefix_ = self.x_nsprefix_ + ':' if (UseCapturedNS_ and self.x_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespaceprefix_ , self.gds_format_integer(self.x, input_name='x'), namespaceprefix_ , eol_))
        if self.y is not None:
            namespaceprefix_ = self.y_nsprefix_ + ':' if (UseCapturedNS_ and self.y_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespaceprefix_ , self.gds_format_integer(self.y, input_name='y'), namespaceprefix_ , eol_))
        if self.z is not None:
            namespaceprefix_ = self.z_nsprefix_ + ':' if (UseCapturedNS_ and self.z_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespaceprefix_ , self.gds_format_integer(self.z, input_name='z'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'x' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'x')
            ival_ = self.gds_validate_integer(ival_, node, 'x')
            self.x = ival_
            self.x_nsprefix_ = child_.prefix
        elif nodeName_ == 'y' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'y')
            ival_ = self.gds_validate_integer(ival_, node, 'y')
            self.y = ival_
            self.y_nsprefix_ = child_.prefix
        elif nodeName_ == 'z' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'z')
            ival_ = self.gds_validate_integer(ival_, node, 'z')
            self.z = ival_
            self.z_nsprefix_ = child_.prefix
# end class integerVectorType


class positiveIntegerVectorType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, x=None, y=None, z=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.x = x
        self.x_nsprefix_ = None
        self.y = y
        self.y_nsprefix_ = None
        self.z = z
        self.z_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, positiveIntegerVectorType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if positiveIntegerVectorType.subclass:
            return positiveIntegerVectorType.subclass(*args_, **kwargs_)
        else:
            return positiveIntegerVectorType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_x(self):
        return self.x
    def set_x(self, x):
        self.x = x
    def get_y(self):
        return self.y
    def set_y(self, y):
        self.y = y
    def get_z(self):
        return self.z
    def set_z(self, z):
        self.z = z
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='positiveIntegerVectorType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('positiveIntegerVectorType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='positiveIntegerVectorType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='positiveIntegerVectorType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='positiveIntegerVectorType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='positiveIntegerVectorType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            namespaceprefix_ = self.x_nsprefix_ + ':' if (UseCapturedNS_ and self.x_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespaceprefix_ , self.gds_format_integer(self.x, input_name='x'), namespaceprefix_ , eol_))
        if self.y is not None:
            namespaceprefix_ = self.y_nsprefix_ + ':' if (UseCapturedNS_ and self.y_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespaceprefix_ , self.gds_format_integer(self.y, input_name='y'), namespaceprefix_ , eol_))
        if self.z is not None:
            namespaceprefix_ = self.z_nsprefix_ + ':' if (UseCapturedNS_ and self.z_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespaceprefix_ , self.gds_format_integer(self.z, input_name='z'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'x' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'x')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'x')
            self.x = ival_
            self.x_nsprefix_ = child_.prefix
        elif nodeName_ == 'y' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'y')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'y')
            self.y = ival_
            self.y_nsprefix_ = child_.prefix
        elif nodeName_ == 'z' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'z')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'z')
            self.z = ival_
            self.z_nsprefix_ = child_.prefix
# end class positiveIntegerVectorType


class colourType(GeneratedsSuper):
    """The 'name' corresponds to the sRGB colour space name and maps
    precisely to an RGB value. When this happens, the alpha channel should be
    set to '1'
    (opaque). Requires the use of an external Python module (webcolors.py)."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, rgba=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.rgba = rgba
        self.rgba_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, colourType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if colourType.subclass:
            return colourType.subclass(*args_, **kwargs_)
        else:
            return colourType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_rgba(self):
        return self.rgba
    def set_rgba(self, rgba):
        self.rgba = rgba
    def hasContent_(self):
        if (
            self.name is not None or
            self.rgba is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='colourType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('colourType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='colourType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='colourType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='colourType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='colourType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.rgba is not None:
            namespaceprefix_ = self.rgba_nsprefix_ + ':' if (UseCapturedNS_ and self.rgba_nsprefix_) else ''
            self.rgba.export(outfile, level, namespaceprefix_, namespacedef_='', name_='rgba', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            if value_:
                value_ = re_.sub(String_cleanup_pat_, " ", value_).strip()
            else:
                value_ = ""
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'rgba':
            obj_ = rgba_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.rgba = obj_
            obj_.original_tagname_ = 'rgba'
# end class colourType


class contourType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, p=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        if p is None:
            self.p = []
        else:
            self.p = p
        self.p_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, contourType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if contourType.subclass:
            return contourType.subclass(*args_, **kwargs_)
        else:
            return contourType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_p(self):
        return self.p
    def set_p(self, p):
        self.p = p
    def add_p(self, value):
        self.p.append(value)
    def insert_p_at(self, index, value):
        self.p.insert(index, value)
    def replace_p_at(self, index, value):
        self.p[index] = value
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def hasContent_(self):
        if (
            self.p
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='contourType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('contourType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='contourType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='contourType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='contourType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='contourType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for p_ in self.p:
            namespaceprefix_ = self.p_nsprefix_ + ':' if (UseCapturedNS_ and self.p_nsprefix_) else ''
            p_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='p', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'p':
            obj_ = float_vector_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.p.append(obj_)
            obj_.original_tagname_ = 'p'
# end class contourType


class viewVectorRotationType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, x=None, y=None, z=None, r=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.x = x
        self.x_nsprefix_ = None
        self.y = y
        self.y_nsprefix_ = None
        self.z = z
        self.z_nsprefix_ = None
        self.r = r
        self.validate_angleDegreeType(self.r)
        self.r_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, viewVectorRotationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if viewVectorRotationType.subclass:
            return viewVectorRotationType.subclass(*args_, **kwargs_)
        else:
            return viewVectorRotationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_x(self):
        return self.x
    def set_x(self, x):
        self.x = x
    def get_y(self):
        return self.y
    def set_y(self, y):
        self.y = y
    def get_z(self):
        return self.z
    def set_z(self, z):
        self.z = z
    def get_r(self):
        return self.r
    def set_r(self, r):
        self.r = r
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_angleDegreeType(self, value):
        result = True
        # Validate type angleDegreeType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on angleDegreeType' % {"value": value, "lineno": lineno} )
                result = False
            if value > 360:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on angleDegreeType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.x is not None or
            self.y is not None or
            self.z is not None or
            self.r is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='viewVectorRotationType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('viewVectorRotationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='viewVectorRotationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='viewVectorRotationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='viewVectorRotationType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='viewVectorRotationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.x is not None:
            namespaceprefix_ = self.x_nsprefix_ + ':' if (UseCapturedNS_ and self.x_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sx>%s</%sx>%s' % (namespaceprefix_ , self.gds_format_float(self.x, input_name='x'), namespaceprefix_ , eol_))
        if self.y is not None:
            namespaceprefix_ = self.y_nsprefix_ + ':' if (UseCapturedNS_ and self.y_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sy>%s</%sy>%s' % (namespaceprefix_ , self.gds_format_float(self.y, input_name='y'), namespaceprefix_ , eol_))
        if self.z is not None:
            namespaceprefix_ = self.z_nsprefix_ + ':' if (UseCapturedNS_ and self.z_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sz>%s</%sz>%s' % (namespaceprefix_ , self.gds_format_float(self.z, input_name='z'), namespaceprefix_ , eol_))
        if self.r is not None:
            namespaceprefix_ = self.r_nsprefix_ + ':' if (UseCapturedNS_ and self.r_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sr>%s</%sr>%s' % (namespaceprefix_ , self.gds_format_float(self.r, input_name='r'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'x' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'x')
            fval_ = self.gds_validate_float(fval_, node, 'x')
            self.x = fval_
            self.x_nsprefix_ = child_.prefix
        elif nodeName_ == 'y' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'y')
            fval_ = self.gds_validate_float(fval_, node, 'y')
            self.y = fval_
            self.y_nsprefix_ = child_.prefix
        elif nodeName_ == 'z' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'z')
            fval_ = self.gds_validate_float(fval_, node, 'z')
            self.z = fval_
            self.z_nsprefix_ = child_.prefix
        elif nodeName_ == 'r' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'r')
            fval_ = self.gds_validate_float(fval_, node, 'r')
            self.r = fval_
            self.r_nsprefix_ = child_.prefix
            # validate type angleDegreeType
            self.validate_angleDegreeType(self.r)
# end class viewVectorRotationType


class canonicalEulerAnglesType(GeneratedsSuper):
    """Euler angler according to Heymann et al. 2005
    (doi:10.1016/j.jsb.2005.06.001) Angles are specified in degrees together
    with their bounds."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, phi=None, theta=None, psi=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.phi = phi
        self.validate_angleDegreeType(self.phi)
        self.phi_nsprefix_ = None
        self.theta = theta
        self.validate_angleDegreeType(self.theta)
        self.theta_nsprefix_ = None
        self.psi = psi
        self.validate_angleDegreeType(self.psi)
        self.psi_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, canonicalEulerAnglesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if canonicalEulerAnglesType.subclass:
            return canonicalEulerAnglesType.subclass(*args_, **kwargs_)
        else:
            return canonicalEulerAnglesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_phi(self):
        return self.phi
    def set_phi(self, phi):
        self.phi = phi
    def get_theta(self):
        return self.theta
    def set_theta(self, theta):
        self.theta = theta
    def get_psi(self):
        return self.psi
    def set_psi(self, psi):
        self.psi = psi
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def validate_angleDegreeType(self, value):
        result = True
        # Validate type angleDegreeType, a restriction on xs:float.
        if value is not None and Validate_simpletypes_ and self.gds_collector_ is not None:
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s is not of the correct base simple type (float)' % {"value": value, "lineno": lineno, })
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on angleDegreeType' % {"value": value, "lineno": lineno} )
                result = False
            if value > 360:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message('Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on angleDegreeType' % {"value": value, "lineno": lineno} )
                result = False
        return result
    def hasContent_(self):
        if (
            self.phi is not None or
            self.theta is not None or
            self.psi is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='canonicalEulerAnglesType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('canonicalEulerAnglesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='canonicalEulerAnglesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='canonicalEulerAnglesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='canonicalEulerAnglesType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='canonicalEulerAnglesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.phi is not None:
            namespaceprefix_ = self.phi_nsprefix_ + ':' if (UseCapturedNS_ and self.phi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sphi>%s</%sphi>%s' % (namespaceprefix_ , self.gds_format_float(self.phi, input_name='phi'), namespaceprefix_ , eol_))
        if self.theta is not None:
            namespaceprefix_ = self.theta_nsprefix_ + ':' if (UseCapturedNS_ and self.theta_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stheta>%s</%stheta>%s' % (namespaceprefix_ , self.gds_format_float(self.theta, input_name='theta'), namespaceprefix_ , eol_))
        if self.psi is not None:
            namespaceprefix_ = self.psi_nsprefix_ + ':' if (UseCapturedNS_ and self.psi_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%spsi>%s</%spsi>%s' % (namespaceprefix_ , self.gds_format_float(self.psi, input_name='psi'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'phi' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'phi')
            fval_ = self.gds_validate_float(fval_, node, 'phi')
            self.phi = fval_
            self.phi_nsprefix_ = child_.prefix
            # validate type angleDegreeType
            self.validate_angleDegreeType(self.phi)
        elif nodeName_ == 'theta' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'theta')
            fval_ = self.gds_validate_float(fval_, node, 'theta')
            self.theta = fval_
            self.theta_nsprefix_ = child_.prefix
            # validate type angleDegreeType
            self.validate_angleDegreeType(self.theta)
        elif nodeName_ == 'psi' and child_.text:
            sval_ = child_.text
            fval_ = self.gds_parse_float(sval_, node, 'psi')
            fval_ = self.gds_validate_float(fval_, node, 'psi')
            self.psi = fval_
            self.psi_nsprefix_ = child_.prefix
            # validate type angleDegreeType
            self.validate_angleDegreeType(self.psi)
# end class canonicalEulerAnglesType


class software_listType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, id=None, software=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.software = software
        self.software_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, software_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if software_listType.subclass:
            return software_listType.subclass(*args_, **kwargs_)
        else:
            return software_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_software(self):
        return self.software
    def set_software(self, software):
        self.software = software
    def get_id(self):
        return self.id
    def set_id(self, id):
        self.id = id
    def hasContent_(self):
        if (
            self.software is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='software_listType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('software_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='software_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='software_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='software_listType'):
        if self.id is not None and 'id' not in already_processed:
            already_processed.add('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='software_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.software is not None:
            namespaceprefix_ = self.software_nsprefix_ + ':' if (UseCapturedNS_ and self.software_nsprefix_) else ''
            self.software.export(outfile, level, namespaceprefix_, namespacedef_='', name_='software', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.add('id')
            self.id = self.gds_parse_integer(value, node, 'id')
            if self.id < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'software':
            obj_ = software_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.software = obj_
            obj_.original_tagname_ = 'software'
# end class software_listType


class transform_listType(GeneratedsSuper):
    """Mandatory field. The first 'transformation_matrix' must
    be the image-to-physical transform."""
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, transformation_matrix=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if transformation_matrix is None:
            self.transformation_matrix = []
        else:
            self.transformation_matrix = transformation_matrix
        self.transformation_matrix_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, transform_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if transform_listType.subclass:
            return transform_listType.subclass(*args_, **kwargs_)
        else:
            return transform_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_transformation_matrix(self):
        return self.transformation_matrix
    def set_transformation_matrix(self, transformation_matrix):
        self.transformation_matrix = transformation_matrix
    def add_transformation_matrix(self, value):
        self.transformation_matrix.append(value)
    def insert_transformation_matrix_at(self, index, value):
        self.transformation_matrix.insert(index, value)
    def replace_transformation_matrix_at(self, index, value):
        self.transformation_matrix[index] = value
    def hasContent_(self):
        if (
            self.transformation_matrix
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='transform_listType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('transform_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='transform_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='transform_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='transform_listType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='transform_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for transformation_matrix_ in self.transformation_matrix:
            namespaceprefix_ = self.transformation_matrix_nsprefix_ + ':' if (UseCapturedNS_ and self.transformation_matrix_nsprefix_) else ''
            transformation_matrix_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='transformation_matrix', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'transformation_matrix':
            obj_ = transformation_matrix_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.transformation_matrix.append(obj_)
            obj_.original_tagname_ = 'transformation_matrix'
# end class transform_listType


class global_external_referencesType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ref=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ref is None:
            self.ref = []
        else:
            self.ref = ref
        self.ref_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, global_external_referencesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if global_external_referencesType.subclass:
            return global_external_referencesType.subclass(*args_, **kwargs_)
        else:
            return global_external_referencesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ref(self):
        return self.ref
    def set_ref(self, ref):
        self.ref = ref
    def add_ref(self, value):
        self.ref.append(value)
    def insert_ref_at(self, index, value):
        self.ref.insert(index, value)
    def replace_ref_at(self, index, value):
        self.ref[index] = value
    def hasContent_(self):
        if (
            self.ref
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='global_external_referencesType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('global_external_referencesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='global_external_referencesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='global_external_referencesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='global_external_referencesType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='global_external_referencesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ref_ in self.ref:
            namespaceprefix_ = self.ref_nsprefix_ + ':' if (UseCapturedNS_ and self.ref_nsprefix_) else ''
            ref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ref', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ref':
            obj_ = external_reference_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ref.append(obj_)
            obj_.original_tagname_ = 'ref'
# end class global_external_referencesType


class segment_listType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, segment=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if segment is None:
            self.segment = []
        else:
            self.segment = segment
        self.segment_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, segment_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if segment_listType.subclass:
            return segment_listType.subclass(*args_, **kwargs_)
        else:
            return segment_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_segment(self):
        return self.segment
    def set_segment(self, segment):
        self.segment = segment
    def add_segment(self, value):
        self.segment.append(value)
    def insert_segment_at(self, index, value):
        self.segment.insert(index, value)
    def replace_segment_at(self, index, value):
        self.segment[index] = value
    def hasContent_(self):
        if (
            self.segment
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='segment_listType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('segment_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='segment_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='segment_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='segment_listType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='segment_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for segment_ in self.segment:
            namespaceprefix_ = self.segment_nsprefix_ + ':' if (UseCapturedNS_ and self.segment_nsprefix_) else ''
            segment_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='segment', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'segment':
            obj_ = segment_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.segment.append(obj_)
            obj_.original_tagname_ = 'segment'
# end class segment_listType


class lattice_listType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, lattice=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if lattice is None:
            self.lattice = []
        else:
            self.lattice = lattice
        self.lattice_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, lattice_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if lattice_listType.subclass:
            return lattice_listType.subclass(*args_, **kwargs_)
        else:
            return lattice_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_lattice(self):
        return self.lattice
    def set_lattice(self, lattice):
        self.lattice = lattice
    def add_lattice(self, value):
        self.lattice.append(value)
    def insert_lattice_at(self, index, value):
        self.lattice.insert(index, value)
    def replace_lattice_at(self, index, value):
        self.lattice[index] = value
    def hasContent_(self):
        if (
            self.lattice
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='lattice_listType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('lattice_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='lattice_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='lattice_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='lattice_listType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='lattice_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for lattice_ in self.lattice:
            namespaceprefix_ = self.lattice_nsprefix_ + ':' if (UseCapturedNS_ and self.lattice_nsprefix_) else ''
            lattice_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='lattice', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'lattice':
            obj_ = lattice_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.lattice.append(obj_)
            obj_.original_tagname_ = 'lattice'
# end class lattice_listType


class biological_annotationType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, name=None, description=None, external_references=None, number_of_instances=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        self.name = name
        self.name_nsprefix_ = None
        self.description = description
        self.description_nsprefix_ = None
        self.external_references = external_references
        self.external_references_nsprefix_ = None
        self.number_of_instances = number_of_instances
        self.number_of_instances_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, biological_annotationType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if biological_annotationType.subclass:
            return biological_annotationType.subclass(*args_, **kwargs_)
        else:
            return biological_annotationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_name(self):
        return self.name
    def set_name(self, name):
        self.name = name
    def get_description(self):
        return self.description
    def set_description(self, description):
        self.description = description
    def get_external_references(self):
        return self.external_references
    def set_external_references(self, external_references):
        self.external_references = external_references
    def get_number_of_instances(self):
        return self.number_of_instances
    def set_number_of_instances(self, number_of_instances):
        self.number_of_instances = number_of_instances
    def hasContent_(self):
        if (
            self.name is not None or
            self.description is not None or
            self.external_references is not None or
            self.number_of_instances is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='biological_annotationType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('biological_annotationType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='biological_annotationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='biological_annotationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='biological_annotationType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='biological_annotationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.name is not None:
            namespaceprefix_ = self.name_nsprefix_ + ':' if (UseCapturedNS_ and self.name_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sname>%s</%sname>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.name), input_name='name')), namespaceprefix_ , eol_))
        if self.description is not None:
            namespaceprefix_ = self.description_nsprefix_ + ':' if (UseCapturedNS_ and self.description_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespaceprefix_ , self.gds_encode(self.gds_format_string(quote_xml(self.description), input_name='description')), namespaceprefix_ , eol_))
        if self.external_references is not None:
            namespaceprefix_ = self.external_references_nsprefix_ + ':' if (UseCapturedNS_ and self.external_references_nsprefix_) else ''
            self.external_references.export(outfile, level, namespaceprefix_, namespacedef_='', name_='external_references', pretty_print=pretty_print)
        if self.number_of_instances is not None:
            namespaceprefix_ = self.number_of_instances_nsprefix_ + ':' if (UseCapturedNS_ and self.number_of_instances_nsprefix_) else ''
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snumber_of_instances>%s</%snumber_of_instances>%s' % (namespaceprefix_ , self.gds_format_integer(self.number_of_instances, input_name='number_of_instances'), namespaceprefix_ , eol_))
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'name':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'name')
            value_ = self.gds_validate_string(value_, node, 'name')
            self.name = value_
            self.name_nsprefix_ = child_.prefix
        elif nodeName_ == 'description':
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, 'description')
            value_ = self.gds_validate_string(value_, node, 'description')
            self.description = value_
            self.description_nsprefix_ = child_.prefix
        elif nodeName_ == 'external_references':
            obj_ = external_referencesType.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.external_references = obj_
            obj_.original_tagname_ = 'external_references'
        elif nodeName_ == 'number_of_instances' and child_.text:
            sval_ = child_.text
            ival_ = self.gds_parse_integer(sval_, node, 'number_of_instances')
            if ival_ <= 0:
                raise_parse_error(child_, 'requires positiveInteger')
            ival_ = self.gds_validate_integer(ival_, node, 'number_of_instances')
            self.number_of_instances = ival_
            self.number_of_instances_nsprefix_ = child_.prefix
# end class biological_annotationType


class external_referencesType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, ref=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if ref is None:
            self.ref = []
        else:
            self.ref = ref
        self.ref_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, external_referencesType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if external_referencesType.subclass:
            return external_referencesType.subclass(*args_, **kwargs_)
        else:
            return external_referencesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_ref(self):
        return self.ref
    def set_ref(self, ref):
        self.ref = ref
    def add_ref(self, value):
        self.ref.append(value)
    def insert_ref_at(self, index, value):
        self.ref.insert(index, value)
    def replace_ref_at(self, index, value):
        self.ref[index] = value
    def hasContent_(self):
        if (
            self.ref
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='external_referencesType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('external_referencesType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='external_referencesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='external_referencesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='external_referencesType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='external_referencesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for ref_ in self.ref:
            namespaceprefix_ = self.ref_nsprefix_ + ':' if (UseCapturedNS_ and self.ref_nsprefix_) else ''
            ref_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='ref', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'ref':
            obj_ = external_reference_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ref.append(obj_)
            obj_.original_tagname_ = 'ref'
# end class external_referencesType


class shape_primitive_listType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, shape_primitive=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if shape_primitive is None:
            self.shape_primitive = []
        else:
            self.shape_primitive = shape_primitive
        self.shape_primitive_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, shape_primitive_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if shape_primitive_listType.subclass:
            return shape_primitive_listType.subclass(*args_, **kwargs_)
        else:
            return shape_primitive_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_shape_primitive(self):
        return self.shape_primitive
    def set_shape_primitive(self, shape_primitive):
        self.shape_primitive = shape_primitive
    def add_shape_primitive(self, value):
        self.shape_primitive.append(value)
    def insert_shape_primitive_at(self, index, value):
        self.shape_primitive.insert(index, value)
    def replace_shape_primitive_at(self, index, value):
        self.shape_primitive[index] = value
    def hasContent_(self):
        if (
            self.shape_primitive
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='shape_primitive_listType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('shape_primitive_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='shape_primitive_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='shape_primitive_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='shape_primitive_listType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='shape_primitive_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for shape_primitive_ in self.shape_primitive:
            namespaceprefix_ = self.shape_primitive_nsprefix_ + ':' if (UseCapturedNS_ and self.shape_primitive_nsprefix_) else ''
            shape_primitive_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='shape_primitive', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'shape_primitive':
            obj_ = shape_primitive.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shape_primitive.append(obj_)
            obj_.original_tagname_ = 'shape_primitive'
        elif nodeName_ == 'cuboid':
            obj_ = cuboid.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shape_primitive.append(obj_)
            obj_.original_tagname_ = 'cuboid'
        elif nodeName_ == 'ellipsoid':
            obj_ = ellipsoid.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shape_primitive.append(obj_)
            obj_.original_tagname_ = 'ellipsoid'
        elif nodeName_ == 'cylinder':
            obj_ = cylinder.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shape_primitive.append(obj_)
            obj_.original_tagname_ = 'cylinder'
        elif nodeName_ == 'cone':
            obj_ = cone.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shape_primitive.append(obj_)
            obj_.original_tagname_ = 'cone'
        elif nodeName_ == 'subtomogram_average':
            obj_ = three_d_volume_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.shape_primitive.append(obj_)
            obj_.original_tagname_ = 'subtomogram_average'
# end class shape_primitive_listType


class mesh_listType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, mesh=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if mesh is None:
            self.mesh = []
        else:
            self.mesh = mesh
        self.mesh_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, mesh_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if mesh_listType.subclass:
            return mesh_listType.subclass(*args_, **kwargs_)
        else:
            return mesh_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_mesh(self):
        return self.mesh
    def set_mesh(self, mesh):
        self.mesh = mesh
    def add_mesh(self, value):
        self.mesh.append(value)
    def insert_mesh_at(self, index, value):
        self.mesh.insert(index, value)
    def replace_mesh_at(self, index, value):
        self.mesh[index] = value
    def hasContent_(self):
        if (
            self.mesh
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='mesh_listType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('mesh_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='mesh_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='mesh_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='mesh_listType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='mesh_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for mesh_ in self.mesh:
            namespaceprefix_ = self.mesh_nsprefix_ + ':' if (UseCapturedNS_ and self.mesh_nsprefix_) else ''
            mesh_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='mesh', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'mesh':
            obj_ = mesh_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.mesh.append(obj_)
            obj_.original_tagname_ = 'mesh'
# end class mesh_listType


class macromolecule_listType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, macromolecule=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if macromolecule is None:
            self.macromolecule = []
        else:
            self.macromolecule = macromolecule
        self.macromolecule_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, macromolecule_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if macromolecule_listType.subclass:
            return macromolecule_listType.subclass(*args_, **kwargs_)
        else:
            return macromolecule_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_macromolecule(self):
        return self.macromolecule
    def set_macromolecule(self, macromolecule):
        self.macromolecule = macromolecule
    def add_macromolecule(self, value):
        self.macromolecule.append(value)
    def insert_macromolecule_at(self, index, value):
        self.macromolecule.insert(index, value)
    def replace_macromolecule_at(self, index, value):
        self.macromolecule[index] = value
    def hasContent_(self):
        if (
            self.macromolecule
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='macromolecule_listType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('macromolecule_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='macromolecule_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='macromolecule_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='macromolecule_listType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='macromolecule_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for macromolecule_ in self.macromolecule:
            namespaceprefix_ = self.macromolecule_nsprefix_ + ':' if (UseCapturedNS_ and self.macromolecule_nsprefix_) else ''
            macromolecule_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='macromolecule', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'macromolecule':
            obj_ = biomolecule_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.macromolecule.append(obj_)
            obj_.original_tagname_ = 'macromolecule'
# end class macromolecule_listType


class complex_listType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    subclass = None
    superclass = None
    def __init__(self, complex=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get('parent_object_')
        self.ns_prefix_ = None
        if complex is None:
            self.complex = []
        else:
            self.complex = complex
        self.complex_nsprefix_ = None
    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, complex_listType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if complex_listType.subclass:
            return complex_listType.subclass(*args_, **kwargs_)
        else:
            return complex_listType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_ns_prefix_(self):
        return self.ns_prefix_
    def set_ns_prefix_(self, ns_prefix):
        self.ns_prefix_ = ns_prefix
    def get_complex(self):
        return self.complex
    def set_complex(self, complex):
        self.complex = complex
    def add_complex(self, value):
        self.complex.append(value)
    def insert_complex_at(self, index, value):
        self.complex.insert(index, value)
    def replace_complex_at(self, index, value):
        self.complex[index] = value
    def hasContent_(self):
        if (
            self.complex
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='complex_listType', pretty_print=True):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get('complex_listType')
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ':'
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespaceprefix_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespaceprefix_, name_='complex_listType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespaceprefix_, namespacedef_, name_='complex_listType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespaceprefix_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespaceprefix_='', name_='complex_listType'):
        pass
    def exportChildren(self, outfile, level, namespaceprefix_='', namespacedef_='', name_='complex_listType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for complex_ in self.complex:
            namespaceprefix_ = self.complex_nsprefix_ + ':' if (UseCapturedNS_ and self.complex_nsprefix_) else ''
            complex_.export(outfile, level, namespaceprefix_, namespacedef_='', name_='complex', pretty_print=pretty_print)
    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None):
        if nodeName_ == 'complex':
            obj_ = biomolecule_type.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.complex.append(obj_)
            obj_.original_tagname_ = 'complex'
# end class complex_listType


GDSClassesMapping = {
    'canonicalEulerAngles': canonicalEulerAnglesType,
    'subtomogram_average': three_d_volume_type,
    'transformation_matrix': transformation_matrix_type,
    'viewVectorRotation': viewVectorRotationType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def get_required_ns_prefix_defs(rootNode):
    '''Get all name space prefix definitions required in this XML doc.
    Return a dictionary of definitions and a char string of definitions.
    '''
    nsmap = {
        prefix: uri
        for node in rootNode.iter()
        for (prefix, uri) in node.nsmap.items()
        if prefix is not None
    }
    namespacedefs = ' '.join([
        'xmlns:{}="{}"'.format(prefix, uri)
        for prefix, uri in nsmap.items()
    ])
    return nsmap, namespacedefs


def parse(inFileName, silence=False, print_warnings=True):
    global CapturedNsmap_
    gds_collector = GdsCollector_()
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'segmentation'
        rootClass = segmentation
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    CapturedNsmap_, namespacedefs = get_required_ns_prefix_defs(rootNode)
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_=namespacedefs,
            pretty_print=True)
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def parseEtree(inFileName, silence=False, print_warnings=True):
    parser = None
    doc = parsexml_(inFileName, parser)
    gds_collector = GdsCollector_()
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'segmentation'
        rootClass = segmentation
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    # Enable Python to collect the space used by the DOM.
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(str(content))
        sys.stdout.write('\n')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False, print_warnings=True):
    '''Parse a string, create the object tree, and export it.

    Arguments:
    - inString -- A string.  This XML fragment should not start
      with an XML declaration containing an encoding.
    - silence -- A boolean.  If False, export the object.
    Returns -- The root object in the tree.
    '''
    parser = None
    rootNode= parsexmlstring_(inString, parser)
    gds_collector = GdsCollector_()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'segmentation'
        rootClass = segmentation
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    if not SaveElementTreeNode:
        rootNode = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def parseLiteral(inFileName, silence=False, print_warnings=True):
    parser = None
    doc = parsexml_(inFileName, parser)
    gds_collector = GdsCollector_()
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'segmentation'
        rootClass = segmentation
    rootObj = rootClass.factory()
    rootObj.build(rootNode, gds_collector_=gds_collector)
    # Enable Python to collect the space used by the DOM.
    if not SaveElementTreeNode:
        doc = None
        rootNode = None
    if not silence:
        sys.stdout.write('#from v_0_8_0_dev0 import *\n\n')
        sys.stdout.write('import v_0_8_0_dev0 as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    if print_warnings and len(gds_collector.get_messages()) > 0:
        separator = ('-' * 50) + '\n'
        sys.stderr.write(separator)
        sys.stderr.write('----- Warnings -- count: {} -----\n'.format(
            len(gds_collector.get_messages()), ))
        gds_collector.write_messages(sys.stderr)
        sys.stderr.write(separator)
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

RenameMappings_ = {
}

__all__ = [
    "biological_annotationType",
    "biomolecule_type",
    "bounding_box_type",
    "canonicalEulerAnglesType",
    "colourType",
    "complex_listType",
    "complexes_and_macromolecules_type",
    "cone",
    "contourType",
    "cuboid",
    "cylinder",
    "ellipsoid",
    "external_reference_type",
    "external_referencesType",
    "float_vector_type",
    "global_external_referencesType",
    "hsvType",
    "integerVectorType",
    "lattice_listType",
    "lattice_type",
    "macromolecule_listType",
    "meshPointType",
    "mesh_listType",
    "mesh_type",
    "normals_type",
    "oldThreeDVolumeType",
    "positiveIntegerVectorType",
    "rgba_type",
    "runLengthEncodingType",
    "segment_listType",
    "segment_type",
    "segmentation",
    "shape_primitive",
    "shape_primitive_listType",
    "software_listType",
    "software_type",
    "three_d_volume_type",
    "transform",
    "transform_listType",
    "transformation_matrix_type",
    "triangle_list_type",
    "triangle_type",
    "triangles_type",
    "vertex_list_type",
    "vertex_type",
    "vertices_type",
    "viewVectorRotationType",
    "volume_index_type",
    "volume_structure_type"
]
