"""
To generate a test bam file for smartseq3 protocol, run as below:

$ python generate_test_bam_smartseq3.py > sam_smartseq3_test.sam
$ samtools view -bS sam_smartseq3_test.sam > smartseq3_test.bam
$ samtools sort smartseq3_test.bam -o smartseq3_test_sorted.bam
$ samtools index smartseq3_test_sorted.bam

"""

sequence = "ACGT" * 25  # => 100 nt reads

header = """@HD	VN:1.4	SO:coordinate
@SQ	SN:1	LN:248956422"""

first_forward_proper_primary = "VH00211:1:AAANLLGHV:2:2308:35235:56203	99	1	16442	255	37S93M	=	16567	225	CACTGTGGCCACCATTTTTTTTTTTTTTTTTTTTGGTTACAGTTTGAAAACCACTATTTTATGAACCAAGTAGAACAAGATATTTGAAATCGAAACTATTCAAAAAATTGAGAATTTCTGACCACTTAAC	CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC;C-CCCCCCC;CC;CC;CCCCCCCCC;C;CCCC;CCCCCC-C;CCC;CCCCCCCC;CCCCCC-C-CCCCCCCCCCCCC;CCCCC;CCCCC;	NH:i:1	HI:i:1	AS:i:189	nM:i:1	NM:i:1	MD:Z:53G39	jM:B:c,-1	jI:B:i,-1	MC:Z:100M"
first_reverse_proper_primary = "VH00211:1:AAANLLGHV:1:2412:52959:17395	83	1	14317	1	97M33S	=	14196	-218	GACCAACAGGGGCAGGAGGCAGTCACTGACCCCGAGAAGTTTGCATCCTGCACAGCTAGAGATCCTTTATTAAAAGCACACTGTTGGTTTCTGCTCAAAAAAAAAAAAAAAAAAAACATATCACACAGTG	CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC-CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC	NH:i:3	HI:i:1	AS:i:191	nM:i:2	NM:i:1	MD:Z:37C59	jM:B:c,-1	jI:B:i,-1	MC:Z:100M"

first_forward_unmapped = "VH00211:1:AAANLLGHV:2:1412:36656:20670	73	1	184916	1	31S99M	*	0	0	CACTGTTGGGGTAATTTTTTTTTTTTTTTTTTTGTTTTCTGCTCAGTTCTTTATTGATTGGTGTGCCATTTTCTCTGGAAGCCTCTTTAGAGAAGAACACAGTGGCGCAGGCTGGGTGGAGCCGTCCCCC	CC;CCCCCCCCCCCCCCCCCCCCCCCCCCCC;;CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC-CCCCCCCC;CCCCCCCCCCCCCCCCCCCCCCCC-CCCCCC--C	NH:i:4	HI:i:1	AS:i:91	nM:i:3	NM:i:3	MD:Z:3G32G19A42	jM:B:c,-1	jI:B:i,-1"
first_reverse_unmapped = "VH00211:1:AAANLLGHV:2:1413:37205:35531	89	1	629093	3	96M34S	*	0	0	AACTAGTCTCAGGCTTCAACATCGAATACGCCGCAGGCCCCTTCGCCCTATTCTTCATAGCCGAATACACAAACATTATTATAATAAACACCCCCAAAAAAAAAAAAAAAAAAAAATCATCCCGACAGTG	CCCCCCCCCCCCCCC-C-CCCCC;CCCCCCCCC-CCCCCCCCCCCCC-CCC--;CCCC-CCC;CCCCCC-;CCC;CCCCCC-;C;CCCCCCC;CC;-C;CC-;;C-CCCCCCCCCC-C;C;;CCCCC;CC	NH:i:2	HI:i:1	AS:i:92	nM:i:1	NM:i:1	MD:Z:93T2	jM:B:c,-1	jI:B:i,-1"

first_forward_notproper = "VH00211:1:AAANLLGHV:2:1307:48377:27921	97	1	16447	255	31S99M	=	16451	104	CACTGTAGGTTGACTTTTTTTTTTTTTTTTTTTTGAAAACCACTATTTTATGAACCAAGTAGAACAAGATATTTGAAATCGAAACTATTCAAAAAATTGAGAATTTCTGACCACTTAACAAACCCACAGA	CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC-CCCCCCCC;CCCCCCCCCCCCCC;CCCCC-C;CCCCCCCC;CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC;CCCCCCCC	NH:i:1	HI:i:1	AS:i:193	nM:i:2	NM:i:1	MD:Z:48G50	jM:B:c,-1	jI:B:i,-1	MC:Z:100M"

first_forward_proper_notprimary = "VH00211:1:AAANLLGHV:1:2614:73334:12094	355	1	14404	1	32S98M	=	14458	154	CACTGTATTGAGCCTTTTTTTTTTTTTTTTTTTTCCTGCTCAGTTCTTTATTGATTGGTGTGCCGTTTTCTCTGGAAGCCTCTTAAGAACACAGTGGCACAGGCTGGGTGGAGCCGTCCCCCCATGGAGC	CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC;CCCCC;CCCCCCCCCCCCCCCCCCC;CC;CCCCCCCCCCCC;CCCCC;CC;;CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC-CCC	NH:i:3	HI:i:3	AS:i:190	nM:i:3	NM:i:2	MD:Z:2T63G31	jM:B:c,-1	jI:B:i,-1	MC:Z:100M"

second_reverse_proper_primary = "VH00211:1:AAANLLGHV:2:2510:26658:20102	147	1	14489	1	100M	=	14404	-185	CCCCCCATGGAGCACAGGCAGACAGAAGTCCCCGCCCCAGCTGTGTGGCCTCAAGCCAGCCTTCCGCTCCTTGAAGCTGGTCTCCACACAGTGCTGGTTC	CCCCCCCCCCCCC;CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC;C-CCCCC;CCCCCCC;CCCCCCCCCCCCCC;	NH:i:3	HI:i:1	AS:i:184	nM:i:6	NM:i:0	MD:Z:100	jM:B:c,-1	jI:B:i,-1	MC:Z:32S98M"

print("\n".join([
    header,
    first_forward_proper_primary,
    first_reverse_proper_primary,
    first_forward_unmapped,
    first_reverse_unmapped,
    first_forward_notproper,
    first_forward_proper_notprimary,
    second_reverse_proper_primary
]))
