# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The Powerbot system provides B2B services for trading at intraday power markets. By using the Powerbot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that he/she is familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/extras/download-center/documentation) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION Powerbot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## DOCUMENTATION  In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The Powerbot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) The API provides automated generation of API clients (programming libraries) for a wide range of programming languages. To generate them, please open Swagger Editor from the exchange menu, click on \"Generate Client\" and choose a programming language.  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    OpenAPI spec version: 2.1.27
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Trade(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'trade_id': 'str',
        'state': 'str',
        'exchange': 'str',
        'delivery_area': 'str',
        'api_timestamp': 'datetime',
        'exec_time': 'datetime',
        'buy': 'bool',
        'sell': 'bool',
        'buy_order_id': 'str',
        'buy_delivery_area': 'str',
        'buy_cl_order_id': 'str',
        'buy_txt': 'str',
        'buy_user_code': 'str',
        'buy_member_id': 'str',
        'buy_aggressor_indicator': 'str',
        'buy_portfolio_id': 'str',
        'sell_order_id': 'str',
        'sell_delivery_area': 'str',
        'sell_cl_order_id': 'str',
        'sell_txt': 'str',
        'sell_user_code': 'str',
        'sell_member_id': 'str',
        'sell_aggressor_indicator': 'str',
        'sell_portfolio_id': 'str',
        'contract_id': 'str',
        'contract_name': 'str',
        'delivery_start': 'datetime',
        'delivery_end': 'datetime',
        'price': 'float',
        'quantity': 'float',
        'prod': 'str',
        'self_trade': 'bool',
        'pre_arranged': 'bool',
        'pre_arrange_type': 'str'
    }

    attribute_map = {
        'trade_id': 'trade_id',
        'state': 'state',
        'exchange': 'exchange',
        'delivery_area': 'delivery_area',
        'api_timestamp': 'api_timestamp',
        'exec_time': 'exec_time',
        'buy': 'buy',
        'sell': 'sell',
        'buy_order_id': 'buy_order_id',
        'buy_delivery_area': 'buy_delivery_area',
        'buy_cl_order_id': 'buy_clOrderId',
        'buy_txt': 'buy_txt',
        'buy_user_code': 'buy_user_code',
        'buy_member_id': 'buy_member_id',
        'buy_aggressor_indicator': 'buy_aggressor_indicator',
        'buy_portfolio_id': 'buy_portfolio_id',
        'sell_order_id': 'sell_order_id',
        'sell_delivery_area': 'sell_delivery_area',
        'sell_cl_order_id': 'sell_clOrderId',
        'sell_txt': 'sell_txt',
        'sell_user_code': 'sell_user_code',
        'sell_member_id': 'sell_member_id',
        'sell_aggressor_indicator': 'sell_aggressor_indicator',
        'sell_portfolio_id': 'sell_portfolio_id',
        'contract_id': 'contract_id',
        'contract_name': 'contract_name',
        'delivery_start': 'delivery_start',
        'delivery_end': 'delivery_end',
        'price': 'price',
        'quantity': 'quantity',
        'prod': 'prod',
        'self_trade': 'self_trade',
        'pre_arranged': 'pre_arranged',
        'pre_arrange_type': 'pre_arrange_type'
    }

    def __init__(self, trade_id=None, state=None, exchange=None, delivery_area=None, api_timestamp=None, exec_time=None, buy=None, sell=None, buy_order_id=None, buy_delivery_area=None, buy_cl_order_id=None, buy_txt=None, buy_user_code=None, buy_member_id=None, buy_aggressor_indicator=None, buy_portfolio_id=None, sell_order_id=None, sell_delivery_area=None, sell_cl_order_id=None, sell_txt=None, sell_user_code=None, sell_member_id=None, sell_aggressor_indicator=None, sell_portfolio_id=None, contract_id=None, contract_name=None, delivery_start=None, delivery_end=None, price=None, quantity=None, prod=None, self_trade=None, pre_arranged=None, pre_arrange_type=None):  # noqa: E501
        """Trade - a model defined in Swagger"""  # noqa: E501
        self._trade_id = None
        self._state = None
        self._exchange = None
        self._delivery_area = None
        self._api_timestamp = None
        self._exec_time = None
        self._buy = None
        self._sell = None
        self._buy_order_id = None
        self._buy_delivery_area = None
        self._buy_cl_order_id = None
        self._buy_txt = None
        self._buy_user_code = None
        self._buy_member_id = None
        self._buy_aggressor_indicator = None
        self._buy_portfolio_id = None
        self._sell_order_id = None
        self._sell_delivery_area = None
        self._sell_cl_order_id = None
        self._sell_txt = None
        self._sell_user_code = None
        self._sell_member_id = None
        self._sell_aggressor_indicator = None
        self._sell_portfolio_id = None
        self._contract_id = None
        self._contract_name = None
        self._delivery_start = None
        self._delivery_end = None
        self._price = None
        self._quantity = None
        self._prod = None
        self._self_trade = None
        self._pre_arranged = None
        self._pre_arrange_type = None
        self.discriminator = None
        if trade_id is not None:
            self.trade_id = trade_id
        if state is not None:
            self.state = state
        if exchange is not None:
            self.exchange = exchange
        if delivery_area is not None:
            self.delivery_area = delivery_area
        if api_timestamp is not None:
            self.api_timestamp = api_timestamp
        if exec_time is not None:
            self.exec_time = exec_time
        if buy is not None:
            self.buy = buy
        if sell is not None:
            self.sell = sell
        if buy_order_id is not None:
            self.buy_order_id = buy_order_id
        if buy_delivery_area is not None:
            self.buy_delivery_area = buy_delivery_area
        if buy_cl_order_id is not None:
            self.buy_cl_order_id = buy_cl_order_id
        if buy_txt is not None:
            self.buy_txt = buy_txt
        if buy_user_code is not None:
            self.buy_user_code = buy_user_code
        if buy_member_id is not None:
            self.buy_member_id = buy_member_id
        if buy_aggressor_indicator is not None:
            self.buy_aggressor_indicator = buy_aggressor_indicator
        if buy_portfolio_id is not None:
            self.buy_portfolio_id = buy_portfolio_id
        if sell_order_id is not None:
            self.sell_order_id = sell_order_id
        if sell_delivery_area is not None:
            self.sell_delivery_area = sell_delivery_area
        if sell_cl_order_id is not None:
            self.sell_cl_order_id = sell_cl_order_id
        if sell_txt is not None:
            self.sell_txt = sell_txt
        if sell_user_code is not None:
            self.sell_user_code = sell_user_code
        if sell_member_id is not None:
            self.sell_member_id = sell_member_id
        if sell_aggressor_indicator is not None:
            self.sell_aggressor_indicator = sell_aggressor_indicator
        if sell_portfolio_id is not None:
            self.sell_portfolio_id = sell_portfolio_id
        if contract_id is not None:
            self.contract_id = contract_id
        if contract_name is not None:
            self.contract_name = contract_name
        if delivery_start is not None:
            self.delivery_start = delivery_start
        if delivery_end is not None:
            self.delivery_end = delivery_end
        if price is not None:
            self.price = price
        if quantity is not None:
            self.quantity = quantity
        if prod is not None:
            self.prod = prod
        if self_trade is not None:
            self.self_trade = self_trade
        if pre_arranged is not None:
            self.pre_arranged = pre_arranged
        if pre_arrange_type is not None:
            self.pre_arrange_type = pre_arrange_type

    @property
    def trade_id(self):
        """Gets the trade_id of this Trade.  # noqa: E501

        Unique trade_id  # noqa: E501

        :return: The trade_id of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._trade_id

    @trade_id.setter
    def trade_id(self, trade_id):
        """Sets the trade_id of this Trade.

        Unique trade_id  # noqa: E501

        :param trade_id: The trade_id of this Trade.  # noqa: E501
        :type: str
        """

        self._trade_id = trade_id

    @property
    def state(self):
        """Gets the state of this Trade.  # noqa: E501

        * CNCL: Trade was cancelled by market operations. * RREJ: Requested Recall was rejected by market operations. * RGRA: Requested Recall was granted by market operations. * RREQ: Recall of this trade was requested. * ACTI: Trade is active (this is the default value). * CREQ: cancel was requested from local market operations. * CREJ: cancel was rejected by global market operations. * RSFA: Request sent for approval to SOB (XBID).  # noqa: E501

        :return: The state of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Trade.

        * CNCL: Trade was cancelled by market operations. * RREJ: Requested Recall was rejected by market operations. * RGRA: Requested Recall was granted by market operations. * RREQ: Recall of this trade was requested. * ACTI: Trade is active (this is the default value). * CREQ: cancel was requested from local market operations. * CREJ: cancel was rejected by global market operations. * RSFA: Request sent for approval to SOB (XBID).  # noqa: E501

        :param state: The state of this Trade.  # noqa: E501
        :type: str
        """
        allowed_values = ["CNCL", "RREJ", "RGRA", "RREQ", "ACTI", "CREQ", "CREJ", "RSFA"]  # noqa: E501
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def exchange(self):
        """Gets the exchange of this Trade.  # noqa: E501

        The exchange where the trade was executed  # noqa: E501

        :return: The exchange of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._exchange

    @exchange.setter
    def exchange(self, exchange):
        """Sets the exchange of this Trade.

        The exchange where the trade was executed  # noqa: E501

        :param exchange: The exchange of this Trade.  # noqa: E501
        :type: str
        """

        self._exchange = exchange

    @property
    def delivery_area(self):
        """Gets the delivery_area of this Trade.  # noqa: E501

        If you sold energy with this trade, delivery_area will contain the sell_delivery_area, otherwise the buy_delivery_area  # noqa: E501

        :return: The delivery_area of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._delivery_area

    @delivery_area.setter
    def delivery_area(self, delivery_area):
        """Sets the delivery_area of this Trade.

        If you sold energy with this trade, delivery_area will contain the sell_delivery_area, otherwise the buy_delivery_area  # noqa: E501

        :param delivery_area: The delivery_area of this Trade.  # noqa: E501
        :type: str
        """

        self._delivery_area = delivery_area

    @property
    def api_timestamp(self):
        """Gets the api_timestamp of this Trade.  # noqa: E501

        The timestamp when the trade was received (UTC time zone)  # noqa: E501

        :return: The api_timestamp of this Trade.  # noqa: E501
        :rtype: datetime
        """
        return self._api_timestamp

    @api_timestamp.setter
    def api_timestamp(self, api_timestamp):
        """Sets the api_timestamp of this Trade.

        The timestamp when the trade was received (UTC time zone)  # noqa: E501

        :param api_timestamp: The api_timestamp of this Trade.  # noqa: E501
        :type: datetime
        """

        self._api_timestamp = api_timestamp

    @property
    def exec_time(self):
        """Gets the exec_time of this Trade.  # noqa: E501

        The timestamp when the trade was executed (UTC time zone)  # noqa: E501

        :return: The exec_time of this Trade.  # noqa: E501
        :rtype: datetime
        """
        return self._exec_time

    @exec_time.setter
    def exec_time(self, exec_time):
        """Sets the exec_time of this Trade.

        The timestamp when the trade was executed (UTC time zone)  # noqa: E501

        :param exec_time: The exec_time of this Trade.  # noqa: E501
        :type: datetime
        """

        self._exec_time = exec_time

    @property
    def buy(self):
        """Gets the buy of this Trade.  # noqa: E501

        true if you bought energy  # noqa: E501

        :return: The buy of this Trade.  # noqa: E501
        :rtype: bool
        """
        return self._buy

    @buy.setter
    def buy(self, buy):
        """Sets the buy of this Trade.

        true if you bought energy  # noqa: E501

        :param buy: The buy of this Trade.  # noqa: E501
        :type: bool
        """

        self._buy = buy

    @property
    def sell(self):
        """Gets the sell of this Trade.  # noqa: E501

        true if you sold energy  # noqa: E501

        :return: The sell of this Trade.  # noqa: E501
        :rtype: bool
        """
        return self._sell

    @sell.setter
    def sell(self, sell):
        """Sets the sell of this Trade.

        true if you sold energy  # noqa: E501

        :param sell: The sell of this Trade.  # noqa: E501
        :type: bool
        """

        self._sell = sell

    @property
    def buy_order_id(self):
        """Gets the buy_order_id of this Trade.  # noqa: E501

        the order_id of the underlying buy-order  # noqa: E501

        :return: The buy_order_id of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._buy_order_id

    @buy_order_id.setter
    def buy_order_id(self, buy_order_id):
        """Sets the buy_order_id of this Trade.

        the order_id of the underlying buy-order  # noqa: E501

        :param buy_order_id: The buy_order_id of this Trade.  # noqa: E501
        :type: str
        """

        self._buy_order_id = buy_order_id

    @property
    def buy_delivery_area(self):
        """Gets the buy_delivery_area of this Trade.  # noqa: E501

        The delivery area of the buy-side of the trade.  # noqa: E501

        :return: The buy_delivery_area of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._buy_delivery_area

    @buy_delivery_area.setter
    def buy_delivery_area(self, buy_delivery_area):
        """Sets the buy_delivery_area of this Trade.

        The delivery area of the buy-side of the trade.  # noqa: E501

        :param buy_delivery_area: The buy_delivery_area of this Trade.  # noqa: E501
        :type: str
        """

        self._buy_delivery_area = buy_delivery_area

    @property
    def buy_cl_order_id(self):
        """Gets the buy_cl_order_id of this Trade.  # noqa: E501

        the client order id of the buy order  # noqa: E501

        :return: The buy_cl_order_id of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._buy_cl_order_id

    @buy_cl_order_id.setter
    def buy_cl_order_id(self, buy_cl_order_id):
        """Sets the buy_cl_order_id of this Trade.

        the client order id of the buy order  # noqa: E501

        :param buy_cl_order_id: The buy_cl_order_id of this Trade.  # noqa: E501
        :type: str
        """

        self._buy_cl_order_id = buy_cl_order_id

    @property
    def buy_txt(self):
        """Gets the buy_txt of this Trade.  # noqa: E501

        the custom text of the buy order  # noqa: E501

        :return: The buy_txt of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._buy_txt

    @buy_txt.setter
    def buy_txt(self, buy_txt):
        """Sets the buy_txt of this Trade.

        the custom text of the buy order  # noqa: E501

        :param buy_txt: The buy_txt of this Trade.  # noqa: E501
        :type: str
        """

        self._buy_txt = buy_txt

    @property
    def buy_user_code(self):
        """Gets the buy_user_code of this Trade.  # noqa: E501

        the buyer's exchange user code  # noqa: E501

        :return: The buy_user_code of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._buy_user_code

    @buy_user_code.setter
    def buy_user_code(self, buy_user_code):
        """Sets the buy_user_code of this Trade.

        the buyer's exchange user code  # noqa: E501

        :param buy_user_code: The buy_user_code of this Trade.  # noqa: E501
        :type: str
        """

        self._buy_user_code = buy_user_code

    @property
    def buy_member_id(self):
        """Gets the buy_member_id of this Trade.  # noqa: E501

        the buyer's exchange member id  # noqa: E501

        :return: The buy_member_id of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._buy_member_id

    @buy_member_id.setter
    def buy_member_id(self, buy_member_id):
        """Sets the buy_member_id of this Trade.

        the buyer's exchange member id  # noqa: E501

        :param buy_member_id: The buy_member_id of this Trade.  # noqa: E501
        :type: str
        """

        self._buy_member_id = buy_member_id

    @property
    def buy_aggressor_indicator(self):
        """Gets the buy_aggressor_indicator of this Trade.  # noqa: E501

        Indicates whether the executed order was a trade aggressor or trade originator. * Y - Trade aggressor * N - Trade originator * U - Unknown, for executed orders of remote products and data before migration  # noqa: E501

        :return: The buy_aggressor_indicator of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._buy_aggressor_indicator

    @buy_aggressor_indicator.setter
    def buy_aggressor_indicator(self, buy_aggressor_indicator):
        """Sets the buy_aggressor_indicator of this Trade.

        Indicates whether the executed order was a trade aggressor or trade originator. * Y - Trade aggressor * N - Trade originator * U - Unknown, for executed orders of remote products and data before migration  # noqa: E501

        :param buy_aggressor_indicator: The buy_aggressor_indicator of this Trade.  # noqa: E501
        :type: str
        """
        allowed_values = ["Y", "N", "U"]  # noqa: E501
        if buy_aggressor_indicator not in allowed_values:
            raise ValueError(
                "Invalid value for `buy_aggressor_indicator` ({0}), must be one of {1}"  # noqa: E501
                .format(buy_aggressor_indicator, allowed_values)
            )

        self._buy_aggressor_indicator = buy_aggressor_indicator

    @property
    def buy_portfolio_id(self):
        """Gets the buy_portfolio_id of this Trade.  # noqa: E501


        :return: The buy_portfolio_id of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._buy_portfolio_id

    @buy_portfolio_id.setter
    def buy_portfolio_id(self, buy_portfolio_id):
        """Sets the buy_portfolio_id of this Trade.


        :param buy_portfolio_id: The buy_portfolio_id of this Trade.  # noqa: E501
        :type: str
        """

        self._buy_portfolio_id = buy_portfolio_id

    @property
    def sell_order_id(self):
        """Gets the sell_order_id of this Trade.  # noqa: E501

        The seller's order id  # noqa: E501

        :return: The sell_order_id of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._sell_order_id

    @sell_order_id.setter
    def sell_order_id(self, sell_order_id):
        """Sets the sell_order_id of this Trade.

        The seller's order id  # noqa: E501

        :param sell_order_id: The sell_order_id of this Trade.  # noqa: E501
        :type: str
        """

        self._sell_order_id = sell_order_id

    @property
    def sell_delivery_area(self):
        """Gets the sell_delivery_area of this Trade.  # noqa: E501

        delivery area of the sell order  # noqa: E501

        :return: The sell_delivery_area of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._sell_delivery_area

    @sell_delivery_area.setter
    def sell_delivery_area(self, sell_delivery_area):
        """Sets the sell_delivery_area of this Trade.

        delivery area of the sell order  # noqa: E501

        :param sell_delivery_area: The sell_delivery_area of this Trade.  # noqa: E501
        :type: str
        """

        self._sell_delivery_area = sell_delivery_area

    @property
    def sell_cl_order_id(self):
        """Gets the sell_cl_order_id of this Trade.  # noqa: E501

        The sell order's client id  # noqa: E501

        :return: The sell_cl_order_id of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._sell_cl_order_id

    @sell_cl_order_id.setter
    def sell_cl_order_id(self, sell_cl_order_id):
        """Sets the sell_cl_order_id of this Trade.

        The sell order's client id  # noqa: E501

        :param sell_cl_order_id: The sell_cl_order_id of this Trade.  # noqa: E501
        :type: str
        """

        self._sell_cl_order_id = sell_cl_order_id

    @property
    def sell_txt(self):
        """Gets the sell_txt of this Trade.  # noqa: E501

        The sell order's custom text  # noqa: E501

        :return: The sell_txt of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._sell_txt

    @sell_txt.setter
    def sell_txt(self, sell_txt):
        """Sets the sell_txt of this Trade.

        The sell order's custom text  # noqa: E501

        :param sell_txt: The sell_txt of this Trade.  # noqa: E501
        :type: str
        """

        self._sell_txt = sell_txt

    @property
    def sell_user_code(self):
        """Gets the sell_user_code of this Trade.  # noqa: E501

        The seller's exchange user code  # noqa: E501

        :return: The sell_user_code of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._sell_user_code

    @sell_user_code.setter
    def sell_user_code(self, sell_user_code):
        """Sets the sell_user_code of this Trade.

        The seller's exchange user code  # noqa: E501

        :param sell_user_code: The sell_user_code of this Trade.  # noqa: E501
        :type: str
        """

        self._sell_user_code = sell_user_code

    @property
    def sell_member_id(self):
        """Gets the sell_member_id of this Trade.  # noqa: E501

        The seller's exchange member id  # noqa: E501

        :return: The sell_member_id of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._sell_member_id

    @sell_member_id.setter
    def sell_member_id(self, sell_member_id):
        """Sets the sell_member_id of this Trade.

        The seller's exchange member id  # noqa: E501

        :param sell_member_id: The sell_member_id of this Trade.  # noqa: E501
        :type: str
        """

        self._sell_member_id = sell_member_id

    @property
    def sell_aggressor_indicator(self):
        """Gets the sell_aggressor_indicator of this Trade.  # noqa: E501

        Indicates whether the executed order was a trade aggressor or trade originator. * Y - Trade aggressor * N - Trade originator * U - Unknown, for executed orders of remote products and data before migration  # noqa: E501

        :return: The sell_aggressor_indicator of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._sell_aggressor_indicator

    @sell_aggressor_indicator.setter
    def sell_aggressor_indicator(self, sell_aggressor_indicator):
        """Sets the sell_aggressor_indicator of this Trade.

        Indicates whether the executed order was a trade aggressor or trade originator. * Y - Trade aggressor * N - Trade originator * U - Unknown, for executed orders of remote products and data before migration  # noqa: E501

        :param sell_aggressor_indicator: The sell_aggressor_indicator of this Trade.  # noqa: E501
        :type: str
        """
        allowed_values = ["Y", "N", "U"]  # noqa: E501
        if sell_aggressor_indicator not in allowed_values:
            raise ValueError(
                "Invalid value for `sell_aggressor_indicator` ({0}), must be one of {1}"  # noqa: E501
                .format(sell_aggressor_indicator, allowed_values)
            )

        self._sell_aggressor_indicator = sell_aggressor_indicator

    @property
    def sell_portfolio_id(self):
        """Gets the sell_portfolio_id of this Trade.  # noqa: E501


        :return: The sell_portfolio_id of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._sell_portfolio_id

    @sell_portfolio_id.setter
    def sell_portfolio_id(self, sell_portfolio_id):
        """Sets the sell_portfolio_id of this Trade.


        :param sell_portfolio_id: The sell_portfolio_id of this Trade.  # noqa: E501
        :type: str
        """

        self._sell_portfolio_id = sell_portfolio_id

    @property
    def contract_id(self):
        """Gets the contract_id of this Trade.  # noqa: E501

        The contract_id against which the trade was executed  # noqa: E501

        :return: The contract_id of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this Trade.

        The contract_id against which the trade was executed  # noqa: E501

        :param contract_id: The contract_id of this Trade.  # noqa: E501
        :type: str
        """

        self._contract_id = contract_id

    @property
    def contract_name(self):
        """Gets the contract_name of this Trade.  # noqa: E501

        The contract's name against which the trade was executed.  # noqa: E501

        :return: The contract_name of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._contract_name

    @contract_name.setter
    def contract_name(self, contract_name):
        """Sets the contract_name of this Trade.

        The contract's name against which the trade was executed.  # noqa: E501

        :param contract_name: The contract_name of this Trade.  # noqa: E501
        :type: str
        """

        self._contract_name = contract_name

    @property
    def delivery_start(self):
        """Gets the delivery_start of this Trade.  # noqa: E501

        Time when the delivery of this trade starts (UTC timezone)  # noqa: E501

        :return: The delivery_start of this Trade.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_start

    @delivery_start.setter
    def delivery_start(self, delivery_start):
        """Sets the delivery_start of this Trade.

        Time when the delivery of this trade starts (UTC timezone)  # noqa: E501

        :param delivery_start: The delivery_start of this Trade.  # noqa: E501
        :type: datetime
        """

        self._delivery_start = delivery_start

    @property
    def delivery_end(self):
        """Gets the delivery_end of this Trade.  # noqa: E501

        Time when the delivery of this trade ends (UTC timezone)  # noqa: E501

        :return: The delivery_end of this Trade.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_end

    @delivery_end.setter
    def delivery_end(self, delivery_end):
        """Sets the delivery_end of this Trade.

        Time when the delivery of this trade ends (UTC timezone)  # noqa: E501

        :param delivery_end: The delivery_end of this Trade.  # noqa: E501
        :type: datetime
        """

        self._delivery_end = delivery_end

    @property
    def price(self):
        """Gets the price of this Trade.  # noqa: E501

        Price of the trade  # noqa: E501

        :return: The price of this Trade.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this Trade.

        Price of the trade  # noqa: E501

        :param price: The price of this Trade.  # noqa: E501
        :type: float
        """

        self._price = price

    @property
    def quantity(self):
        """Gets the quantity of this Trade.  # noqa: E501

        Quantity in MW for this trade  # noqa: E501

        :return: The quantity of this Trade.  # noqa: E501
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this Trade.

        Quantity in MW for this trade  # noqa: E501

        :param quantity: The quantity of this Trade.  # noqa: E501
        :type: float
        """

        self._quantity = quantity

    @property
    def prod(self):
        """Gets the prod of this Trade.  # noqa: E501

        Product id  # noqa: E501

        :return: The prod of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._prod

    @prod.setter
    def prod(self, prod):
        """Sets the prod of this Trade.

        Product id  # noqa: E501

        :param prod: The prod of this Trade.  # noqa: E501
        :type: str
        """

        self._prod = prod

    @property
    def self_trade(self):
        """Gets the self_trade of this Trade.  # noqa: E501


        :return: The self_trade of this Trade.  # noqa: E501
        :rtype: bool
        """
        return self._self_trade

    @self_trade.setter
    def self_trade(self, self_trade):
        """Sets the self_trade of this Trade.


        :param self_trade: The self_trade of this Trade.  # noqa: E501
        :type: bool
        """

        self._self_trade = self_trade

    @property
    def pre_arranged(self):
        """Gets the pre_arranged of this Trade.  # noqa: E501


        :return: The pre_arranged of this Trade.  # noqa: E501
        :rtype: bool
        """
        return self._pre_arranged

    @pre_arranged.setter
    def pre_arranged(self, pre_arranged):
        """Sets the pre_arranged of this Trade.


        :param pre_arranged: The pre_arranged of this Trade.  # noqa: E501
        :type: bool
        """

        self._pre_arranged = pre_arranged

    @property
    def pre_arrange_type(self):
        """Gets the pre_arrange_type of this Trade.  # noqa: E501


        :return: The pre_arrange_type of this Trade.  # noqa: E501
        :rtype: str
        """
        return self._pre_arrange_type

    @pre_arrange_type.setter
    def pre_arrange_type(self, pre_arrange_type):
        """Sets the pre_arrange_type of this Trade.


        :param pre_arrange_type: The pre_arrange_type of this Trade.  # noqa: E501
        :type: str
        """

        self._pre_arrange_type = pre_arrange_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Trade, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Trade):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
