# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The Powerbot system provides B2B services for trading at intraday power markets. By using the Powerbot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that he/she is familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/extras/download-center/documentation) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION Powerbot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## DOCUMENTATION  In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The Powerbot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) The API provides automated generation of API clients (programming libraries) for a wide range of programming languages. To generate them, please open Swagger Editor from the exchange menu, click on \"Generate Client\" and choose a programming language.  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    OpenAPI spec version: 2.1.27
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class OrderModify(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'action': 'str',
        'validity_res': 'str',
        'validity_date': 'datetime',
        'type': 'str',
        'txt': 'str',
        'ordr_exe_restriction': 'str',
        'quantity': 'float',
        'display_qty': 'float',
        'price': 'float',
        'cl_ordr_id': 'str',
        'ppd': 'float',
        'expected_net_pos': 'float',
        'expected_max_net_pos': 'float',
        'expected_min_net_pos': 'float'
    }

    attribute_map = {
        'action': 'action',
        'validity_res': 'validityRes',
        'validity_date': 'validityDate',
        'type': 'type',
        'txt': 'txt',
        'ordr_exe_restriction': 'ordrExeRestriction',
        'quantity': 'quantity',
        'display_qty': 'displayQty',
        'price': 'price',
        'cl_ordr_id': 'clOrdrId',
        'ppd': 'ppd',
        'expected_net_pos': 'expectedNetPos',
        'expected_max_net_pos': 'expectedMaxNetPos',
        'expected_min_net_pos': 'expectedMinNetPos'
    }

    def __init__(self, action=None, validity_res=None, validity_date=None, type=None, txt=None, ordr_exe_restriction=None, quantity=None, display_qty=None, price=None, cl_ordr_id=None, ppd=None, expected_net_pos=None, expected_max_net_pos=None, expected_min_net_pos=None):  # noqa: E501
        """OrderModify - a model defined in Swagger"""  # noqa: E501
        self._action = None
        self._validity_res = None
        self._validity_date = None
        self._type = None
        self._txt = None
        self._ordr_exe_restriction = None
        self._quantity = None
        self._display_qty = None
        self._price = None
        self._cl_ordr_id = None
        self._ppd = None
        self._expected_net_pos = None
        self._expected_max_net_pos = None
        self._expected_min_net_pos = None
        self.discriminator = None
        self.action = action
        if validity_res is not None:
            self.validity_res = validity_res
        if validity_date is not None:
            self.validity_date = validity_date
        if type is not None:
            self.type = type
        if txt is not None:
            self.txt = txt
        if ordr_exe_restriction is not None:
            self.ordr_exe_restriction = ordr_exe_restriction
        if quantity is not None:
            self.quantity = quantity
        if display_qty is not None:
            self.display_qty = display_qty
        if price is not None:
            self.price = price
        if cl_ordr_id is not None:
            self.cl_ordr_id = cl_ordr_id
        if ppd is not None:
            self.ppd = ppd
        if expected_net_pos is not None:
            self.expected_net_pos = expected_net_pos
        if expected_max_net_pos is not None:
            self.expected_max_net_pos = expected_max_net_pos
        if expected_min_net_pos is not None:
            self.expected_min_net_pos = expected_min_net_pos

    @property
    def action(self):
        """Gets the action of this OrderModify.  # noqa: E501

        * ACTI: Activates the order. Ignored if already active. * DEAC: Deactivates (hibernates) the order. Hibernated orders are removed from the order book but are still available for modification or activation in the own orders list. * MODI: Modify the order * DELE: Delete the order  # noqa: E501

        :return: The action of this OrderModify.  # noqa: E501
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """Sets the action of this OrderModify.

        * ACTI: Activates the order. Ignored if already active. * DEAC: Deactivates (hibernates) the order. Hibernated orders are removed from the order book but are still available for modification or activation in the own orders list. * MODI: Modify the order * DELE: Delete the order  # noqa: E501

        :param action: The action of this OrderModify.  # noqa: E501
        :type: str
        """
        if action is None:
            raise ValueError("Invalid value for `action`, must not be `None`")  # noqa: E501
        allowed_values = ["ACTI", "DEAC", "MODI", "DELE"]  # noqa: E501
        if action not in allowed_values:
            raise ValueError(
                "Invalid value for `action` ({0}), must be one of {1}"  # noqa: E501
                .format(action, allowed_values)
            )

        self._action = action

    @property
    def validity_res(self):
        """Gets the validity_res of this OrderModify.  # noqa: E501

        Set this field, if you want to update the validity restriction of the order * GFS (Good for trading session): The order stays in the order book until it is either executed, removed by the user or the current trading session (trading phase) of the underlying contract ends. * GTD (Good till date, will be introduced with CX 3.5): The order stays in the order book until the date specified in the validityDate field. * NON (No validity restriction): Mandatory for orders with the execution restriction ?FOK? or ?IOC?.  # noqa: E501

        :return: The validity_res of this OrderModify.  # noqa: E501
        :rtype: str
        """
        return self._validity_res

    @validity_res.setter
    def validity_res(self, validity_res):
        """Sets the validity_res of this OrderModify.

        Set this field, if you want to update the validity restriction of the order * GFS (Good for trading session): The order stays in the order book until it is either executed, removed by the user or the current trading session (trading phase) of the underlying contract ends. * GTD (Good till date, will be introduced with CX 3.5): The order stays in the order book until the date specified in the validityDate field. * NON (No validity restriction): Mandatory for orders with the execution restriction ?FOK? or ?IOC?.  # noqa: E501

        :param validity_res: The validity_res of this OrderModify.  # noqa: E501
        :type: str
        """
        allowed_values = ["GFS", "GTD", "NON"]  # noqa: E501
        if validity_res not in allowed_values:
            raise ValueError(
                "Invalid value for `validity_res` ({0}), must be one of {1}"  # noqa: E501
                .format(validity_res, allowed_values)
            )

        self._validity_res = validity_res

    @property
    def validity_date(self):
        """Gets the validity_date of this OrderModify.  # noqa: E501

        Set this field, if you want to update the validity date of the order. Only mandatory in case of validityRes equals ?GTD?. It is used to define the date until which the order is valid. The remaining part of the order will be removed from the order book after this point in time.  # noqa: E501

        :return: The validity_date of this OrderModify.  # noqa: E501
        :rtype: datetime
        """
        return self._validity_date

    @validity_date.setter
    def validity_date(self, validity_date):
        """Sets the validity_date of this OrderModify.

        Set this field, if you want to update the validity date of the order. Only mandatory in case of validityRes equals ?GTD?. It is used to define the date until which the order is valid. The remaining part of the order will be removed from the order book after this point in time.  # noqa: E501

        :param validity_date: The validity_date of this OrderModify.  # noqa: E501
        :type: datetime
        """

        self._validity_date = validity_date

    @property
    def type(self):
        """Gets the type of this OrderModify.  # noqa: E501

        Set this field, if you want to update the order's type. * O: Regular limit order. * B: User defined block order. * I: Iceberg order. * L: Balance order. * C: Indicative order. * S: Stop limit order. * E: On exchange prearranged trade * N: Private and confidential trade * H: Lifting order for products with Hit & Lift matcher * Q: Quote order * W: Indicative quote order  # noqa: E501

        :return: The type of this OrderModify.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this OrderModify.

        Set this field, if you want to update the order's type. * O: Regular limit order. * B: User defined block order. * I: Iceberg order. * L: Balance order. * C: Indicative order. * S: Stop limit order. * E: On exchange prearranged trade * N: Private and confidential trade * H: Lifting order for products with Hit & Lift matcher * Q: Quote order * W: Indicative quote order  # noqa: E501

        :param type: The type of this OrderModify.  # noqa: E501
        :type: str
        """
        allowed_values = ["B", "O", "I", "L", "S", "H", "C", "N", "E"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def txt(self):
        """Gets the txt of this OrderModify.  # noqa: E501

        Set this field if you want to update the order's 'custom text'  # noqa: E501

        :return: The txt of this OrderModify.  # noqa: E501
        :rtype: str
        """
        return self._txt

    @txt.setter
    def txt(self, txt):
        """Sets the txt of this OrderModify.

        Set this field if you want to update the order's 'custom text'  # noqa: E501

        :param txt: The txt of this OrderModify.  # noqa: E501
        :type: str
        """

        self._txt = txt

    @property
    def ordr_exe_restriction(self):
        """Gets the ordr_exe_restriction of this OrderModify.  # noqa: E501

        Set this field if you want to update the order's execution restriction * NON: No restriction. This is the default. * FOK: (Fill or Kill) - The order is immediately fully executed or deleted. * IOC: (Immediate and cancel): The order is executed immediately to its maximum extend. In case of a partial execution, the remaining volume is removed from the order book. * AON: (All or None): The order must be filled completely or not at all. The order stays in the order book until it is executed or removed by the system or user. AON is only allowed for User Defined Contracts (UDC). * AU (Auction): The order was entered in auction phase (no restriction is applied)  # noqa: E501

        :return: The ordr_exe_restriction of this OrderModify.  # noqa: E501
        :rtype: str
        """
        return self._ordr_exe_restriction

    @ordr_exe_restriction.setter
    def ordr_exe_restriction(self, ordr_exe_restriction):
        """Sets the ordr_exe_restriction of this OrderModify.

        Set this field if you want to update the order's execution restriction * NON: No restriction. This is the default. * FOK: (Fill or Kill) - The order is immediately fully executed or deleted. * IOC: (Immediate and cancel): The order is executed immediately to its maximum extend. In case of a partial execution, the remaining volume is removed from the order book. * AON: (All or None): The order must be filled completely or not at all. The order stays in the order book until it is executed or removed by the system or user. AON is only allowed for User Defined Contracts (UDC). * AU (Auction): The order was entered in auction phase (no restriction is applied)  # noqa: E501

        :param ordr_exe_restriction: The ordr_exe_restriction of this OrderModify.  # noqa: E501
        :type: str
        """
        allowed_values = ["FOK", "IOC", "NON", "AON", "AU"]  # noqa: E501
        if ordr_exe_restriction not in allowed_values:
            raise ValueError(
                "Invalid value for `ordr_exe_restriction` ({0}), must be one of {1}"  # noqa: E501
                .format(ordr_exe_restriction, allowed_values)
            )

        self._ordr_exe_restriction = ordr_exe_restriction

    @property
    def quantity(self):
        """Gets the quantity of this OrderModify.  # noqa: E501

        Set this field if you want to update the order's quantity.  # noqa: E501

        :return: The quantity of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this OrderModify.

        Set this field if you want to update the order's quantity.  # noqa: E501

        :param quantity: The quantity of this OrderModify.  # noqa: E501
        :type: float
        """

        self._quantity = quantity

    @property
    def display_qty(self):
        """Gets the display_qty of this OrderModify.  # noqa: E501

        Set this field if you want to update the display quantity of an Iceberg Order. This field is required only in the case of type=?I?.  # noqa: E501

        :return: The display_qty of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._display_qty

    @display_qty.setter
    def display_qty(self, display_qty):
        """Sets the display_qty of this OrderModify.

        Set this field if you want to update the display quantity of an Iceberg Order. This field is required only in the case of type=?I?.  # noqa: E501

        :param display_qty: The display_qty of this OrderModify.  # noqa: E501
        :type: float
        """

        self._display_qty = display_qty

    @property
    def price(self):
        """Gets the price of this OrderModify.  # noqa: E501

        Set this field if you want to update the order's description.  # noqa: E501

        :return: The price of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this OrderModify.

        Set this field if you want to update the order's description.  # noqa: E501

        :param price: The price of this OrderModify.  # noqa: E501
        :type: float
        """

        self._price = price

    @property
    def cl_ordr_id(self):
        """Gets the cl_ordr_id of this OrderModify.  # noqa: E501

        Set this field if you want to update the order's client order id.  # noqa: E501

        :return: The cl_ordr_id of this OrderModify.  # noqa: E501
        :rtype: str
        """
        return self._cl_ordr_id

    @cl_ordr_id.setter
    def cl_ordr_id(self, cl_ordr_id):
        """Sets the cl_ordr_id of this OrderModify.

        Set this field if you want to update the order's client order id.  # noqa: E501

        :param cl_ordr_id: The cl_ordr_id of this OrderModify.  # noqa: E501
        :type: str
        """

        self._cl_ordr_id = cl_ordr_id

    @property
    def ppd(self):
        """Gets the ppd of this OrderModify.  # noqa: E501

        Set this field if you want to update the Peak price delta for Iceberg orders. * The ppd of buy orders must be smaller or equal than zero. * The ppd of sell orders must be greater or equal than zero. If it is omitted the system will assume a value of ?0,00?.  # noqa: E501

        :return: The ppd of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._ppd

    @ppd.setter
    def ppd(self, ppd):
        """Sets the ppd of this OrderModify.

        Set this field if you want to update the Peak price delta for Iceberg orders. * The ppd of buy orders must be smaller or equal than zero. * The ppd of sell orders must be greater or equal than zero. If it is omitted the system will assume a value of ?0,00?.  # noqa: E501

        :param ppd: The ppd of this OrderModify.  # noqa: E501
        :type: float
        """

        self._ppd = ppd

    @property
    def expected_net_pos(self):
        """Gets the expected_net_pos of this OrderModify.  # noqa: E501

        The expected net_pos (sum of all trades). Do not use this field when modifying a block product.  # noqa: E501

        :return: The expected_net_pos of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._expected_net_pos

    @expected_net_pos.setter
    def expected_net_pos(self, expected_net_pos):
        """Sets the expected_net_pos of this OrderModify.

        The expected net_pos (sum of all trades). Do not use this field when modifying a block product.  # noqa: E501

        :param expected_net_pos: The expected_net_pos of this OrderModify.  # noqa: E501
        :type: float
        """

        self._expected_net_pos = expected_net_pos

    @property
    def expected_max_net_pos(self):
        """Gets the expected_max_net_pos of this OrderModify.  # noqa: E501

        The expected net_pos (sum of all trades) plus the quantity of all standing BUY-Orders. Do not use this field when modifying a block product.  # noqa: E501

        :return: The expected_max_net_pos of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._expected_max_net_pos

    @expected_max_net_pos.setter
    def expected_max_net_pos(self, expected_max_net_pos):
        """Sets the expected_max_net_pos of this OrderModify.

        The expected net_pos (sum of all trades) plus the quantity of all standing BUY-Orders. Do not use this field when modifying a block product.  # noqa: E501

        :param expected_max_net_pos: The expected_max_net_pos of this OrderModify.  # noqa: E501
        :type: float
        """

        self._expected_max_net_pos = expected_max_net_pos

    @property
    def expected_min_net_pos(self):
        """Gets the expected_min_net_pos of this OrderModify.  # noqa: E501

        The expected net_pos (sum of all trades) minus the quantity of all standing SELL-Orders. Do not use this field when modifying a block product.  # noqa: E501

        :return: The expected_min_net_pos of this OrderModify.  # noqa: E501
        :rtype: float
        """
        return self._expected_min_net_pos

    @expected_min_net_pos.setter
    def expected_min_net_pos(self, expected_min_net_pos):
        """Sets the expected_min_net_pos of this OrderModify.

        The expected net_pos (sum of all trades) minus the quantity of all standing SELL-Orders. Do not use this field when modifying a block product.  # noqa: E501

        :param expected_min_net_pos: The expected_min_net_pos of this OrderModify.  # noqa: E501
        :type: float
        """

        self._expected_min_net_pos = expected_min_net_pos

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrderModify, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderModify):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
