# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The Powerbot system provides B2B services for trading at intraday power markets. By using the Powerbot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that he/she is familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/extras/download-center/documentation) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION Powerbot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## DOCUMENTATION  In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The Powerbot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) The API provides automated generation of API clients (programming libraries) for a wide range of programming languages. To generate them, please open Swagger Editor from the exchange menu, click on \"Generate Client\" and choose a programming language.  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    OpenAPI spec version: 2.1.27
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Message(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'message_id': 'str',
        'api_timestamp': 'datetime',
        'category': 'str',
        'message_class': 'str',
        'content_type': 'str',
        'correlation_id': 'str',
        'direction': 'str',
        'group_id': 'str',
        'group_sequence': 'str',
        'content': 'object'
    }

    attribute_map = {
        'message_id': 'message_id',
        'api_timestamp': 'api_timestamp',
        'category': 'category',
        'message_class': 'message_class',
        'content_type': 'content_type',
        'correlation_id': 'correlation_id',
        'direction': 'direction',
        'group_id': 'group_id',
        'group_sequence': 'group_sequence',
        'content': 'content'
    }

    def __init__(self, message_id=None, api_timestamp=None, category=None, message_class=None, content_type=None, correlation_id=None, direction=None, group_id=None, group_sequence=None, content=None):  # noqa: E501
        """Message - a model defined in Swagger"""  # noqa: E501
        self._message_id = None
        self._api_timestamp = None
        self._category = None
        self._message_class = None
        self._content_type = None
        self._correlation_id = None
        self._direction = None
        self._group_id = None
        self._group_sequence = None
        self._content = None
        self.discriminator = None
        if message_id is not None:
            self.message_id = message_id
        if api_timestamp is not None:
            self.api_timestamp = api_timestamp
        if category is not None:
            self.category = category
        if message_class is not None:
            self.message_class = message_class
        if content_type is not None:
            self.content_type = content_type
        if correlation_id is not None:
            self.correlation_id = correlation_id
        if direction is not None:
            self.direction = direction
        if group_id is not None:
            self.group_id = group_id
        if group_sequence is not None:
            self.group_sequence = group_sequence
        if content is not None:
            self.content = content

    @property
    def message_id(self):
        """Gets the message_id of this Message.  # noqa: E501


        :return: The message_id of this Message.  # noqa: E501
        :rtype: str
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id):
        """Sets the message_id of this Message.


        :param message_id: The message_id of this Message.  # noqa: E501
        :type: str
        """

        self._message_id = message_id

    @property
    def api_timestamp(self):
        """Gets the api_timestamp of this Message.  # noqa: E501


        :return: The api_timestamp of this Message.  # noqa: E501
        :rtype: datetime
        """
        return self._api_timestamp

    @api_timestamp.setter
    def api_timestamp(self, api_timestamp):
        """Sets the api_timestamp of this Message.


        :param api_timestamp: The api_timestamp of this Message.  # noqa: E501
        :type: datetime
        """

        self._api_timestamp = api_timestamp

    @property
    def category(self):
        """Gets the category of this Message.  # noqa: E501


        :return: The category of this Message.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this Message.


        :param category: The category of this Message.  # noqa: E501
        :type: str
        """
        allowed_values = ["INQUIRY_REQUEST", "MANAGEMENT_REQUEST", "RESPONSE", "BROADCAST"]  # noqa: E501
        if category not in allowed_values:
            raise ValueError(
                "Invalid value for `category` ({0}), must be one of {1}"  # noqa: E501
                .format(category, allowed_values)
            )

        self._category = category

    @property
    def message_class(self):
        """Gets the message_class of this Message.  # noqa: E501


        :return: The message_class of this Message.  # noqa: E501
        :rtype: str
        """
        return self._message_class

    @message_class.setter
    def message_class(self, message_class):
        """Sets the message_class of this Message.


        :param message_class: The message_class of this Message.  # noqa: E501
        :type: str
        """

        self._message_class = message_class

    @property
    def content_type(self):
        """Gets the content_type of this Message.  # noqa: E501


        :return: The content_type of this Message.  # noqa: E501
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """Sets the content_type of this Message.


        :param content_type: The content_type of this Message.  # noqa: E501
        :type: str
        """

        self._content_type = content_type

    @property
    def correlation_id(self):
        """Gets the correlation_id of this Message.  # noqa: E501


        :return: The correlation_id of this Message.  # noqa: E501
        :rtype: str
        """
        return self._correlation_id

    @correlation_id.setter
    def correlation_id(self, correlation_id):
        """Sets the correlation_id of this Message.


        :param correlation_id: The correlation_id of this Message.  # noqa: E501
        :type: str
        """

        self._correlation_id = correlation_id

    @property
    def direction(self):
        """Gets the direction of this Message.  # noqa: E501


        :return: The direction of this Message.  # noqa: E501
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """Sets the direction of this Message.


        :param direction: The direction of this Message.  # noqa: E501
        :type: str
        """
        allowed_values = ["IN", "OUT"]  # noqa: E501
        if direction not in allowed_values:
            raise ValueError(
                "Invalid value for `direction` ({0}), must be one of {1}"  # noqa: E501
                .format(direction, allowed_values)
            )

        self._direction = direction

    @property
    def group_id(self):
        """Gets the group_id of this Message.  # noqa: E501


        :return: The group_id of this Message.  # noqa: E501
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """Sets the group_id of this Message.


        :param group_id: The group_id of this Message.  # noqa: E501
        :type: str
        """

        self._group_id = group_id

    @property
    def group_sequence(self):
        """Gets the group_sequence of this Message.  # noqa: E501


        :return: The group_sequence of this Message.  # noqa: E501
        :rtype: str
        """
        return self._group_sequence

    @group_sequence.setter
    def group_sequence(self, group_sequence):
        """Sets the group_sequence of this Message.


        :param group_sequence: The group_sequence of this Message.  # noqa: E501
        :type: str
        """

        self._group_sequence = group_sequence

    @property
    def content(self):
        """Gets the content of this Message.  # noqa: E501


        :return: The content of this Message.  # noqa: E501
        :rtype: object
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this Message.


        :param content: The content of this Message.  # noqa: E501
        :type: object
        """

        self._content = content

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Message, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Message):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
