# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The Powerbot system provides B2B services for trading at intraday power markets. By using the Powerbot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that he/she is familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/extras/download-center/documentation) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION Powerbot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## DOCUMENTATION  In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The Powerbot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) The API provides automated generation of API clients (programming libraries) for a wide range of programming languages. To generate them, please open Swagger Editor from the exchange menu, click on \"Generate Client\" and choose a programming language.  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    OpenAPI spec version: 2.1.27
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ContractItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'exchange': 'str',
        'product': 'str',
        'contract_id': 'str',
        'type': 'str',
        'revision_no': 'int',
        'state': 'str',
        'name': 'str',
        'delivery_start': 'datetime',
        'delivery_end': 'datetime',
        'contract_details': 'object',
        'delivery_areas': 'list[str]'
    }

    attribute_map = {
        'exchange': 'exchange',
        'product': 'product',
        'contract_id': 'contract_id',
        'type': 'type',
        'revision_no': 'revision_no',
        'state': 'state',
        'name': 'name',
        'delivery_start': 'delivery_start',
        'delivery_end': 'delivery_end',
        'contract_details': 'contract_details',
        'delivery_areas': 'delivery_areas'
    }

    def __init__(self, exchange=None, product=None, contract_id=None, type=None, revision_no=None, state=None, name=None, delivery_start=None, delivery_end=None, contract_details=None, delivery_areas=None):  # noqa: E501
        """ContractItem - a model defined in Swagger"""  # noqa: E501
        self._exchange = None
        self._product = None
        self._contract_id = None
        self._type = None
        self._revision_no = None
        self._state = None
        self._name = None
        self._delivery_start = None
        self._delivery_end = None
        self._contract_details = None
        self._delivery_areas = None
        self.discriminator = None
        if exchange is not None:
            self.exchange = exchange
        if product is not None:
            self.product = product
        if contract_id is not None:
            self.contract_id = contract_id
        if type is not None:
            self.type = type
        if revision_no is not None:
            self.revision_no = revision_no
        if state is not None:
            self.state = state
        if name is not None:
            self.name = name
        if delivery_start is not None:
            self.delivery_start = delivery_start
        if delivery_end is not None:
            self.delivery_end = delivery_end
        if contract_details is not None:
            self.contract_details = contract_details
        if delivery_areas is not None:
            self.delivery_areas = delivery_areas

    @property
    def exchange(self):
        """Gets the exchange of this ContractItem.  # noqa: E501


        :return: The exchange of this ContractItem.  # noqa: E501
        :rtype: str
        """
        return self._exchange

    @exchange.setter
    def exchange(self, exchange):
        """Sets the exchange of this ContractItem.


        :param exchange: The exchange of this ContractItem.  # noqa: E501
        :type: str
        """

        self._exchange = exchange

    @property
    def product(self):
        """Gets the product of this ContractItem.  # noqa: E501


        :return: The product of this ContractItem.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this ContractItem.


        :param product: The product of this ContractItem.  # noqa: E501
        :type: str
        """

        self._product = product

    @property
    def contract_id(self):
        """Gets the contract_id of this ContractItem.  # noqa: E501

        The contract's unique id  # noqa: E501

        :return: The contract_id of this ContractItem.  # noqa: E501
        :rtype: str
        """
        return self._contract_id

    @contract_id.setter
    def contract_id(self, contract_id):
        """Sets the contract_id of this ContractItem.

        The contract's unique id  # noqa: E501

        :param contract_id: The contract_id of this ContractItem.  # noqa: E501
        :type: str
        """

        self._contract_id = contract_id

    @property
    def type(self):
        """Gets the type of this ContractItem.  # noqa: E501


        :return: The type of this ContractItem.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ContractItem.


        :param type: The type of this ContractItem.  # noqa: E501
        :type: str
        """
        allowed_values = ["PDC", "UDC", "ALL"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def revision_no(self):
        """Gets the revision_no of this ContractItem.  # noqa: E501


        :return: The revision_no of this ContractItem.  # noqa: E501
        :rtype: int
        """
        return self._revision_no

    @revision_no.setter
    def revision_no(self, revision_no):
        """Sets the revision_no of this ContractItem.


        :param revision_no: The revision_no of this ContractItem.  # noqa: E501
        :type: int
        """

        self._revision_no = revision_no

    @property
    def state(self):
        """Gets the state of this ContractItem.  # noqa: E501


        :return: The state of this ContractItem.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this ContractItem.


        :param state: The state of this ContractItem.  # noqa: E501
        :type: str
        """

        self._state = state

    @property
    def name(self):
        """Gets the name of this ContractItem.  # noqa: E501

        The name of the contract  # noqa: E501

        :return: The name of this ContractItem.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ContractItem.

        The name of the contract  # noqa: E501

        :param name: The name of this ContractItem.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def delivery_start(self):
        """Gets the delivery_start of this ContractItem.  # noqa: E501

        The delivery start time (UTC) of the contract  # noqa: E501

        :return: The delivery_start of this ContractItem.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_start

    @delivery_start.setter
    def delivery_start(self, delivery_start):
        """Sets the delivery_start of this ContractItem.

        The delivery start time (UTC) of the contract  # noqa: E501

        :param delivery_start: The delivery_start of this ContractItem.  # noqa: E501
        :type: datetime
        """

        self._delivery_start = delivery_start

    @property
    def delivery_end(self):
        """Gets the delivery_end of this ContractItem.  # noqa: E501

        The delivery end time (UTC) of the contract  # noqa: E501

        :return: The delivery_end of this ContractItem.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_end

    @delivery_end.setter
    def delivery_end(self, delivery_end):
        """Sets the delivery_end of this ContractItem.

        The delivery end time (UTC) of the contract  # noqa: E501

        :param delivery_end: The delivery_end of this ContractItem.  # noqa: E501
        :type: datetime
        """

        self._delivery_end = delivery_end

    @property
    def contract_details(self):
        """Gets the contract_details of this ContractItem.  # noqa: E501


        :return: The contract_details of this ContractItem.  # noqa: E501
        :rtype: object
        """
        return self._contract_details

    @contract_details.setter
    def contract_details(self, contract_details):
        """Sets the contract_details of this ContractItem.


        :param contract_details: The contract_details of this ContractItem.  # noqa: E501
        :type: object
        """

        self._contract_details = contract_details

    @property
    def delivery_areas(self):
        """Gets the delivery_areas of this ContractItem.  # noqa: E501


        :return: The delivery_areas of this ContractItem.  # noqa: E501
        :rtype: list[str]
        """
        return self._delivery_areas

    @delivery_areas.setter
    def delivery_areas(self, delivery_areas):
        """Sets the delivery_areas of this ContractItem.


        :param delivery_areas: The delivery_areas of this ContractItem.  # noqa: E501
        :type: list[str]
        """

        self._delivery_areas = delivery_areas

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ContractItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ContractItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
