# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The Powerbot system provides B2B services for trading at intraday power markets. By using the Powerbot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that he/she is familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/extras/download-center/documentation) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION Powerbot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## DOCUMENTATION  In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The Powerbot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) The API provides automated generation of API clients (programming libraries) for a wide range of programming languages. To generate them, please open Swagger Editor from the exchange menu, click on \"Generate Client\" and choose a programming language.  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    OpenAPI spec version: 2.1.27
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Capacity(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'api_timestamp': 'datetime',
        'timestamp': 'datetime',
        'from_delivery_area': 'str',
        'to_delivery_area': 'str',
        'revision': 'int',
        'delivery_start': 'datetime',
        'delivery_end': 'datetime',
        '_in': 'float',
        'out': 'float'
    }

    attribute_map = {
        'api_timestamp': 'api_timestamp',
        'timestamp': 'timestamp',
        'from_delivery_area': 'from_delivery_area',
        'to_delivery_area': 'to_delivery_area',
        'revision': 'revision',
        'delivery_start': 'delivery_start',
        'delivery_end': 'delivery_end',
        '_in': 'in',
        'out': 'out'
    }

    def __init__(self, api_timestamp=None, timestamp=None, from_delivery_area=None, to_delivery_area=None, revision=None, delivery_start=None, delivery_end=None, _in=None, out=None):  # noqa: E501
        """Capacity - a model defined in Swagger"""  # noqa: E501
        self._api_timestamp = None
        self._timestamp = None
        self._from_delivery_area = None
        self._to_delivery_area = None
        self._revision = None
        self._delivery_start = None
        self._delivery_end = None
        self.__in = None
        self._out = None
        self.discriminator = None
        if api_timestamp is not None:
            self.api_timestamp = api_timestamp
        if timestamp is not None:
            self.timestamp = timestamp
        if from_delivery_area is not None:
            self.from_delivery_area = from_delivery_area
        if to_delivery_area is not None:
            self.to_delivery_area = to_delivery_area
        if revision is not None:
            self.revision = revision
        if delivery_start is not None:
            self.delivery_start = delivery_start
        if delivery_end is not None:
            self.delivery_end = delivery_end
        if _in is not None:
            self._in = _in
        if out is not None:
            self.out = out

    @property
    def api_timestamp(self):
        """Gets the api_timestamp of this Capacity.  # noqa: E501

        The timestamp of the entry being received  # noqa: E501

        :return: The api_timestamp of this Capacity.  # noqa: E501
        :rtype: datetime
        """
        return self._api_timestamp

    @api_timestamp.setter
    def api_timestamp(self, api_timestamp):
        """Sets the api_timestamp of this Capacity.

        The timestamp of the entry being received  # noqa: E501

        :param api_timestamp: The api_timestamp of this Capacity.  # noqa: E501
        :type: datetime
        """

        self._api_timestamp = api_timestamp

    @property
    def timestamp(self):
        """Gets the timestamp of this Capacity.  # noqa: E501

        The timestamp when the data was received from the capacity system  # noqa: E501

        :return: The timestamp of this Capacity.  # noqa: E501
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this Capacity.

        The timestamp when the data was received from the capacity system  # noqa: E501

        :param timestamp: The timestamp of this Capacity.  # noqa: E501
        :type: datetime
        """

        self._timestamp = timestamp

    @property
    def from_delivery_area(self):
        """Gets the from_delivery_area of this Capacity.  # noqa: E501

        EIC code of the outgoing area  # noqa: E501

        :return: The from_delivery_area of this Capacity.  # noqa: E501
        :rtype: str
        """
        return self._from_delivery_area

    @from_delivery_area.setter
    def from_delivery_area(self, from_delivery_area):
        """Sets the from_delivery_area of this Capacity.

        EIC code of the outgoing area  # noqa: E501

        :param from_delivery_area: The from_delivery_area of this Capacity.  # noqa: E501
        :type: str
        """

        self._from_delivery_area = from_delivery_area

    @property
    def to_delivery_area(self):
        """Gets the to_delivery_area of this Capacity.  # noqa: E501

        EIC code of the target area  # noqa: E501

        :return: The to_delivery_area of this Capacity.  # noqa: E501
        :rtype: str
        """
        return self._to_delivery_area

    @to_delivery_area.setter
    def to_delivery_area(self, to_delivery_area):
        """Sets the to_delivery_area of this Capacity.

        EIC code of the target area  # noqa: E501

        :param to_delivery_area: The to_delivery_area of this Capacity.  # noqa: E501
        :type: str
        """

        self._to_delivery_area = to_delivery_area

    @property
    def revision(self):
        """Gets the revision of this Capacity.  # noqa: E501

        Revision number of the entry  # noqa: E501

        :return: The revision of this Capacity.  # noqa: E501
        :rtype: int
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this Capacity.

        Revision number of the entry  # noqa: E501

        :param revision: The revision of this Capacity.  # noqa: E501
        :type: int
        """

        self._revision = revision

    @property
    def delivery_start(self):
        """Gets the delivery_start of this Capacity.  # noqa: E501


        :return: The delivery_start of this Capacity.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_start

    @delivery_start.setter
    def delivery_start(self, delivery_start):
        """Sets the delivery_start of this Capacity.


        :param delivery_start: The delivery_start of this Capacity.  # noqa: E501
        :type: datetime
        """

        self._delivery_start = delivery_start

    @property
    def delivery_end(self):
        """Gets the delivery_end of this Capacity.  # noqa: E501


        :return: The delivery_end of this Capacity.  # noqa: E501
        :rtype: datetime
        """
        return self._delivery_end

    @delivery_end.setter
    def delivery_end(self, delivery_end):
        """Sets the delivery_end of this Capacity.


        :param delivery_end: The delivery_end of this Capacity.  # noqa: E501
        :type: datetime
        """

        self._delivery_end = delivery_end

    @property
    def _in(self):
        """Gets the _in of this Capacity.  # noqa: E501

        The ATC value ?IN? for target Area.  # noqa: E501

        :return: The _in of this Capacity.  # noqa: E501
        :rtype: float
        """
        return self.__in

    @_in.setter
    def _in(self, _in):
        """Sets the _in of this Capacity.

        The ATC value ?IN? for target Area.  # noqa: E501

        :param _in: The _in of this Capacity.  # noqa: E501
        :type: float
        """

        self.__in = _in

    @property
    def out(self):
        """Gets the out of this Capacity.  # noqa: E501

        The ATC value ?OUT? for target Area.  # noqa: E501

        :return: The out of this Capacity.  # noqa: E501
        :rtype: float
        """
        return self._out

    @out.setter
    def out(self, out):
        """Sets the out of this Capacity.

        The ATC value ?OUT? for target Area.  # noqa: E501

        :param out: The out of this Capacity.  # noqa: E501
        :type: float
        """

        self._out = out

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Capacity, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Capacity):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
