# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The Powerbot system provides B2B services for trading at intraday power markets. By using the Powerbot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that he/she is familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/extras/download-center/documentation) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION Powerbot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## DOCUMENTATION  In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The Powerbot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) The API provides automated generation of API clients (programming libraries) for a wide range of programming languages. To generate them, please open Swagger Editor from the exchange menu, click on \"Generate Client\" and choose a programming language.  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    OpenAPI spec version: 2.1.27
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AlgoInstance(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'instance_id': 'str',
        'exchange': 'str',
        'portfolio_ids': 'list[str]',
        'parameters': 'object',
        'status': 'str',
        'started_at': 'datetime',
        'stopped_at': 'datetime',
        'stop_status_text': 'str',
        'last_heartbeat_at': 'datetime',
        'heartbeat': 'AlgoHeartbeat'
    }

    attribute_map = {
        'instance_id': 'instance_id',
        'exchange': 'exchange',
        'portfolio_ids': 'portfolio_ids',
        'parameters': 'parameters',
        'status': 'status',
        'started_at': 'started_at',
        'stopped_at': 'stopped_at',
        'stop_status_text': 'stop_status_text',
        'last_heartbeat_at': 'last_heartbeat_at',
        'heartbeat': 'heartbeat'
    }

    def __init__(self, instance_id=None, exchange=None, portfolio_ids=None, parameters=None, status=None, started_at=None, stopped_at=None, stop_status_text=None, last_heartbeat_at=None, heartbeat=None):  # noqa: E501
        """AlgoInstance - a model defined in Swagger"""  # noqa: E501
        self._instance_id = None
        self._exchange = None
        self._portfolio_ids = None
        self._parameters = None
        self._status = None
        self._started_at = None
        self._stopped_at = None
        self._stop_status_text = None
        self._last_heartbeat_at = None
        self._heartbeat = None
        self.discriminator = None
        if instance_id is not None:
            self.instance_id = instance_id
        if exchange is not None:
            self.exchange = exchange
        if portfolio_ids is not None:
            self.portfolio_ids = portfolio_ids
        if parameters is not None:
            self.parameters = parameters
        if status is not None:
            self.status = status
        if started_at is not None:
            self.started_at = started_at
        if stopped_at is not None:
            self.stopped_at = stopped_at
        if stop_status_text is not None:
            self.stop_status_text = stop_status_text
        if last_heartbeat_at is not None:
            self.last_heartbeat_at = last_heartbeat_at
        if heartbeat is not None:
            self.heartbeat = heartbeat

    @property
    def instance_id(self):
        """Gets the instance_id of this AlgoInstance.  # noqa: E501

        Unique id of the instance  # noqa: E501

        :return: The instance_id of this AlgoInstance.  # noqa: E501
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """Sets the instance_id of this AlgoInstance.

        Unique id of the instance  # noqa: E501

        :param instance_id: The instance_id of this AlgoInstance.  # noqa: E501
        :type: str
        """

        self._instance_id = instance_id

    @property
    def exchange(self):
        """Gets the exchange of this AlgoInstance.  # noqa: E501

        Specifies the exchange from which the instance has been created.  # noqa: E501

        :return: The exchange of this AlgoInstance.  # noqa: E501
        :rtype: str
        """
        return self._exchange

    @exchange.setter
    def exchange(self, exchange):
        """Sets the exchange of this AlgoInstance.

        Specifies the exchange from which the instance has been created.  # noqa: E501

        :param exchange: The exchange of this AlgoInstance.  # noqa: E501
        :type: str
        """

        self._exchange = exchange

    @property
    def portfolio_ids(self):
        """Gets the portfolio_ids of this AlgoInstance.  # noqa: E501

        The configured portfolios for this instance.  # noqa: E501

        :return: The portfolio_ids of this AlgoInstance.  # noqa: E501
        :rtype: list[str]
        """
        return self._portfolio_ids

    @portfolio_ids.setter
    def portfolio_ids(self, portfolio_ids):
        """Sets the portfolio_ids of this AlgoInstance.

        The configured portfolios for this instance.  # noqa: E501

        :param portfolio_ids: The portfolio_ids of this AlgoInstance.  # noqa: E501
        :type: list[str]
        """

        self._portfolio_ids = portfolio_ids

    @property
    def parameters(self):
        """Gets the parameters of this AlgoInstance.  # noqa: E501

        A freely defined JSON object with key/value pairs.  # noqa: E501

        :return: The parameters of this AlgoInstance.  # noqa: E501
        :rtype: object
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """Sets the parameters of this AlgoInstance.

        A freely defined JSON object with key/value pairs.  # noqa: E501

        :param parameters: The parameters of this AlgoInstance.  # noqa: E501
        :type: object
        """

        self._parameters = parameters

    @property
    def status(self):
        """Gets the status of this AlgoInstance.  # noqa: E501

        The current state of the algorithm-instance.  # noqa: E501

        :return: The status of this AlgoInstance.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this AlgoInstance.

        The current state of the algorithm-instance.  # noqa: E501

        :param status: The status of this AlgoInstance.  # noqa: E501
        :type: str
        """
        allowed_values = ["IDLE", "RUNNING", "FAILED"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def started_at(self):
        """Gets the started_at of this AlgoInstance.  # noqa: E501

        A timestamp containing information on when the alogrithm-instance was started.  # noqa: E501

        :return: The started_at of this AlgoInstance.  # noqa: E501
        :rtype: datetime
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this AlgoInstance.

        A timestamp containing information on when the alogrithm-instance was started.  # noqa: E501

        :param started_at: The started_at of this AlgoInstance.  # noqa: E501
        :type: datetime
        """

        self._started_at = started_at

    @property
    def stopped_at(self):
        """Gets the stopped_at of this AlgoInstance.  # noqa: E501

        A timestamp containing information on when the alogrithm-instance was stopped.  # noqa: E501

        :return: The stopped_at of this AlgoInstance.  # noqa: E501
        :rtype: datetime
        """
        return self._stopped_at

    @stopped_at.setter
    def stopped_at(self, stopped_at):
        """Sets the stopped_at of this AlgoInstance.

        A timestamp containing information on when the alogrithm-instance was stopped.  # noqa: E501

        :param stopped_at: The stopped_at of this AlgoInstance.  # noqa: E501
        :type: datetime
        """

        self._stopped_at = stopped_at

    @property
    def stop_status_text(self):
        """Gets the stop_status_text of this AlgoInstance.  # noqa: E501

        A message containing detail information on why the algorithm-instance was stopped.  # noqa: E501

        :return: The stop_status_text of this AlgoInstance.  # noqa: E501
        :rtype: str
        """
        return self._stop_status_text

    @stop_status_text.setter
    def stop_status_text(self, stop_status_text):
        """Sets the stop_status_text of this AlgoInstance.

        A message containing detail information on why the algorithm-instance was stopped.  # noqa: E501

        :param stop_status_text: The stop_status_text of this AlgoInstance.  # noqa: E501
        :type: str
        """

        self._stop_status_text = stop_status_text

    @property
    def last_heartbeat_at(self):
        """Gets the last_heartbeat_at of this AlgoInstance.  # noqa: E501

        A timestamp containing information on when the last heartbeat was received.  # noqa: E501

        :return: The last_heartbeat_at of this AlgoInstance.  # noqa: E501
        :rtype: datetime
        """
        return self._last_heartbeat_at

    @last_heartbeat_at.setter
    def last_heartbeat_at(self, last_heartbeat_at):
        """Sets the last_heartbeat_at of this AlgoInstance.

        A timestamp containing information on when the last heartbeat was received.  # noqa: E501

        :param last_heartbeat_at: The last_heartbeat_at of this AlgoInstance.  # noqa: E501
        :type: datetime
        """

        self._last_heartbeat_at = last_heartbeat_at

    @property
    def heartbeat(self):
        """Gets the heartbeat of this AlgoInstance.  # noqa: E501


        :return: The heartbeat of this AlgoInstance.  # noqa: E501
        :rtype: AlgoHeartbeat
        """
        return self._heartbeat

    @heartbeat.setter
    def heartbeat(self, heartbeat):
        """Sets the heartbeat of this AlgoInstance.


        :param heartbeat: The heartbeat of this AlgoInstance.  # noqa: E501
        :type: AlgoHeartbeat
        """

        self._heartbeat = heartbeat

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AlgoInstance, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AlgoInstance):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
