# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The Powerbot system provides B2B services for trading at intraday power markets. By using the Powerbot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that he/she is familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/extras/download-center/documentation) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION Powerbot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## DOCUMENTATION  In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The Powerbot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) The API provides automated generation of API clients (programming libraries) for a wide range of programming languages. To generate them, please open Swagger Editor from the exchange menu, click on \"Generate Client\" and choose a programming language.  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    OpenAPI spec version: 2.1.27
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_client.api_client import ApiClient


class ReportApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_report_csv_for_period(self, delivery_area, delivery_day_from, delivery_day_to, **kwargs):  # noqa: E501
        """Creates a trading report as CSV file  # noqa: E501

        Creates a detailed trading report in CSV format for a delivery area and a given delivery period. However, as the CSV format is two-dimensional, this report delivers less data compared to the regular report method.  As the generation of the report requires a lot of calculations, please use wisely. The maximum period you can request is limited to 31 days. The request retrieves an array of portfolios and can thus deliver data for one or more portfolios at the same time. However, some data (e.g. positions) cannot be aggregated for portfolios and will thus not show up, if you request data from more than one portfolio. The report can use filters for clOrdrId and txt, which means that only trades for which the filter is valid are included in the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_csv_for_period(delivery_area, delivery_day_from, delivery_day_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str delivery_area: The EIC code of the delivery area (required)
        :param date delivery_day_from: The day the report is for (example \"2018-10-23\") (required)
        :param date delivery_day_to: The day the report is for (example \"2018-10-30\") (required)
        :param list[str] portfolio_id:
        :param str cl_ordr_id: Show only those trades related to orders with a specific 'client order id' (something like 'your reference' which you can submit) together with an order
        :param str txt: Show only those trades related to orders with a specific 'custom text'. Similar to the clOrdrId, you can submit a string inside the 'txt' attribute of an order which helps you to identify trades originating from a specific order at a later point
        :param str column_separator:
        :param str comma_separator:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_csv_for_period_with_http_info(delivery_area, delivery_day_from, delivery_day_to, **kwargs)  # noqa: E501
        else:
            (data) = self.get_report_csv_for_period_with_http_info(delivery_area, delivery_day_from, delivery_day_to, **kwargs)  # noqa: E501
            return data

    def get_report_csv_for_period_with_http_info(self, delivery_area, delivery_day_from, delivery_day_to, **kwargs):  # noqa: E501
        """Creates a trading report as CSV file  # noqa: E501

        Creates a detailed trading report in CSV format for a delivery area and a given delivery period. However, as the CSV format is two-dimensional, this report delivers less data compared to the regular report method.  As the generation of the report requires a lot of calculations, please use wisely. The maximum period you can request is limited to 31 days. The request retrieves an array of portfolios and can thus deliver data for one or more portfolios at the same time. However, some data (e.g. positions) cannot be aggregated for portfolios and will thus not show up, if you request data from more than one portfolio. The report can use filters for clOrdrId and txt, which means that only trades for which the filter is valid are included in the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_csv_for_period_with_http_info(delivery_area, delivery_day_from, delivery_day_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str delivery_area: The EIC code of the delivery area (required)
        :param date delivery_day_from: The day the report is for (example \"2018-10-23\") (required)
        :param date delivery_day_to: The day the report is for (example \"2018-10-30\") (required)
        :param list[str] portfolio_id:
        :param str cl_ordr_id: Show only those trades related to orders with a specific 'client order id' (something like 'your reference' which you can submit) together with an order
        :param str txt: Show only those trades related to orders with a specific 'custom text'. Similar to the clOrdrId, you can submit a string inside the 'txt' attribute of an order which helps you to identify trades originating from a specific order at a later point
        :param str column_separator:
        :param str comma_separator:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['delivery_area', 'delivery_day_from', 'delivery_day_to', 'portfolio_id', 'cl_ordr_id', 'txt', 'column_separator', 'comma_separator']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_csv_for_period" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'delivery_area' is set
        if ('delivery_area' not in params or
                params['delivery_area'] is None):
            raise ValueError("Missing the required parameter `delivery_area` when calling `get_report_csv_for_period`")  # noqa: E501
        # verify the required parameter 'delivery_day_from' is set
        if ('delivery_day_from' not in params or
                params['delivery_day_from'] is None):
            raise ValueError("Missing the required parameter `delivery_day_from` when calling `get_report_csv_for_period`")  # noqa: E501
        # verify the required parameter 'delivery_day_to' is set
        if ('delivery_day_to' not in params or
                params['delivery_day_to'] is None):
            raise ValueError("Missing the required parameter `delivery_day_to` when calling `get_report_csv_for_period`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_area' in params:
            path_params['delivery_area'] = params['delivery_area']  # noqa: E501

        query_params = []
        if 'portfolio_id' in params:
            query_params.append(('portfolio_id', params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if 'delivery_day_from' in params:
            query_params.append(('delivery_day_from', params['delivery_day_from']))  # noqa: E501
        if 'delivery_day_to' in params:
            query_params.append(('delivery_day_to', params['delivery_day_to']))  # noqa: E501
        if 'cl_ordr_id' in params:
            query_params.append(('clOrdrId', params['cl_ordr_id']))  # noqa: E501
        if 'txt' in params:
            query_params.append(('txt', params['txt']))  # noqa: E501
        if 'column_separator' in params:
            query_params.append(('column_separator', params['column_separator']))  # noqa: E501
        if 'comma_separator' in params:
            query_params.append(('comma_separator', params['comma_separator']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/csv'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/report/{delivery_area}/csv', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_report_for_period(self, delivery_area, delivery_day_from, delivery_day_to, **kwargs):  # noqa: E501
        """Creates a trading report  # noqa: E501

        Creates a detailed trading report for a delivery area and a given delivery period, which contains all relevant information.  As the generation of the report requires a lot of calculations, please use wisely. The maximum period you can request is limited to 31 days. The request retrieves an array of portfolios and can thus deliver data for one or more portfolios at the same time. However, some data (e.g. positions) cannot be aggregated for portfolios and will therefore not show up, if you request data from more than one portfolio. Optionally, the report can include the trades for the portfolio(s) that have a delivery period within the report period. In addition, the report can use filters for clOrdrId and txt, which means that only trades for which the filter is valid are included in the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_for_period(delivery_area, delivery_day_from, delivery_day_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str delivery_area: The EIC code of the delivery area (required)
        :param date delivery_day_from: The day the report starts (example \"2018-10-23\") (required)
        :param date delivery_day_to: The day the report ends (example \"2018-10-30\") (required)
        :param list[str] portfolio_id:
        :param int delivery_day_from_starting_hour: The starting hour of the report (0 = midnight)
        :param int delivery_day_to_ending_hour: The ending hour of the report (0 = midnight)
        :param str cl_ordr_id: Use only trades in the calculation of the report, which are related to orders with a specific 'client order id' (something like 'your reference' which you can submit) together with an order
        :param str txt: Use only trades in the calculation of the report, which are related to orders with a specific 'custom text'. Similar to the clOrdrId, you can submit a string inside the 'txt' attribute of an order which helps you to identify trades originating from a specific order at a later point
        :param bool with_trades:
        :return: Report
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_for_period_with_http_info(delivery_area, delivery_day_from, delivery_day_to, **kwargs)  # noqa: E501
        else:
            (data) = self.get_report_for_period_with_http_info(delivery_area, delivery_day_from, delivery_day_to, **kwargs)  # noqa: E501
            return data

    def get_report_for_period_with_http_info(self, delivery_area, delivery_day_from, delivery_day_to, **kwargs):  # noqa: E501
        """Creates a trading report  # noqa: E501

        Creates a detailed trading report for a delivery area and a given delivery period, which contains all relevant information.  As the generation of the report requires a lot of calculations, please use wisely. The maximum period you can request is limited to 31 days. The request retrieves an array of portfolios and can thus deliver data for one or more portfolios at the same time. However, some data (e.g. positions) cannot be aggregated for portfolios and will therefore not show up, if you request data from more than one portfolio. Optionally, the report can include the trades for the portfolio(s) that have a delivery period within the report period. In addition, the report can use filters for clOrdrId and txt, which means that only trades for which the filter is valid are included in the report.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_for_period_with_http_info(delivery_area, delivery_day_from, delivery_day_to, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str delivery_area: The EIC code of the delivery area (required)
        :param date delivery_day_from: The day the report starts (example \"2018-10-23\") (required)
        :param date delivery_day_to: The day the report ends (example \"2018-10-30\") (required)
        :param list[str] portfolio_id:
        :param int delivery_day_from_starting_hour: The starting hour of the report (0 = midnight)
        :param int delivery_day_to_ending_hour: The ending hour of the report (0 = midnight)
        :param str cl_ordr_id: Use only trades in the calculation of the report, which are related to orders with a specific 'client order id' (something like 'your reference' which you can submit) together with an order
        :param str txt: Use only trades in the calculation of the report, which are related to orders with a specific 'custom text'. Similar to the clOrdrId, you can submit a string inside the 'txt' attribute of an order which helps you to identify trades originating from a specific order at a later point
        :param bool with_trades:
        :return: Report
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['delivery_area', 'delivery_day_from', 'delivery_day_to', 'portfolio_id', 'delivery_day_from_starting_hour', 'delivery_day_to_ending_hour', 'cl_ordr_id', 'txt', 'with_trades']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_for_period" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'delivery_area' is set
        if ('delivery_area' not in params or
                params['delivery_area'] is None):
            raise ValueError("Missing the required parameter `delivery_area` when calling `get_report_for_period`")  # noqa: E501
        # verify the required parameter 'delivery_day_from' is set
        if ('delivery_day_from' not in params or
                params['delivery_day_from'] is None):
            raise ValueError("Missing the required parameter `delivery_day_from` when calling `get_report_for_period`")  # noqa: E501
        # verify the required parameter 'delivery_day_to' is set
        if ('delivery_day_to' not in params or
                params['delivery_day_to'] is None):
            raise ValueError("Missing the required parameter `delivery_day_to` when calling `get_report_for_period`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'delivery_area' in params:
            path_params['delivery_area'] = params['delivery_area']  # noqa: E501

        query_params = []
        if 'portfolio_id' in params:
            query_params.append(('portfolio_id', params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if 'delivery_day_from' in params:
            query_params.append(('delivery_day_from', params['delivery_day_from']))  # noqa: E501
        if 'delivery_day_to' in params:
            query_params.append(('delivery_day_to', params['delivery_day_to']))  # noqa: E501
        if 'delivery_day_from_starting_hour' in params:
            query_params.append(('delivery_day_from_starting_hour', params['delivery_day_from_starting_hour']))  # noqa: E501
        if 'delivery_day_to_ending_hour' in params:
            query_params.append(('delivery_day_to_ending_hour', params['delivery_day_to_ending_hour']))  # noqa: E501
        if 'cl_ordr_id' in params:
            query_params.append(('clOrdrId', params['cl_ordr_id']))  # noqa: E501
        if 'txt' in params:
            query_params.append(('txt', params['txt']))  # noqa: E501
        if 'with_trades' in params:
            query_params.append(('with_trades', params['with_trades']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/report/{delivery_area}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Report',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
