# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The Powerbot system provides B2B services for trading at intraday power markets. By using the Powerbot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that he/she is familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/extras/download-center/documentation) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION Powerbot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## DOCUMENTATION  In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The Powerbot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) The API provides automated generation of API clients (programming libraries) for a wide range of programming languages. To generate them, please open Swagger Editor from the exchange menu, click on \"Generate Client\" and choose a programming language.  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    OpenAPI spec version: 2.1.27
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_client.api_client import ApiClient


class LogsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_log_entry(self, body, **kwargs):  # noqa: E501
        """Adds a new system log entry  # noqa: E501

        We provide a logging system to record internal events. You can use this method to add a log entry, which is shown in the dashboard and can also be retrieved later.  There are three different types of logs (system, tenant, portfolio), these logs can be posted from different API key types as listed below:  - scheduling-API-key without tenant -> system logs (omit portfolio_id) - scheduling-API-key with tenant -> tenant logs (omit portfolio_id - standard-API-key -> portfolio logs (specify portfolio_id) AND tenant logs (omit portfolio_id) - tenant-master-API-key -> cannot submit any logs - master-API-key -> cannot submit any logs  A log entry belongs to a freely chosen category and has a defined severity as well as a timestamp (UTC) value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_log_entry(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LogEntry body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_log_entry_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_log_entry_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_log_entry_with_http_info(self, body, **kwargs):  # noqa: E501
        """Adds a new system log entry  # noqa: E501

        We provide a logging system to record internal events. You can use this method to add a log entry, which is shown in the dashboard and can also be retrieved later.  There are three different types of logs (system, tenant, portfolio), these logs can be posted from different API key types as listed below:  - scheduling-API-key without tenant -> system logs (omit portfolio_id) - scheduling-API-key with tenant -> tenant logs (omit portfolio_id - standard-API-key -> portfolio logs (specify portfolio_id) AND tenant logs (omit portfolio_id) - tenant-master-API-key -> cannot submit any logs - master-API-key -> cannot submit any logs  A log entry belongs to a freely chosen category and has a defined severity as well as a timestamp (UTC) value.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_log_entry_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param LogEntry body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_log_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_log_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/logs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_logs(self, **kwargs):  # noqa: E501
        """Retrieves system log entries  # noqa: E501

        Retrieves log entries which you have submitted earlier with \"POST /logs\". Logs can be retrieved for a set (array) of portfolios and categories. The query can be filtered by minimum severity and a time interval. Please note that this feature uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_logs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] portfolio_id:
        :param int offset: Offset when loading a list of items
        :param int limit: Limits the number of loaded items
        :param str severity_at_least:
        :param list[str] category:
        :param datetime received_from: from timestamp is 'inclusive' (i.e. >=), use UTC time zone
        :param datetime received_to: to timestamp is 'exclusive' (i.e. <), use UTC time zone
        :return: list[LogEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_logs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_logs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_logs_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieves system log entries  # noqa: E501

        Retrieves log entries which you have submitted earlier with \"POST /logs\". Logs can be retrieved for a set (array) of portfolios and categories. The query can be filtered by minimum severity and a time interval. Please note that this feature uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_logs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] portfolio_id:
        :param int offset: Offset when loading a list of items
        :param int limit: Limits the number of loaded items
        :param str severity_at_least:
        :param list[str] category:
        :param datetime received_from: from timestamp is 'inclusive' (i.e. >=), use UTC time zone
        :param datetime received_to: to timestamp is 'exclusive' (i.e. <), use UTC time zone
        :return: list[LogEntry]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id', 'offset', 'limit', 'severity_at_least', 'category', 'received_from', 'received_to']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_logs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'portfolio_id' in params:
            query_params.append(('portfolio_id', params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'severity_at_least' in params:
            query_params.append(('severity_at_least', params['severity_at_least']))  # noqa: E501
        if 'category' in params:
            query_params.append(('category', params['category']))  # noqa: E501
            collection_formats['category'] = 'csv'  # noqa: E501
        if 'received_from' in params:
            query_params.append(('received_from', params['received_from']))  # noqa: E501
        if 'received_to' in params:
            query_params.append(('received_to', params['received_to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LogEntry]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
