# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The Powerbot system provides B2B services for trading at intraday power markets. By using the Powerbot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that he/she is familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/extras/download-center/documentation) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION Powerbot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## DOCUMENTATION  In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The Powerbot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) The API provides automated generation of API clients (programming libraries) for a wide range of programming languages. To generate them, please open Swagger Editor from the exchange menu, click on \"Generate Client\" and choose a programming language.  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    OpenAPI spec version: 2.1.27
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_client.api_client import ApiClient


class ContractApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def calculate_statistics(self, delivery_area, delivery_start, delivery_end, **kwargs):  # noqa: E501
        """Retrieve contract statistics  # noqa: E501

        Calculates the average price and volume of public trades executed for a given delivery interval for reference price and index calculation. Allows you to filter for public trades executed within a certain time period and to restrict the calculation to a given amount of last traded quantity. Please note that this functionality is only available for active or recently active contracts, that cross border trades are taken into account if either the buy or sell leg of the trade is in the specified delivery area(s) and that the quantity of a trade is only counted once.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calculate_statistics(delivery_area, delivery_start, delivery_end, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] delivery_area: (required)
        :param datetime delivery_start: (required)
        :param datetime delivery_end: (required)
        :param datetime execution_from:
        :param datetime execution_to:
        :param float limit_to_last_mw:
        :return: ContractStatistics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.calculate_statistics_with_http_info(delivery_area, delivery_start, delivery_end, **kwargs)  # noqa: E501
        else:
            (data) = self.calculate_statistics_with_http_info(delivery_area, delivery_start, delivery_end, **kwargs)  # noqa: E501
            return data

    def calculate_statistics_with_http_info(self, delivery_area, delivery_start, delivery_end, **kwargs):  # noqa: E501
        """Retrieve contract statistics  # noqa: E501

        Calculates the average price and volume of public trades executed for a given delivery interval for reference price and index calculation. Allows you to filter for public trades executed within a certain time period and to restrict the calculation to a given amount of last traded quantity. Please note that this functionality is only available for active or recently active contracts, that cross border trades are taken into account if either the buy or sell leg of the trade is in the specified delivery area(s) and that the quantity of a trade is only counted once.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calculate_statistics_with_http_info(delivery_area, delivery_start, delivery_end, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] delivery_area: (required)
        :param datetime delivery_start: (required)
        :param datetime delivery_end: (required)
        :param datetime execution_from:
        :param datetime execution_to:
        :param float limit_to_last_mw:
        :return: ContractStatistics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['delivery_area', 'delivery_start', 'delivery_end', 'execution_from', 'execution_to', 'limit_to_last_mw']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method calculate_statistics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'delivery_area' is set
        if ('delivery_area' not in params or
                params['delivery_area'] is None):
            raise ValueError("Missing the required parameter `delivery_area` when calling `calculate_statistics`")  # noqa: E501
        # verify the required parameter 'delivery_start' is set
        if ('delivery_start' not in params or
                params['delivery_start'] is None):
            raise ValueError("Missing the required parameter `delivery_start` when calling `calculate_statistics`")  # noqa: E501
        # verify the required parameter 'delivery_end' is set
        if ('delivery_end' not in params or
                params['delivery_end'] is None):
            raise ValueError("Missing the required parameter `delivery_end` when calling `calculate_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'delivery_area' in params:
            query_params.append(('delivery_area', params['delivery_area']))  # noqa: E501
            collection_formats['delivery_area'] = 'csv'  # noqa: E501
        if 'delivery_start' in params:
            query_params.append(('delivery_start', params['delivery_start']))  # noqa: E501
        if 'delivery_end' in params:
            query_params.append(('delivery_end', params['delivery_end']))  # noqa: E501
        if 'execution_from' in params:
            query_params.append(('execution_from', params['execution_from']))  # noqa: E501
        if 'execution_to' in params:
            query_params.append(('execution_to', params['execution_to']))  # noqa: E501
        if 'limit_to_last_mw' in params:
            query_params.append(('limit_to_last_mw', params['limit_to_last_mw']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/contracts/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContractStatistics',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_contracts(self, **kwargs):  # noqa: E501
        """Find contracts  # noqa: E501

        This method allows you to find active or historical contracts based on their delivery_start and delivery_end time (UTC) and lets you determine their contract_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_contracts(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] contract_id:
        :param datetime delivery_start:
        :param datetime delivery_end:
        :return: list[ContractItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.find_contracts_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.find_contracts_with_http_info(**kwargs)  # noqa: E501
            return data

    def find_contracts_with_http_info(self, **kwargs):  # noqa: E501
        """Find contracts  # noqa: E501

        This method allows you to find active or historical contracts based on their delivery_start and delivery_end time (UTC) and lets you determine their contract_id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_contracts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] contract_id:
        :param datetime delivery_start:
        :param datetime delivery_end:
        :return: list[ContractItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_id', 'delivery_start', 'delivery_end']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_contracts" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'contract_id' in params:
            query_params.append(('contract_id', params['contract_id']))  # noqa: E501
            collection_formats['contract_id'] = 'csv'  # noqa: E501
        if 'delivery_start' in params:
            query_params.append(('delivery_start', params['delivery_start']))  # noqa: E501
        if 'delivery_end' in params:
            query_params.append(('delivery_end', params['delivery_end']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/contracts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ContractItem]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_contract_history(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Retrieves the history of a contract  # noqa: E501

        This method allows you to retrieve the history of a contract in a delivery area in the form of revisions (which include delta and sometimes full orderbook updates). When querying with a list of portfolios, you can retrieve all your own trades and signals that belong to the contract. When querying with a timestamp in \"as_of\", you can retrieve the contract history at a given point in time, or you can request a set of revisions.  If with_orders is set to true, the revisions will include new and deleted orders that belong to the revision (if requesting revisions) in delta-format or the full orderbook if requesting a historical version using \"as_of\".  Please note that this feature uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contract_history(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str contract_id: The unique id of the contract (required)
        :param str delivery_area: The EIC code of the delivery area (required)
        :param int offset: the item offset of the request
        :param int limit: the amount of items that should be retrieved
        :param list[str] portfolio_id:
        :param int from_revision: Revisions start with 0, each change increments it by 1. Please note that only up to 150 revisions at a time can be fetched.
        :param int to_revision: Revisions start with 0, each change increments it by 1. Please note that only up to 150 revisions at a time can be fetched.
        :param datetime as_of: Contract history as_of given point in time. Cannot be combined together with from_revision and to_revision.
        :param bool with_owntrades: If set to true, the own trades which happend on that revision are returned.
        :param bool with_signals: If set to true, the signals valid for that revision are returned.
        :param bool with_orders: If set to true, details about bids/asks are returned
        :return: list[ContractHistoryItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_contract_history_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501
        else:
            (data) = self.get_contract_history_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501
            return data

    def get_contract_history_with_http_info(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Retrieves the history of a contract  # noqa: E501

        This method allows you to retrieve the history of a contract in a delivery area in the form of revisions (which include delta and sometimes full orderbook updates). When querying with a list of portfolios, you can retrieve all your own trades and signals that belong to the contract. When querying with a timestamp in \"as_of\", you can retrieve the contract history at a given point in time, or you can request a set of revisions.  If with_orders is set to true, the revisions will include new and deleted orders that belong to the revision (if requesting revisions) in delta-format or the full orderbook if requesting a historical version using \"as_of\".  Please note that this feature uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contract_history_with_http_info(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str contract_id: The unique id of the contract (required)
        :param str delivery_area: The EIC code of the delivery area (required)
        :param int offset: the item offset of the request
        :param int limit: the amount of items that should be retrieved
        :param list[str] portfolio_id:
        :param int from_revision: Revisions start with 0, each change increments it by 1. Please note that only up to 150 revisions at a time can be fetched.
        :param int to_revision: Revisions start with 0, each change increments it by 1. Please note that only up to 150 revisions at a time can be fetched.
        :param datetime as_of: Contract history as_of given point in time. Cannot be combined together with from_revision and to_revision.
        :param bool with_owntrades: If set to true, the own trades which happend on that revision are returned.
        :param bool with_signals: If set to true, the signals valid for that revision are returned.
        :param bool with_orders: If set to true, details about bids/asks are returned
        :return: list[ContractHistoryItem]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_id', 'delivery_area', 'offset', 'limit', 'portfolio_id', 'from_revision', 'to_revision', 'as_of', 'with_owntrades', 'with_signals', 'with_orders']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contract_history" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contract_id' is set
        if ('contract_id' not in params or
                params['contract_id'] is None):
            raise ValueError("Missing the required parameter `contract_id` when calling `get_contract_history`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if ('delivery_area' not in params or
                params['delivery_area'] is None):
            raise ValueError("Missing the required parameter `delivery_area` when calling `get_contract_history`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in params:
            path_params['contract_id'] = params['contract_id']  # noqa: E501
        if 'delivery_area' in params:
            path_params['delivery_area'] = params['delivery_area']  # noqa: E501

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'portfolio_id' in params:
            query_params.append(('portfolio_id', params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if 'from_revision' in params:
            query_params.append(('from_revision', params['from_revision']))  # noqa: E501
        if 'to_revision' in params:
            query_params.append(('to_revision', params['to_revision']))  # noqa: E501
        if 'as_of' in params:
            query_params.append(('as_of', params['as_of']))  # noqa: E501
        if 'with_owntrades' in params:
            query_params.append(('with_owntrades', params['with_owntrades']))  # noqa: E501
        if 'with_signals' in params:
            query_params.append(('with_signals', params['with_signals']))  # noqa: E501
        if 'with_orders' in params:
            query_params.append(('with_orders', params['with_orders']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/contract/{contract_id}/{delivery_area}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ContractHistoryItem]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_contract_signals(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Retrieves the signals for a contract  # noqa: E501

        This method allows you to retrieve your trading signals (your positions or custom data like weather, fundamental data etc.) valid for a contract in a delivery area for one or more portfolios.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contract_signals(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str contract_id: The unique id of the contract (required)
        :param str delivery_area: The EIC code of the delivery area (required)
        :param list[str] portfolio_id:
        :return: list[Signal]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_contract_signals_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501
        else:
            (data) = self.get_contract_signals_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501
            return data

    def get_contract_signals_with_http_info(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Retrieves the signals for a contract  # noqa: E501

        This method allows you to retrieve your trading signals (your positions or custom data like weather, fundamental data etc.) valid for a contract in a delivery area for one or more portfolios.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_contract_signals_with_http_info(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str contract_id: The unique id of the contract (required)
        :param str delivery_area: The EIC code of the delivery area (required)
        :param list[str] portfolio_id:
        :return: list[Signal]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_id', 'delivery_area', 'portfolio_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contract_signals" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contract_id' is set
        if ('contract_id' not in params or
                params['contract_id'] is None):
            raise ValueError("Missing the required parameter `contract_id` when calling `get_contract_signals`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if ('delivery_area' not in params or
                params['delivery_area'] is None):
            raise ValueError("Missing the required parameter `delivery_area` when calling `get_contract_signals`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in params:
            path_params['contract_id'] = params['contract_id']  # noqa: E501
        if 'delivery_area' in params:
            path_params['delivery_area'] = params['delivery_area']  # noqa: E501

        query_params = []
        if 'portfolio_id' in params:
            query_params.append(('portfolio_id', params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/contract/{contract_id}/{delivery_area}/signals', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Signal]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_limits(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Calculates the portfolio information for a contract in a delivery area  # noqa: E501

        Calculates the current positions for a given contract. Per default, only trades are taken into account for these calculations, however it also inculde standing orders via the given parameter.         In particular, you have to set \"include_standing_orders\" to True to receive the correct values for \"max_net_pos_buy_with_orders\" and \"min_net_pos_sell_with_orders\", otherwise only trades will be taken into account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_limits(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str contract_id: The unique id of the contract (required)
        :param str delivery_area: The EIC code of the delivery area (required)
        :param list[str] portfolio_id:
        :param bool include_standing_orders: Include standing (active) orders in the risk calculation
        :return: RiskSettingsAndPortfolioInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_limits_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501
        else:
            (data) = self.get_limits_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501
            return data

    def get_limits_with_http_info(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Calculates the portfolio information for a contract in a delivery area  # noqa: E501

        Calculates the current positions for a given contract. Per default, only trades are taken into account for these calculations, however it also inculde standing orders via the given parameter.         In particular, you have to set \"include_standing_orders\" to True to receive the correct values for \"max_net_pos_buy_with_orders\" and \"min_net_pos_sell_with_orders\", otherwise only trades will be taken into account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_limits_with_http_info(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str contract_id: The unique id of the contract (required)
        :param str delivery_area: The EIC code of the delivery area (required)
        :param list[str] portfolio_id:
        :param bool include_standing_orders: Include standing (active) orders in the risk calculation
        :return: RiskSettingsAndPortfolioInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_id', 'delivery_area', 'portfolio_id', 'include_standing_orders']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_limits" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contract_id' is set
        if ('contract_id' not in params or
                params['contract_id'] is None):
            raise ValueError("Missing the required parameter `contract_id` when calling `get_limits`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if ('delivery_area' not in params or
                params['delivery_area'] is None):
            raise ValueError("Missing the required parameter `delivery_area` when calling `get_limits`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in params:
            path_params['contract_id'] = params['contract_id']  # noqa: E501
        if 'delivery_area' in params:
            path_params['delivery_area'] = params['delivery_area']  # noqa: E501

        query_params = []
        if 'portfolio_id' in params:
            query_params.append(('portfolio_id', params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if 'include_standing_orders' in params:
            query_params.append(('include_standing_orders', params['include_standing_orders']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/contract/{contract_id}/{delivery_area}/portfolio-information', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RiskSettingsAndPortfolioInformation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_order_books(self, **kwargs):  # noqa: E501
        """Retrieves the public order book (sorted by delivery ascending)  # noqa: E501

        Shows the public order book for the requested products (or all available products) for a given delivery_area. Default delivery area will be applied if left blank and default is set. This request will by default only deliver the order book statistics (best bid, best ask, last etc.) and does not include the full orderbook depth. If you are querying for only one contract, you can retreive the full order book by setting with_order_details to \"true\". Alternatively you can request the full order book with GET /contract/contract_id/delivery_area/orders.  The order book containts portfolio relevant data (like net_position, signals etc.) and can thus be filtered by a list of portfolio IDs. Setting the limit parameter allows to limit the number of entries returned per request (sorted by ascending delivery time).  The filter with_bid_or_ask_only returns only non empty order books. If past_hours is set, the orderbook will include historical contracts that have been closed in the last X hours.  Using delivery_from and delivery_to, the order book can be further limited to a given timespan. If used in conjunction with past_hours, delivery_from has to be after the time defined by past_hours (now - past_hours < delivery_from < delivery_to).  Please note the SLA of 100 requests/h when requesting the full orderbook depth for more than one contract.  This request uses caching, if the response on multiple requests does not change, a cached response is returned. In this case, the field \"etag\" in the response-header does not change.  For the best performance and to get the most out of caching, we urge you to set the parameter \"with_portfolio_information\" to false and request the portfolio_information only when you need it via GET/contract/{contract_id}/{delivery_area}/portfolio-information.  The parameters \"with_signals\", \"with_risk_settings\" and \"with_products\" also influence how often a cached response is returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_books(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] portfolio_id:
        :param str product: The list of products (e.g. Intraday_Power_D,XBID_Hour_Power) *separated by a comma*, for which the orderbook(s) should be retrieved; leave blank if you want all available orderbooks
        :param bool with_bid_or_ask_only: If set to true, the returned orderbook will contain only contracts which contain at least one active bid or ask
        :param bool with_signals: If set to true, the returned orderbook will contain the signals applicable for the contracts
        :param list[str] contract_id: limit the orderbook to an array of certain contracts only
        :param str contract_name: limit the orderbook to a certain contract name only
        :param datetime delivery_start: limit the orderbook to those contracts with the given delivery start date
        :param datetime delivery_end: limit the orderbook to those contracts with the given delivery end date
        :param datetime delivery_within: limit the orderbook to those contracts having a delivery start/end date which starts before and ends after the given parameter
        :param int past_hours: The number of hours to look into the past in the orderbook. If this parameter is set, historic closed contracts are contained in the orderbook as well. Can't be used in conjunction with delivery_from.
        :param str delivery_area: The EIC code of the delivery area of the orderbook
        :param datetime delivery_from: Limits the orderbook to those contracts with a delivery start date >= delivery_from. When used in conjunction with past_hours, has to be after the time defined by past_hours (delivery_from > now - past_hours).
        :param datetime delivery_to: Limits the orderbook to those contracts with a delivery end date <= delivery_to
        :param bool with_order_details: If set to true, the returned orderbook will contain all current bids and asks of each contract (full orderbook depth). *Heads up* Only up to 100 calls are are allowed per hour and per delivery area when requesting the full orderobook for several contracts. This is not applicable if only one contract is requested.
        :param str contract_type: **PDC**: (default) the order book only includes predefined contracts, i.e. the normal contracts generated by the backend  UDC: the order book only includes block products, which were created as the result of a block order submitted by a member  ALL: the order book contains both, PDC and UDC contracts
        :param bool with_portfolio_information: If set to true, the portfolio_informations are included in the response. Set to false to optimize caching.
        :param bool with_risk_settings: If set to true, the risk_setting of the portfolio are included in the response. Set to false to optimize caching.
        :param bool with_products: If set to true, the available products are included in the response. Set to false to optimize caching.
        :param int limit: Limits the number of returned order books
        :return: OrderBooks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_order_books_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_order_books_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_order_books_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieves the public order book (sorted by delivery ascending)  # noqa: E501

        Shows the public order book for the requested products (or all available products) for a given delivery_area. Default delivery area will be applied if left blank and default is set. This request will by default only deliver the order book statistics (best bid, best ask, last etc.) and does not include the full orderbook depth. If you are querying for only one contract, you can retreive the full order book by setting with_order_details to \"true\". Alternatively you can request the full order book with GET /contract/contract_id/delivery_area/orders.  The order book containts portfolio relevant data (like net_position, signals etc.) and can thus be filtered by a list of portfolio IDs. Setting the limit parameter allows to limit the number of entries returned per request (sorted by ascending delivery time).  The filter with_bid_or_ask_only returns only non empty order books. If past_hours is set, the orderbook will include historical contracts that have been closed in the last X hours.  Using delivery_from and delivery_to, the order book can be further limited to a given timespan. If used in conjunction with past_hours, delivery_from has to be after the time defined by past_hours (now - past_hours < delivery_from < delivery_to).  Please note the SLA of 100 requests/h when requesting the full orderbook depth for more than one contract.  This request uses caching, if the response on multiple requests does not change, a cached response is returned. In this case, the field \"etag\" in the response-header does not change.  For the best performance and to get the most out of caching, we urge you to set the parameter \"with_portfolio_information\" to false and request the portfolio_information only when you need it via GET/contract/{contract_id}/{delivery_area}/portfolio-information.  The parameters \"with_signals\", \"with_risk_settings\" and \"with_products\" also influence how often a cached response is returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_order_books_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] portfolio_id:
        :param str product: The list of products (e.g. Intraday_Power_D,XBID_Hour_Power) *separated by a comma*, for which the orderbook(s) should be retrieved; leave blank if you want all available orderbooks
        :param bool with_bid_or_ask_only: If set to true, the returned orderbook will contain only contracts which contain at least one active bid or ask
        :param bool with_signals: If set to true, the returned orderbook will contain the signals applicable for the contracts
        :param list[str] contract_id: limit the orderbook to an array of certain contracts only
        :param str contract_name: limit the orderbook to a certain contract name only
        :param datetime delivery_start: limit the orderbook to those contracts with the given delivery start date
        :param datetime delivery_end: limit the orderbook to those contracts with the given delivery end date
        :param datetime delivery_within: limit the orderbook to those contracts having a delivery start/end date which starts before and ends after the given parameter
        :param int past_hours: The number of hours to look into the past in the orderbook. If this parameter is set, historic closed contracts are contained in the orderbook as well. Can't be used in conjunction with delivery_from.
        :param str delivery_area: The EIC code of the delivery area of the orderbook
        :param datetime delivery_from: Limits the orderbook to those contracts with a delivery start date >= delivery_from. When used in conjunction with past_hours, has to be after the time defined by past_hours (delivery_from > now - past_hours).
        :param datetime delivery_to: Limits the orderbook to those contracts with a delivery end date <= delivery_to
        :param bool with_order_details: If set to true, the returned orderbook will contain all current bids and asks of each contract (full orderbook depth). *Heads up* Only up to 100 calls are are allowed per hour and per delivery area when requesting the full orderobook for several contracts. This is not applicable if only one contract is requested.
        :param str contract_type: **PDC**: (default) the order book only includes predefined contracts, i.e. the normal contracts generated by the backend  UDC: the order book only includes block products, which were created as the result of a block order submitted by a member  ALL: the order book contains both, PDC and UDC contracts
        :param bool with_portfolio_information: If set to true, the portfolio_informations are included in the response. Set to false to optimize caching.
        :param bool with_risk_settings: If set to true, the risk_setting of the portfolio are included in the response. Set to false to optimize caching.
        :param bool with_products: If set to true, the available products are included in the response. Set to false to optimize caching.
        :param int limit: Limits the number of returned order books
        :return: OrderBooks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['portfolio_id', 'product', 'with_bid_or_ask_only', 'with_signals', 'contract_id', 'contract_name', 'delivery_start', 'delivery_end', 'delivery_within', 'past_hours', 'delivery_area', 'delivery_from', 'delivery_to', 'with_order_details', 'contract_type', 'with_portfolio_information', 'with_risk_settings', 'with_products', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_books" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'portfolio_id' in params:
            query_params.append(('portfolio_id', params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if 'product' in params:
            query_params.append(('product', params['product']))  # noqa: E501
        if 'with_bid_or_ask_only' in params:
            query_params.append(('with_bid_or_ask_only', params['with_bid_or_ask_only']))  # noqa: E501
        if 'with_signals' in params:
            query_params.append(('with_signals', params['with_signals']))  # noqa: E501
        if 'contract_id' in params:
            query_params.append(('contractId', params['contract_id']))  # noqa: E501
            collection_formats['contractId'] = 'csv'  # noqa: E501
        if 'contract_name' in params:
            query_params.append(('contractName', params['contract_name']))  # noqa: E501
        if 'delivery_start' in params:
            query_params.append(('delivery_start', params['delivery_start']))  # noqa: E501
        if 'delivery_end' in params:
            query_params.append(('delivery_end', params['delivery_end']))  # noqa: E501
        if 'delivery_within' in params:
            query_params.append(('delivery_within', params['delivery_within']))  # noqa: E501
        if 'past_hours' in params:
            query_params.append(('past_hours', params['past_hours']))  # noqa: E501
        if 'delivery_area' in params:
            query_params.append(('delivery_area', params['delivery_area']))  # noqa: E501
        if 'delivery_from' in params:
            query_params.append(('delivery_from', params['delivery_from']))  # noqa: E501
        if 'delivery_to' in params:
            query_params.append(('delivery_to', params['delivery_to']))  # noqa: E501
        if 'with_order_details' in params:
            query_params.append(('with_order_details', params['with_order_details']))  # noqa: E501
        if 'contract_type' in params:
            query_params.append(('contract_type', params['contract_type']))  # noqa: E501
        if 'with_portfolio_information' in params:
            query_params.append(('with_portfolio_information', params['with_portfolio_information']))  # noqa: E501
        if 'with_risk_settings' in params:
            query_params.append(('with_risk_settings', params['with_risk_settings']))  # noqa: E501
        if 'with_products' in params:
            query_params.append(('with_products', params['with_products']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/orderbooks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrderBooks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_orders(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Retrieves the full orderbook (all current bids and asks) of a contract  # noqa: E501

        This method allows you to retrieve the full public orderbook of a contract (all bids and asks) in a specific delivery area.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orders(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str contract_id: (required)
        :param str delivery_area: The EIC code of the delivery area (required)
        :return: Orders
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_orders_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501
        else:
            (data) = self.get_orders_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501
            return data

    def get_orders_with_http_info(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Retrieves the full orderbook (all current bids and asks) of a contract  # noqa: E501

        This method allows you to retrieve the full public orderbook of a contract (all bids and asks) in a specific delivery area.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_orders_with_http_info(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str contract_id: (required)
        :param str delivery_area: The EIC code of the delivery area (required)
        :return: Orders
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_id', 'delivery_area']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contract_id' is set
        if ('contract_id' not in params or
                params['contract_id'] is None):
            raise ValueError("Missing the required parameter `contract_id` when calling `get_orders`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if ('delivery_area' not in params or
                params['delivery_area'] is None):
            raise ValueError("Missing the required parameter `delivery_area` when calling `get_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in params:
            path_params['contract_id'] = params['contract_id']  # noqa: E501
        if 'delivery_area' in params:
            path_params['delivery_area'] = params['delivery_area']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/contract/{contract_id}/{delivery_area}/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Orders',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_public_trades(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Retrieves the public trades for a contract  # noqa: E501

        This method allows you to retrieve all public trades that were executed at the exchange for a given contract_id and delivery area. Please note that this function uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_trades(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str contract_id: (required)
        :param str delivery_area: The EIC code of the delivery area (required)
        :param int offset: Offset when loading a list of items
        :param int limit: Limits the number of loaded items
        :param datetime from_api_timestamp: from timestamp is 'inclusive' (i.e. >=)
        :param datetime to_api_timestamp: to timestamp is 'exclusive' (i.e. <)
        :param datetime from_execution_time: from timestamp is 'inclusive' (i.e. >=)
        :param datetime to_execution_time: to timestamp is 'exclusive' (i.e. <)
        :return: list[PublicTrade]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_public_trades_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501
        else:
            (data) = self.get_public_trades_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501
            return data

    def get_public_trades_with_http_info(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Retrieves the public trades for a contract  # noqa: E501

        This method allows you to retrieve all public trades that were executed at the exchange for a given contract_id and delivery area. Please note that this function uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_public_trades_with_http_info(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str contract_id: (required)
        :param str delivery_area: The EIC code of the delivery area (required)
        :param int offset: Offset when loading a list of items
        :param int limit: Limits the number of loaded items
        :param datetime from_api_timestamp: from timestamp is 'inclusive' (i.e. >=)
        :param datetime to_api_timestamp: to timestamp is 'exclusive' (i.e. <)
        :param datetime from_execution_time: from timestamp is 'inclusive' (i.e. >=)
        :param datetime to_execution_time: to timestamp is 'exclusive' (i.e. <)
        :return: list[PublicTrade]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contract_id', 'delivery_area', 'offset', 'limit', 'from_api_timestamp', 'to_api_timestamp', 'from_execution_time', 'to_execution_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_trades" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'contract_id' is set
        if ('contract_id' not in params or
                params['contract_id'] is None):
            raise ValueError("Missing the required parameter `contract_id` when calling `get_public_trades`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if ('delivery_area' not in params or
                params['delivery_area'] is None):
            raise ValueError("Missing the required parameter `delivery_area` when calling `get_public_trades`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in params:
            path_params['contract_id'] = params['contract_id']  # noqa: E501
        if 'delivery_area' in params:
            path_params['delivery_area'] = params['delivery_area']  # noqa: E501

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'from_api_timestamp' in params:
            query_params.append(('from_api_timestamp', params['from_api_timestamp']))  # noqa: E501
        if 'to_api_timestamp' in params:
            query_params.append(('to_api_timestamp', params['to_api_timestamp']))  # noqa: E501
        if 'from_execution_time' in params:
            query_params.append(('from_execution_time', params['from_execution_time']))  # noqa: E501
        if 'to_execution_time' in params:
            query_params.append(('to_execution_time', params['to_execution_time']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/contract/{contract_id}/{delivery_area}/publictrades', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PublicTrade]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
