# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The Powerbot system provides B2B services for trading at intraday power markets. By using the Powerbot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that he/she is familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/extras/download-center/documentation) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of OTR (order-to-trade) limits and other limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION Powerbot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## DOCUMENTATION  In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The Powerbot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) The API provides automated generation of API clients (programming libraries) for a wide range of programming languages. To generate them, please open Swagger Editor from the exchange menu, click on \"Generate Client\" and choose a programming language.  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.  ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    OpenAPI spec version: 2.1.27
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_client.api_client import ApiClient


class AlgorithmsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_algorithm(self, body, **kwargs):  # noqa: E501
        """Register a new algorithm  # noqa: E501

        Use this method to create a new algorithm. In order to create an algorithm, you need to use the master-API-key which has been provided to you (other API keys cannot create a tenant). An algorithm provides a setup which contains the required information an algorithm needs. To run an algorithm, create an instance of it and start/stop it via the given endpoint. An algorithm requires a unique id, information about how often it expects a heartbeat and how it should behave if the heartbeat is missing. The image can be any valid docker image name with a tag. The tag can not be \"latest\" to avoid accidental upgrades.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_algorithm(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlgoSetup body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_algorithm_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_algorithm_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def add_algorithm_with_http_info(self, body, **kwargs):  # noqa: E501
        """Register a new algorithm  # noqa: E501

        Use this method to create a new algorithm. In order to create an algorithm, you need to use the master-API-key which has been provided to you (other API keys cannot create a tenant). An algorithm provides a setup which contains the required information an algorithm needs. To run an algorithm, create an instance of it and start/stop it via the given endpoint. An algorithm requires a unique id, information about how often it expects a heartbeat and how it should behave if the heartbeat is missing. The image can be any valid docker image name with a tag. The tag can not be \"latest\" to avoid accidental upgrades.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_algorithm_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlgoSetup body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_algorithm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `add_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/algorithms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_algorithm(self, algorithm_id, **kwargs):  # noqa: E501
        """Delete an algorithm  # noqa: E501

        This is only possible if the algorithm has no instances assigned to it. Only the master-API-key is allowed to delete algorithms.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_algorithm(algorithm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str algorithm_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_algorithm_with_http_info(algorithm_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_algorithm_with_http_info(algorithm_id, **kwargs)  # noqa: E501
            return data

    def delete_algorithm_with_http_info(self, algorithm_id, **kwargs):  # noqa: E501
        """Delete an algorithm  # noqa: E501

        This is only possible if the algorithm has no instances assigned to it. Only the master-API-key is allowed to delete algorithms.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_algorithm_with_http_info(algorithm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str algorithm_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['algorithm_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_algorithm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if ('algorithm_id' not in params or
                params['algorithm_id'] is None):
            raise ValueError("Missing the required parameter `algorithm_id` when calling `delete_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in params:
            path_params['algorithm_id'] = params['algorithm_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_algorithm_instance(self, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Delete an algorithm instance  # noqa: E501

        Instances can only be deleted if they are not running. - Master-API-keys can delete all instances. - Tenant-master-API-keys can only delete instances, where the key has access to ALL portfolios specified in the instance. - Standard-API-keys and Scheduling-API-keys are not allowed to delete instances.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_algorithm_instance(algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str algorithm_id: (required)
        :param str instance_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_algorithm_instance_with_http_info(algorithm_id, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_algorithm_instance_with_http_info(algorithm_id, instance_id, **kwargs)  # noqa: E501
            return data

    def delete_algorithm_instance_with_http_info(self, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Delete an algorithm instance  # noqa: E501

        Instances can only be deleted if they are not running. - Master-API-keys can delete all instances. - Tenant-master-API-keys can only delete instances, where the key has access to ALL portfolios specified in the instance. - Standard-API-keys and Scheduling-API-keys are not allowed to delete instances.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_algorithm_instance_with_http_info(algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str algorithm_id: (required)
        :param str instance_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['algorithm_id', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_algorithm_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if ('algorithm_id' not in params or
                params['algorithm_id'] is None):
            raise ValueError("Missing the required parameter `algorithm_id` when calling `delete_algorithm_instance`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `delete_algorithm_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in params:
            path_params['algorithm_id'] = params['algorithm_id']  # noqa: E501
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instance/{instance_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_algo_instance_status(self, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Retrieves details about the algorithm instance  # noqa: E501

        Retrieves details about the algorithm instance. - Master-API-keys can always retrieve details about an algorithm-instance. - Tenant-master-API-keys can only access algorithm-instances, where the key has access to AT LEAST ONE portfolio specified in the instance. - Standard-API-keys can only access algorithm-instances, where the key has access to AT LEAST ONE portfolio specified in the instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_algo_instance_status(algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str algorithm_id: (required)
        :param str instance_id: (required)
        :return: AlgoInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_algo_instance_status_with_http_info(algorithm_id, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_algo_instance_status_with_http_info(algorithm_id, instance_id, **kwargs)  # noqa: E501
            return data

    def get_algo_instance_status_with_http_info(self, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Retrieves details about the algorithm instance  # noqa: E501

        Retrieves details about the algorithm instance. - Master-API-keys can always retrieve details about an algorithm-instance. - Tenant-master-API-keys can only access algorithm-instances, where the key has access to AT LEAST ONE portfolio specified in the instance. - Standard-API-keys can only access algorithm-instances, where the key has access to AT LEAST ONE portfolio specified in the instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_algo_instance_status_with_http_info(algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str algorithm_id: (required)
        :param str instance_id: (required)
        :return: AlgoInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['algorithm_id', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_algo_instance_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if ('algorithm_id' not in params or
                params['algorithm_id'] is None):
            raise ValueError("Missing the required parameter `algorithm_id` when calling `get_algo_instance_status`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `get_algo_instance_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in params:
            path_params['algorithm_id'] = params['algorithm_id']  # noqa: E501
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instance/{instance_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlgoInstance',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_algorithm(self, algorithm_id, **kwargs):  # noqa: E501
        """Retrieves details about an algorithm (with its instances)  # noqa: E501

        Get details for an algorithm and its instances, depending on the access rights of the currently used API key. - The master-API-key can access every algorithm. - A tenant-master-API-key can only access algorithms where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm. - A standard-API-key can only access algorithms where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_algorithm(algorithm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str algorithm_id: (required)
        :return: AlgoDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_algorithm_with_http_info(algorithm_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_algorithm_with_http_info(algorithm_id, **kwargs)  # noqa: E501
            return data

    def get_algorithm_with_http_info(self, algorithm_id, **kwargs):  # noqa: E501
        """Retrieves details about an algorithm (with its instances)  # noqa: E501

        Get details for an algorithm and its instances, depending on the access rights of the currently used API key. - The master-API-key can access every algorithm. - A tenant-master-API-key can only access algorithms where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm. - A standard-API-key can only access algorithms where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_algorithm_with_http_info(algorithm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str algorithm_id: (required)
        :return: AlgoDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['algorithm_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_algorithm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'algorithm_id' is set
        if ('algorithm_id' not in params or
                params['algorithm_id'] is None):
            raise ValueError("Missing the required parameter `algorithm_id` when calling `get_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in params:
            path_params['algorithm_id'] = params['algorithm_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlgoDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_algorithms(self, **kwargs):  # noqa: E501
        """List all available algorithms and instances  # noqa: E501

        Get all algorithms and their instances, depending on the access rights of the currently used API key. - The master-API-key will get all algorithms and instances (exchange independent). - A tenant-master-API-key can retrieve only the algorithms and instances, where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm. - A standard-API-key can retrieve only the algorithms and instances, where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_algorithms(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[AlgoDetails]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_algorithms_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_algorithms_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_algorithms_with_http_info(self, **kwargs):  # noqa: E501
        """List all available algorithms and instances  # noqa: E501

        Get all algorithms and their instances, depending on the access rights of the currently used API key. - The master-API-key will get all algorithms and instances (exchange independent). - A tenant-master-API-key can retrieve only the algorithms and instances, where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm. - A standard-API-key can retrieve only the algorithms and instances, where the key has access to AT LEAST ONE portfolio specified in the instances of the algorithm.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_algorithms_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[AlgoDetails]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_algorithms" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/algorithms', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AlgoDetails]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def modify_algorithm(self, body, algorithm_id, **kwargs):  # noqa: E501
        """Modifies an algorithm  # noqa: E501

        Modifies the fields of an algorithm. Only the master-API-key is allowed to perform this request. Only fields specified in the request will be updated. Please note that invalid values for the field \"on_missing_heartbeat\" will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_algorithm(body, algorithm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateAlgoSetup body: (required)
        :param str algorithm_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.modify_algorithm_with_http_info(body, algorithm_id, **kwargs)  # noqa: E501
        else:
            (data) = self.modify_algorithm_with_http_info(body, algorithm_id, **kwargs)  # noqa: E501
            return data

    def modify_algorithm_with_http_info(self, body, algorithm_id, **kwargs):  # noqa: E501
        """Modifies an algorithm  # noqa: E501

        Modifies the fields of an algorithm. Only the master-API-key is allowed to perform this request. Only fields specified in the request will be updated. Please note that invalid values for the field \"on_missing_heartbeat\" will be ignored.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.modify_algorithm_with_http_info(body, algorithm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateAlgoSetup body: (required)
        :param str algorithm_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'algorithm_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method modify_algorithm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `modify_algorithm`")  # noqa: E501
        # verify the required parameter 'algorithm_id' is set
        if ('algorithm_id' not in params or
                params['algorithm_id'] is None):
            raise ValueError("Missing the required parameter `algorithm_id` when calling `modify_algorithm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in params:
            path_params['algorithm_id'] = params['algorithm_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def new_instance(self, body, algorithm_id, **kwargs):  # noqa: E501
        """Creates a new instance of an algorithm  # noqa: E501

        An instance is used to run an algorithm and pass parameters to it. Only the master-API-key and tenant-master-API-keys are allowed to create algorithm-instances. An instance is always bound to a tenant and a list of portfolios.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.new_instance(body, algorithm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlgoInstanceParameters body: (required)
        :param str algorithm_id: (required)
        :return: AlgoInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.new_instance_with_http_info(body, algorithm_id, **kwargs)  # noqa: E501
        else:
            (data) = self.new_instance_with_http_info(body, algorithm_id, **kwargs)  # noqa: E501
            return data

    def new_instance_with_http_info(self, body, algorithm_id, **kwargs):  # noqa: E501
        """Creates a new instance of an algorithm  # noqa: E501

        An instance is used to run an algorithm and pass parameters to it. Only the master-API-key and tenant-master-API-keys are allowed to create algorithm-instances. An instance is always bound to a tenant and a list of portfolios.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.new_instance_with_http_info(body, algorithm_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlgoInstanceParameters body: (required)
        :param str algorithm_id: (required)
        :return: AlgoInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'algorithm_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method new_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `new_instance`")  # noqa: E501
        # verify the required parameter 'algorithm_id' is set
        if ('algorithm_id' not in params or
                params['algorithm_id'] is None):
            raise ValueError("Missing the required parameter `algorithm_id` when calling `new_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in params:
            path_params['algorithm_id'] = params['algorithm_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instances', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlgoInstance',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def submit_command(self, body, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Requests to start/stop an algorithm instance  # noqa: E501

        This request controls the algorithm instance. Use standard-API-keys to start/stop algorithm instances. The key needs access to ALL portfolios specified in the instance. Master-API-keys and tenant-master-API-keys can also start/stop algorithm instances, however this should only be used in exceptional cases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_command(body, algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlgoCommand body: (required)
        :param str algorithm_id: (required)
        :param str instance_id: (required)
        :return: AlgoInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.submit_command_with_http_info(body, algorithm_id, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.submit_command_with_http_info(body, algorithm_id, instance_id, **kwargs)  # noqa: E501
            return data

    def submit_command_with_http_info(self, body, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Requests to start/stop an algorithm instance  # noqa: E501

        This request controls the algorithm instance. Use standard-API-keys to start/stop algorithm instances. The key needs access to ALL portfolios specified in the instance. Master-API-keys and tenant-master-API-keys can also start/stop algorithm instances, however this should only be used in exceptional cases.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_command_with_http_info(body, algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlgoCommand body: (required)
        :param str algorithm_id: (required)
        :param str instance_id: (required)
        :return: AlgoInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'algorithm_id', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `submit_command`")  # noqa: E501
        # verify the required parameter 'algorithm_id' is set
        if ('algorithm_id' not in params or
                params['algorithm_id'] is None):
            raise ValueError("Missing the required parameter `algorithm_id` when calling `submit_command`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `submit_command`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in params:
            path_params['algorithm_id'] = params['algorithm_id']  # noqa: E501
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instance/{instance_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlgoInstance',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def submit_heart_beat(self, body, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Allows an algorithm instance to submit a heartbeat  # noqa: E501

        Use this endpoint to submit a heartbeat to confirm that the algorithm instance is running correctly. The heartbeat must be sent continuously, every X seconds as specified in the algorithm. Note: The \"status\" sent via this request (heartbeat-status) influences the \"status\" of the instance. In case the status of the instance is NOT \"IDLE\" (= deactivated), the following behavior applies: - heartbeat-status = OK -> status RUNNING - heartbeat-status = FAILURE -> status FAILURE  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_heart_beat(body, algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlgoHeartbeat body: (required)
        :param str algorithm_id: (required)
        :param str instance_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.submit_heart_beat_with_http_info(body, algorithm_id, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.submit_heart_beat_with_http_info(body, algorithm_id, instance_id, **kwargs)  # noqa: E501
            return data

    def submit_heart_beat_with_http_info(self, body, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Allows an algorithm instance to submit a heartbeat  # noqa: E501

        Use this endpoint to submit a heartbeat to confirm that the algorithm instance is running correctly. The heartbeat must be sent continuously, every X seconds as specified in the algorithm. Note: The \"status\" sent via this request (heartbeat-status) influences the \"status\" of the instance. In case the status of the instance is NOT \"IDLE\" (= deactivated), the following behavior applies: - heartbeat-status = OK -> status RUNNING - heartbeat-status = FAILURE -> status FAILURE  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.submit_heart_beat_with_http_info(body, algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AlgoHeartbeat body: (required)
        :param str algorithm_id: (required)
        :param str instance_id: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'algorithm_id', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method submit_heart_beat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `submit_heart_beat`")  # noqa: E501
        # verify the required parameter 'algorithm_id' is set
        if ('algorithm_id' not in params or
                params['algorithm_id'] is None):
            raise ValueError("Missing the required parameter `algorithm_id` when calling `submit_heart_beat`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `submit_heart_beat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in params:
            path_params['algorithm_id'] = params['algorithm_id']  # noqa: E501
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instance/{instance_id}/heartbeat', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_algo_parameters(self, body, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Updates the parameters of an algorithm instance  # noqa: E501

        Note that parameter changes will only be accepted if the algorithm is in \"IDLE\" state. - Master-API-keys can update all instances. - Tenant-Master-API-keys can only update instances where the key has access to ALL portfolios specified in the instance. - Standard-API-keys can only update instances where the key has access to ALL portfolios specified in the instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_algo_parameters(body, algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str algorithm_id: (required)
        :param str instance_id: (required)
        :return: AlgoInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_algo_parameters_with_http_info(body, algorithm_id, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_algo_parameters_with_http_info(body, algorithm_id, instance_id, **kwargs)  # noqa: E501
            return data

    def update_algo_parameters_with_http_info(self, body, algorithm_id, instance_id, **kwargs):  # noqa: E501
        """Updates the parameters of an algorithm instance  # noqa: E501

        Note that parameter changes will only be accepted if the algorithm is in \"IDLE\" state. - Master-API-keys can update all instances. - Tenant-Master-API-keys can only update instances where the key has access to ALL portfolios specified in the instance. - Standard-API-keys can only update instances where the key has access to ALL portfolios specified in the instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_algo_parameters_with_http_info(body, algorithm_id, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str algorithm_id: (required)
        :param str instance_id: (required)
        :return: AlgoInstance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'algorithm_id', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_algo_parameters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_algo_parameters`")  # noqa: E501
        # verify the required parameter 'algorithm_id' is set
        if ('algorithm_id' not in params or
                params['algorithm_id'] is None):
            raise ValueError("Missing the required parameter `algorithm_id` when calling `update_algo_parameters`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `update_algo_parameters`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'algorithm_id' in params:
            path_params['algorithm_id'] = params['algorithm_id']  # noqa: E501
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        return self.api_client.call_api(
            '/algorithm/{algorithm_id}/instance/{instance_id}/parameters', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AlgoInstance',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
