# coding: utf-8

"""
    ARLAS Subscriptions Manager API

    Manage ARLAS subscriptions on ARLAS collections' events.

    OpenAPI spec version: 19.0.7
    Contact: contact@gisaia.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SubscriptionListResource(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'count': 'int',
        'total': 'int',
        'links': 'dict(str, Link)',
        'subscriptions': 'list[UserSubscriptionWithLinks]'
    }

    attribute_map = {
        'count': 'count',
        'total': 'total',
        'links': '_links',
        'subscriptions': 'subscriptions'
    }

    def __init__(self, count=None, total=None, links=None, subscriptions=None):
        """
        SubscriptionListResource - a model defined in Swagger
        """

        self._count = None
        self._total = None
        self._links = None
        self._subscriptions = None

        if count is not None:
          self.count = count
        if total is not None:
          self.total = total
        if links is not None:
          self.links = links
        if subscriptions is not None:
          self.subscriptions = subscriptions

    @property
    def count(self):
        """
        Gets the count of this SubscriptionListResource.

        :return: The count of this SubscriptionListResource.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this SubscriptionListResource.

        :param count: The count of this SubscriptionListResource.
        :type: int
        """

        self._count = count

    @property
    def total(self):
        """
        Gets the total of this SubscriptionListResource.

        :return: The total of this SubscriptionListResource.
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total):
        """
        Sets the total of this SubscriptionListResource.

        :param total: The total of this SubscriptionListResource.
        :type: int
        """

        self._total = total

    @property
    def links(self):
        """
        Gets the links of this SubscriptionListResource.

        :return: The links of this SubscriptionListResource.
        :rtype: dict(str, Link)
        """
        return self._links

    @links.setter
    def links(self, links):
        """
        Sets the links of this SubscriptionListResource.

        :param links: The links of this SubscriptionListResource.
        :type: dict(str, Link)
        """

        self._links = links

    @property
    def subscriptions(self):
        """
        Gets the subscriptions of this SubscriptionListResource.

        :return: The subscriptions of this SubscriptionListResource.
        :rtype: list[UserSubscriptionWithLinks]
        """
        return self._subscriptions

    @subscriptions.setter
    def subscriptions(self, subscriptions):
        """
        Sets the subscriptions of this SubscriptionListResource.

        :param subscriptions: The subscriptions of this SubscriptionListResource.
        :type: list[UserSubscriptionWithLinks]
        """

        self._subscriptions = subscriptions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SubscriptionListResource):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
