# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/05_losses.ipynb (unless otherwise specified).

__all__ = ['WeightedSoftmaxCrossEntropy', 'load_kornia_loss']

# Cell
import torch
import torch.nn.functional as F
from fastai.torch_core import TensorBase
from .utils import import_package

# Cell
class WeightedSoftmaxCrossEntropy(torch.nn.Module):
    "Weighted Softmax Cross Entropy loss functions"
    def __init__(self, *args, axis=-1, reduction = 'mean'):
        super().__init__()
        self.reduction = reduction
        self.axis = axis

    def _contiguous(self,x): return TensorBase(x.contiguous())
    def forward(self, inp, targ, weights):

        inp, targ  = map(self._contiguous, (inp, targ))
        # Weighted soft-max cross-entropy loss
        loss = F.cross_entropy(inp, targ, reduction='none')
        loss = loss * weights
        if  self.reduction == 'mean':
            return loss.mean()

        elif self.reduction == 'sum':
            return loss.sum()

        else:
            return loss

    def decodes(self, x): return x.argmax(dim=self.axis)
    def activation(self, x): return F.softmax(x, dim=self.axis)

# Cell
def load_kornia_loss(loss_name, alpha=0.5, beta=0.5, gamma=2.0, reduction='mean', eps = 1e-08):
    'Load segmentation_models_pytorch model'
    kornia = import_package('kornia')
    if loss_name=="DiceLoss": return kornia.losses.DiceLoss(eps=eps)
    elif loss_name=="TverskyLoss":
        return kornia.losses.TverskyLoss(alpha=alpha, beta=beta, eps=eps)
    elif loss_name=="FocalLoss":
        return kornia.losses.FocalLoss(alpha=alpha, gamma=gamma, reduction=reduction, eps=eps)
    else: raise NotImplementedError