# flake8: noqa
import json

with open('ether/tests/weth.abi.json', 'r') as f:
    weth_json = json.loads(f.read())

with open('ether/tests/rlptest.json', 'r') as f:
    rlp_json = json.loads(f.read())

with open('ether/tests/txns.json', 'r') as f:
    txn_json = json.loads(f.read())


weth_transfers = [
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0x8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925","0x000000000000000000000000009be56dd91808b2ab35959a65245732c73fe871","0x00000000000000000000000014fbca95be7e99c15cc2996c6c9d841e54b79425"],"data":"0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff","blockNumber":"0x488800","timeStamp":"0x5a377f15","gasPrice":"0x560de0700","gasUsed":"0xb848","logIndex":"0x2a","transactionHash":"0xb1b06122e812801972f70c899188e1ff0d61550f9b561188ec6b37c55da5014c","transactionIndex":"0x36"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0x8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925","0x000000000000000000000000004075e4d4b1ce6c48c81cc940e2bad24b489e64","0x00000000000000000000000014fbca95be7e99c15cc2996c6c9d841e54b79425"],"data":"0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff","blockNumber":"0x488818","timeStamp":"0x5a378054","gasPrice":"0x560de0700","gasUsed":"0xb848","logIndex":"0x56","transactionHash":"0x5c4db66455acdf8798a771bfa55c46a851b29b7176256ccf24f414190ceae35e","transactionIndex":"0x5f"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0x8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925","0x0000000000000000000000000005abcbb9533cf6f9370505ffef25393e0d2852","0x00000000000000000000000014fbca95be7e99c15cc2996c6c9d841e54b79425"],"data":"0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff","blockNumber":"0x488821","timeStamp":"0x5a3780d1","gasPrice":"0x560de0700","gasUsed":"0xb848","logIndex":"0x27","transactionHash":"0x9ef393c0e8cfa2dbb16970dab5427f19cac8439f807e3fcba89c9558e2fd9f70","transactionIndex":"0x4b"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0x8c5be1e5ebec7d5bd14f71427d1e84f3dd0314c0f7b2291e5b200ac8c7c3b925","0x000000000000000000000000002c6a9a3151094ec5109c61dbe89b3d1d39b17a","0x00000000000000000000000014fbca95be7e99c15cc2996c6c9d841e54b79425"],"data":"0xffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff","blockNumber":"0x488850","timeStamp":"0x5a3783f4","gasPrice":"0x560de0700","gasUsed":"0xb848","logIndex":"0x25","transactionHash":"0x45c19065bbb4b5cce4182064d7e06c13913af319d4569d7199719252394055d6","transactionIndex":"0x46"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0xe1fffcc4923d04b559f4d29a8bfc6cda04eb5b0d3c460751c2402c5c5cc9109c","0x000000000000000000000000009be56dd91808b2ab35959a65245732c73fe871"],"data":"0x0000000000000000000000000000000000000000000000000de0b6b3a7640000","blockNumber":"0x48885b","timeStamp":"0x5a378510","gasPrice":"0x4a817c800","gasUsed":"0xa952","logIndex":"0x68","transactionHash":"0x8e5a9e7b34e16e6ea1246c81b8bed123cac314ed378b5839fb72a157b8e9eed6","transactionIndex":"0x95"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0xe1fffcc4923d04b559f4d29a8bfc6cda04eb5b0d3c460751c2402c5c5cc9109c","0x000000000000000000000000009be56dd91808b2ab35959a65245732c73fe871"],"data":"0x0000000000000000000000000000000000000000000000007ce66c50e2840000","blockNumber":"0x488860","timeStamp":"0x5a37854f","gasPrice":"0x4a817c800","gasUsed":"0x6eba","logIndex":"0x1a","transactionHash":"0xccf78e2c6b071e274c8a128352bf7eec86c9bfb841fcf0348c523cfe6e980929","transactionIndex":"0x69"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef","0x000000000000000000000000009be56dd91808b2ab35959a65245732c73fe871","0x00000000000000000000000014fbca95be7e99c15cc2996c6c9d841e54b79425"],"data":"0x0000000000000000000000000000000000000000000000006f05b59d3b200000","blockNumber":"0x488862","timeStamp":"0x5a37856e","gasPrice":"0x560de0700","gasUsed":"0x3c940","logIndex":"0x19","transactionHash":"0xc43034342af7b7bca8da56524f2c360d02255ac16b4b9d57978b07c08199ff5a","transactionIndex":"0x29"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0xe1fffcc4923d04b559f4d29a8bfc6cda04eb5b0d3c460751c2402c5c5cc9109c","0x000000000000000000000000004075e4d4b1ce6c48c81cc940e2bad24b489e64"],"data":"0x0000000000000000000000000000000000000000000000015af1d78b58c40000","blockNumber":"0x488877","timeStamp":"0x5a378664","gasPrice":"0x4a817c800","gasUsed":"0xa952","logIndex":"0xce","transactionHash":"0x45c5532cee276c63bfbbda0ed25df7152cf7ec80fed32918d0bb6448aad22faa","transactionIndex":"0x13"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef","0x000000000000000000000000004075e4d4b1ce6c48c81cc940e2bad24b489e64","0x00000000000000000000000014fbca95be7e99c15cc2996c6c9d841e54b79425"],"data":"0x0000000000000000000000000000000000000000000000006f05b59d3b200000","blockNumber":"0x48887a","timeStamp":"0x5a3786a0","gasPrice":"0x560de0700","gasUsed":"0x38126","logIndex":"0x1c","transactionHash":"0x854b6f8a24ec48323847d9bb22d4c9fbe20705bc1ed242328d51caae57595f8f","transactionIndex":"0x2b"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0xe1fffcc4923d04b559f4d29a8bfc6cda04eb5b0d3c460751c2402c5c5cc9109c","0x0000000000000000000000000005abcbb9533cf6f9370505ffef25393e0d2852"],"data":"0x000000000000000000000000000000000000000000000000d02ab486cedc0000","blockNumber":"0x48887b","timeStamp":"0x5a3786a2","gasPrice":"0x4a817c800","gasUsed":"0xa952","logIndex":"0xcf","transactionHash":"0x92eb9d8054ae37dc7ccd48ae6e208e4751ba66b4ed5f0910f539d663bd976978","transactionIndex":"0x3a"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef","0x0000000000000000000000000005abcbb9533cf6f9370505ffef25393e0d2852","0x00000000000000000000000014fbca95be7e99c15cc2996c6c9d841e54b79425"],"data":"0x0000000000000000000000000000000000000000000000006f05b59d3b200000","blockNumber":"0x48887d","timeStamp":"0x5a3786de","gasPrice":"0x560de0700","gasUsed":"0x38126","logIndex":"0x10","transactionHash":"0x6c2bec8fe3efb06ceda8a0552dd43282529a147d0c6acafbb21c48a7bfa2a734","transactionIndex":"0x15"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef","0x00000000000000000000000014fbca95be7e99c15cc2996c6c9d841e54b79425","0x000000000000000000000000009be56dd91808b2ab35959a65245732c73fe871"],"data":"0x0000000000000000000000000000000000000000000000006f05b59d3b200000","blockNumber":"0x488882","timeStamp":"0x5a37872b","gasPrice":"0x51f4d5c00","gasUsed":"0xe7b0","logIndex":"0x1c","transactionHash":"0x87d6346258248fbc4e85559a119ceb26cb10f2d555a8d85149626242fa09c86c","transactionIndex":"0x2b"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef","0x000000000000000000000000009be56dd91808b2ab35959a65245732c73fe871","0x00000000000000000000000014fbca95be7e99c15cc2996c6c9d841e54b79425"],"data":"0x0000000000000000000000000000000000000000000000006f05b59d3b200000","blockNumber":"0x488887","timeStamp":"0x5a378768","gasPrice":"0x51f4d5c00","gasUsed":"0x38126","logIndex":"0x11","transactionHash":"0x5a45bd44b9566b6c2eb2ca1cd000b93468df917b8c9f5fac27f40b20fa175bf1","transactionIndex":"0x25"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef","0x00000000000000000000000014fbca95be7e99c15cc2996c6c9d841e54b79425","0x000000000000000000000000009be56dd91808b2ab35959a65245732c73fe871"],"data":"0x0000000000000000000000000000000000000000000000006f05b59d3b200000","blockNumber":"0x488938","timeStamp":"0x5a3790bb","gasPrice":"0x560de0700","gasUsed":"0xf37f","logIndex":"0x2e","transactionHash":"0xbe43afaca72375b7ba85f2a2f3544546d511ce8201195d315d6111512bb3b097","transactionIndex":"0x4c"},
    {"address":"0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2","topics":["0xddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef","0x000000000000000000000000009be56dd91808b2ab35959a65245732c73fe871","0x00000000000000000000000014fbca95be7e99c15cc2996c6c9d841e54b79425"],"data":"0x0000000000000000000000000000000000000000000000006f05b59d3b200000","blockNumber":"0x48893b","timeStamp":"0x5a379102","gasPrice":"0x560de0700","gasUsed":"0x3789b","logIndex":"0x19","transactionHash":"0xa21d3feb256236b7ad03a98ca8c5502065ec00a0d09c33e88a46e4b00a5c1f43","transactionIndex":"0x79"}
]

weth_parsed = [
    {'event_name': 'Approval', 'src': '0x009be56dd91808b2ab35959a65245732c73fe871', 'guy': '0x14fbca95be7e99c15cc2996c6c9d841e54b79425', 'wad': 115792089237316195423570985008687907853269984665640564039457584007913129639935},
    {'event_name': 'Approval', 'src': '0x004075e4d4b1ce6c48c81cc940e2bad24b489e64', 'guy': '0x14fbca95be7e99c15cc2996c6c9d841e54b79425', 'wad': 115792089237316195423570985008687907853269984665640564039457584007913129639935},
    {'event_name': 'Approval', 'src': '0x0005abcbb9533cf6f9370505ffef25393e0d2852', 'guy': '0x14fbca95be7e99c15cc2996c6c9d841e54b79425', 'wad': 115792089237316195423570985008687907853269984665640564039457584007913129639935},
    {'event_name': 'Approval', 'src': '0x002c6a9a3151094ec5109c61dbe89b3d1d39b17a', 'guy': '0x14fbca95be7e99c15cc2996c6c9d841e54b79425', 'wad': 115792089237316195423570985008687907853269984665640564039457584007913129639935},
    {'event_name': 'Deposit', 'dst': '0x009be56dd91808b2ab35959a65245732c73fe871', 'wad': 1000000000000000000},
    {'event_name': 'Deposit', 'dst': '0x009be56dd91808b2ab35959a65245732c73fe871', 'wad': 9000000000000000000},
    {'event_name': 'Transfer', 'src': '0x009be56dd91808b2ab35959a65245732c73fe871', 'dst': '0x14fbca95be7e99c15cc2996c6c9d841e54b79425', 'wad': 8000000000000000000},
    {'event_name': 'Deposit', 'dst': '0x004075e4d4b1ce6c48c81cc940e2bad24b489e64', 'wad': 25000000000000000000},
    {'event_name': 'Transfer', 'src': '0x004075e4d4b1ce6c48c81cc940e2bad24b489e64', 'dst': '0x14fbca95be7e99c15cc2996c6c9d841e54b79425', 'wad': 8000000000000000000},
    {'event_name': 'Deposit', 'dst': '0x0005abcbb9533cf6f9370505ffef25393e0d2852', 'wad': 15000000000000000000},
    {'event_name': 'Transfer', 'src': '0x0005abcbb9533cf6f9370505ffef25393e0d2852', 'dst': '0x14fbca95be7e99c15cc2996c6c9d841e54b79425', 'wad': 8000000000000000000},
    {'event_name': 'Transfer', 'src': '0x14fbca95be7e99c15cc2996c6c9d841e54b79425', 'dst': '0x009be56dd91808b2ab35959a65245732c73fe871', 'wad': 8000000000000000000},
    {'event_name': 'Transfer', 'src': '0x009be56dd91808b2ab35959a65245732c73fe871', 'dst': '0x14fbca95be7e99c15cc2996c6c9d841e54b79425', 'wad': 8000000000000000000},
    {'event_name': 'Transfer', 'src': '0x14fbca95be7e99c15cc2996c6c9d841e54b79425', 'dst': '0x009be56dd91808b2ab35959a65245732c73fe871', 'wad': 8000000000000000000},
    {'event_name': 'Transfer', 'src': '0x009be56dd91808b2ab35959a65245732c73fe871', 'dst': '0x14fbca95be7e99c15cc2996c6c9d841e54b79425', 'wad': 8000000000000000000}
]
