"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Default = void 0;
/**
 * (experimental) Provides default values for certain regional information points.
 *
 * @experimental
 */
class Default {
    constructor() { }
    /**
     * (experimental) Computes a "standard" AWS Service principal for a given service, region and suffix.
     *
     * This is useful for example when
     * you need to compute a service principal name, but you do not have a synthesize-time region literal available (so
     * all you have is `{ "Ref": "AWS::Region" }`). This way you get the same defaulting behavior that is normally used
     * for built-in data.
     *
     * @param service the name of the service (s3, s3.amazonaws.com, ...).
     * @param region the region in which the service principal is needed.
     * @param urlSuffix the URL suffix for the partition in which the region is located.
     * @experimental
     */
    static servicePrincipal(service, region, urlSuffix) {
        const matches = service.match(/^([^.]+)(?:(?:\.amazonaws\.com(?:\.cn)?)|(?:\.c2s\.ic\.gov)|(?:\.sc2s\.sgov\.gov))?$/);
        if (!matches) {
            // Return "service" if it does not look like any of the following:
            // - s3
            // - s3.amazonaws.com
            // - s3.amazonaws.com.cn
            // - s3.c2s.ic.gov
            // - s3.sc2s.sgov.gov
            return service;
        }
        service = matches[1]; // Simplify the service name down to something like "s3"
        // Exceptions for Service Principals in us-iso-*
        const US_ISO_EXCEPTIONS = new Set([
            'cloudhsm',
            'config',
            'states',
            'workspaces',
        ]);
        // Exceptions for Service Principals in us-isob-*
        const US_ISOB_EXCEPTIONS = new Set([
            'dms',
            'states',
        ]);
        // Account for idiosyncratic Service Principals in `us-iso-*` regions
        if (region.startsWith('us-iso-') && US_ISO_EXCEPTIONS.has(service)) {
            switch (service) {
                // Services with universal principal
                case ('states'):
                    return `${service}.amazonaws.com`;
                // Services with a partitional principal
                default:
                    return `${service}.${urlSuffix}`;
            }
        }
        // Account for idiosyncratic Service Principals in `us-isob-*` regions
        if (region.startsWith('us-isob-') && US_ISOB_EXCEPTIONS.has(service)) {
            switch (service) {
                // Services with universal principal
                case ('states'):
                    return `${service}.amazonaws.com`;
                // Services with a partitional principal
                default:
                    return `${service}.${urlSuffix}`;
            }
        }
        switch (service) {
            // Services with a regional AND partitional principal
            case 'codedeploy':
            case 'logs':
                return `${service}.${region}.${urlSuffix}`;
            // Services with a regional principal
            case 'states':
                return `${service}.${region}.amazonaws.com`;
            // Services with a partitional principal
            case 'ec2':
                return `${service}.${urlSuffix}`;
            // Services with a universal principal across all regions/partitions (the default case)
            default:
                return `${service}.amazonaws.com`;
        }
    }
}
exports.Default = Default;
/**
 * (experimental) The default value for a VPC Endpoint Service name prefix, useful if you do not have a synthesize-time region literal available (all you have is `{ "Ref": "AWS::Region" }`).
 *
 * @experimental
 */
Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX = 'com.amazonaws.vpce';
//# sourceMappingURL=data:application/json;base64,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