import * as codebuild from "../../../aws-codebuild";
import * as codepipeline from "../../../aws-codepipeline";
import * as ec2 from "../../../aws-ec2";
import * as events from "../../../aws-events";
import * as iam from "../../../aws-iam";
import { Construct } from "../../../core";
import { StackOutput } from '../stage';
/**
 * (experimental) Properties for ShellScriptAction.
 *
 * @experimental
 */
export interface ShellScriptActionProps {
    /**
     * (experimental) Name of the validation action in the pipeline.
     *
     * @experimental
     */
    readonly actionName: string;
    /**
     * (experimental) Stack outputs to make available as environment variables.
     *
     * @default - No outputs used
     * @experimental
     */
    readonly useOutputs?: Record<string, StackOutput>;
    /**
     * (experimental) Commands to run.
     *
     * @experimental
     */
    readonly commands: string[];
    /**
     * (experimental) Bash options to set at the start of the script.
     *
     * @default '-eu' (errexit and nounset)
     * @experimental
     */
    readonly bashOptions?: string;
    /**
     * (experimental) Additional artifacts to use as input for the CodeBuild project.
     *
     * You can use these files to load more complex test sets into the
     * shellscript build environment.
     *
     * The files artifact given here will be unpacked into the current
     * working directory, the other ones will be unpacked into directories
     * which are available through the environment variables
     * $CODEBUILD_SRC_DIR_<artifactName>.
     *
     * The CodeBuild job must have at least one input artifact, so you
     * must provide either at least one additional artifact here or one
     * stack output using `useOutput`.
     *
     * @default - No additional artifacts
     * @experimental
     */
    readonly additionalArtifacts?: codepipeline.Artifact[];
    /**
     * (experimental) RunOrder for this action.
     *
     * Use this to sequence the shell script after the deployments.
     *
     * The default value is 100 so you don't have to supply the value if you just
     * want to run this after the application stacks have been deployed, and you
     * don't have more than 100 stacks.
     *
     * @default 100
     * @experimental
     */
    readonly runOrder?: number;
    /**
     * (experimental) Additional policy statements to add to the execution role.
     *
     * @default - No policy statements
     * @experimental
     */
    readonly rolePolicyStatements?: iam.PolicyStatement[];
    /**
     * (experimental) The VPC where to execute the specified script.
     *
     * @default - No VPC
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Which subnets to use.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - All private subnets.
     * @experimental
     */
    readonly subnetSelection?: ec2.SubnetSelection;
}
/**
 * (experimental) Validate a revision using shell commands.
 *
 * @experimental
 */
export declare class ShellScriptAction implements codepipeline.IAction, iam.IGrantable {
    private readonly props;
    private _project?;
    private _action?;
    private _actionProperties;
    /**
     * @experimental
     */
    constructor(props: ShellScriptActionProps);
    /**
     * (experimental) The CodeBuild Project's principal.
     *
     * @experimental
     */
    get grantPrincipal(): iam.IPrincipal;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties(): codepipeline.ActionProperties;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * (experimental) Project generated to run the shell script in.
     *
     * @experimental
     */
    get project(): codebuild.IProject;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
}
