import * as codepipeline from "../../aws-codepipeline";
import * as ec2 from "../../aws-ec2";
import { CfnOutput, Stage } from "../../core";
import { Construct } from 'constructs';
import { AddStageOptions, CdkStage, StackOutput } from './stage';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Properties for a CdkPipeline.
 *
 * @experimental
 */
export interface CdkPipelineProps {
    /**
     * (experimental) The CodePipeline action used to retrieve the CDK app's source.
     *
     * @default - Required unless `codePipeline` is given
     * @experimental
     */
    readonly sourceAction?: codepipeline.IAction;
    /**
     * (experimental) The CodePipeline action build and synthesis step of the CDK app.
     *
     * @default - Required unless `codePipeline` or `sourceAction` is given
     * @experimental
     */
    readonly synthAction?: codepipeline.IAction;
    /**
     * (experimental) The artifact you have defined to be the artifact to hold the cloudAssemblyArtifact for the synth action.
     *
     * @experimental
     */
    readonly cloudAssemblyArtifact: codepipeline.Artifact;
    /**
     * (experimental) Existing CodePipeline to add deployment stages to.
     *
     * Use this if you want more control over the CodePipeline that gets created.
     * You can choose to not pass this value, in which case a new CodePipeline is
     * created with default settings.
     *
     * If you pass an existing CodePipeline, it should should have been created
     * with `restartExecutionOnUpdate: true`.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @default - A new CodePipeline is automatically generated
     * @experimental
     */
    readonly codePipeline?: codepipeline.Pipeline;
    /**
     * (experimental) Name of the pipeline.
     *
     * Can only be set if `codePipeline` is not set.
     *
     * @default - A name is automatically generated
     * @experimental
     */
    readonly pipelineName?: string;
    /**
     * (experimental) Create KMS keys for cross-account deployments.
     *
     * This controls whether the pipeline is enabled for cross-account deployments.
     *
     * Can only be set if `codePipeline` is not set.
     *
     * By default cross-account deployments are enabled, but this feature requires
     * that KMS Customer Master Keys are created which have a cost of $1/month.
     *
     * If you do not need cross-account deployments, you can set this to `false` to
     * not create those keys and save on that cost (the artifact bucket will be
     * encrypted with an AWS-managed key). However, cross-account deployments will
     * no longer be possible.
     *
     * @default true
     * @experimental
     */
    readonly crossAccountKeys?: boolean;
    /**
     * (experimental) CDK CLI version to use in pipeline.
     *
     * Some Actions in the pipeline will download and run a version of the CDK
     * CLI. Specify the version here.
     *
     * @default - Latest version
     * @experimental
     */
    readonly cdkCliVersion?: string;
    /**
     * (experimental) The VPC where to execute the CdkPipeline actions.
     *
     * @default - No VPC
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) Which subnets to use.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - All private subnets.
     * @experimental
     */
    readonly subnetSelection?: ec2.SubnetSelection;
}
/**
 * (experimental) A Pipeline to deploy CDK apps.
 *
 * Defines an AWS CodePipeline-based Pipeline to deploy CDK applications.
 *
 * Automatically manages the following:
 *
 * - Stack dependency order.
 * - Asset publishing.
 * - Keeping the pipeline up-to-date as the CDK apps change.
 * - Using stack outputs later on in the pipeline.
 *
 * @experimental
 */
export declare class CdkPipeline extends CoreConstruct {
    private readonly _pipeline;
    private readonly _assets;
    private readonly _stages;
    private readonly _outputArtifacts;
    private readonly _cloudAssemblyArtifact;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CdkPipelineProps);
    /**
     * (experimental) The underlying CodePipeline object.
     *
     * You can use this to add more Stages to the pipeline, or Actions
     * to Stages.
     *
     * @experimental
     */
    get codePipeline(): codepipeline.Pipeline;
    /**
     * (experimental) Access one of the pipeline's stages by stage name.
     *
     * You can use this to add more Actions to a stage.
     *
     * @experimental
     */
    stage(stageName: string): codepipeline.IStage;
    /**
     * (experimental) Add pipeline stage that will deploy the given application stage.
     *
     * The application construct should subclass `Stage` and can contain any
     * number of `Stacks` inside it that may have dependency relationships
     * on one another.
     *
     * All stacks in the application will be deployed in the appropriate order,
     * and all assets found in the application will be added to the asset
     * publishing stage.
     *
     * @experimental
     */
    addApplicationStage(appStage: Stage, options?: AddStageOptions): CdkStage;
    /**
     * (experimental) Add a new, empty stage to the pipeline.
     *
     * Prefer to use `addApplicationStage` if you are intended to deploy a CDK
     * application, but you can use this method if you want to add other kinds of
     * Actions to a pipeline.
     *
     * @experimental
     */
    addStage(stageName: string): CdkStage;
    /**
     * (experimental) Get the StackOutput object that holds this CfnOutput's value in this pipeline.
     *
     * `StackOutput` can be used in validation actions later in the pipeline.
     *
     * @experimental
     */
    stackOutput(cfnOutput: CfnOutput): StackOutput;
    /**
     * (experimental) Validate that we don't have any stacks violating dependency order in the pipeline.
     *
     * Our own convenience methods will never generate a pipeline that does that (although
     * this is a nice verification), but a user can also add the stacks by hand.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * Return all StackDeployActions in an ordered list
     */
    private get stackActions();
    private validateDeployOrder;
    private validateRequestedOutputs;
}
