import * as codepipeline from "../../../aws-codepipeline";
import * as events from "../../../aws-events";
import { Construct } from 'constructs';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) Props for the UpdatePipelineAction.
 *
 * @experimental
 */
export interface UpdatePipelineActionProps {
    /**
     * (experimental) The CodePipeline artifact that holds the Cloud Assembly.
     *
     * @experimental
     */
    readonly cloudAssemblyInput: codepipeline.Artifact;
    /**
     * (experimental) Name of the pipeline stack.
     *
     * @experimental
     */
    readonly pipelineStackName: string;
    /**
     * (experimental) Version of CDK CLI to 'npm install'.
     *
     * @default - Latest version
     * @experimental
     */
    readonly cdkCliVersion?: string;
    /**
     * (experimental) Name of the CodeBuild project.
     *
     * @default - Automatically generated
     * @experimental
     */
    readonly projectName?: string;
}
/**
 * (experimental) Action to self-mutate the pipeline.
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to deploy the pipeline stack.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline.
 *
 * @experimental
 */
export declare class UpdatePipelineAction extends CoreConstruct implements codepipeline.IAction {
    private readonly action;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UpdatePipelineActionProps);
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    bind(scope: CoreConstruct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
    /**
     * (experimental) Exists to implement IAction.
     *
     * @experimental
     */
    get actionProperties(): codepipeline.ActionProperties;
}
