"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentUtils = exports.UNKNOWN_REGION = exports.UNKNOWN_ACCOUNT = void 0;
/**
 * Parser for the artifact environment field.
 *
 * Account validation is relaxed to allow account aliasing in the future.
 */
const AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
exports.UNKNOWN_ACCOUNT = 'unknown-account';
exports.UNKNOWN_REGION = 'unknown-region';
/**
 * @experimental
 */
class EnvironmentUtils {
    /**
     * @experimental
     */
    static parse(environment) {
        const env = AWS_ENV_REGEX.exec(environment);
        if (!env) {
            throw new Error(`Unable to parse environment specification "${environment}". ` +
                'Expected format: aws://account/region');
        }
        const [, account, region] = env;
        if (!account || !region) {
            throw new Error(`Invalid environment specification: ${environment}`);
        }
        return { account, region, name: environment };
    }
    /**
     * (experimental) Build an environment object from an account and region.
     *
     * @experimental
     */
    static make(account, region) {
        return { account, region, name: this.format(account, region) };
    }
    /**
     * (experimental) Format an environment string from an account and region.
     *
     * @experimental
     */
    static format(account, region) {
        return `aws://${account}/${region}`;
    }
}
exports.EnvironmentUtils = EnvironmentUtils;
//# sourceMappingURL=data:application/json;base64,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