/**
 * (experimental) Models an AWS execution environment, for use within the CDK toolkit.
 *
 * @experimental
 */
export interface Environment {
    /**
     * (experimental) The arbitrary name of this environment (user-set, or at least user-meaningful).
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The AWS account this environment deploys into.
     *
     * @experimental
     */
    readonly account: string;
    /**
     * (experimental) The AWS region name where this environment deploys into.
     *
     * @experimental
     */
    readonly region: string;
}
export declare const UNKNOWN_ACCOUNT = "unknown-account";
export declare const UNKNOWN_REGION = "unknown-region";
/**
 * @experimental
 */
export declare class EnvironmentUtils {
    /**
     * @experimental
     */
    static parse(environment: string): Environment;
    /**
     * (experimental) Build an environment object from an account and region.
     *
     * @experimental
     */
    static make(account: string, region: string): Environment;
    /**
     * (experimental) Format an environment string from an account and region.
     *
     * @experimental
     */
    static format(account: string, region: string): string;
}
