/**
 * (experimental) The type of subnet group.
 *
 * Same as SubnetType in the @aws-cdk/aws-ec2 package,
 * but we can't use that because of cyclical dependencies.
 *
 * @experimental
 */
export declare enum VpcSubnetGroupType {
    /**
     * (experimental) Public subnet group type.
     *
     * @experimental
     */
    PUBLIC = "Public",
    /**
     * (experimental) Private subnet group type.
     *
     * @experimental
     */
    PRIVATE = "Private",
    /**
     * (experimental) Isolated subnet group type.
     *
     * @experimental
     */
    ISOLATED = "Isolated"
}
/**
 * (experimental) A subnet representation that the VPC provider uses.
 *
 * @experimental
 */
export interface VpcSubnet {
    /**
     * (experimental) The identifier of the subnet.
     *
     * @experimental
     */
    readonly subnetId: string;
    /**
     * (experimental) The code of the availability zone this subnet is in (for example, 'us-west-2a').
     *
     * @experimental
     */
    readonly availabilityZone: string;
    /**
     * (experimental) The identifier of the route table for this subnet.
     *
     * @experimental
     */
    readonly routeTableId: string;
    /**
     * (experimental) CIDR range of the subnet.
     *
     * @default - CIDR information not available
     * @experimental
     */
    readonly cidr?: string;
}
/**
 * (experimental) A group of subnets returned by the VPC provider.
 *
 * The included subnets do NOT have to be symmetric!
 *
 * @experimental
 */
export interface VpcSubnetGroup {
    /**
     * (experimental) The name of the subnet group, determined by looking at the tags of of the subnets that belong to it.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The type of the subnet group.
     *
     * @experimental
     */
    readonly type: VpcSubnetGroupType;
    /**
     * (experimental) The subnets that are part of this group.
     *
     * There is no condition that the subnets have to be symmetric
     * in the group.
     *
     * @experimental
     */
    readonly subnets: VpcSubnet[];
}
/**
 * (experimental) Properties of a discovered VPC.
 *
 * @experimental
 */
export interface VpcContextResponse {
    /**
     * (experimental) VPC id.
     *
     * @experimental
     */
    readonly vpcId: string;
    /**
     * (experimental) VPC cidr.
     *
     * @default - CIDR information not available
     * @experimental
     */
    readonly vpcCidrBlock?: string;
    /**
     * (experimental) AZs.
     *
     * @experimental
     */
    readonly availabilityZones: string[];
    /**
     * (experimental) IDs of all public subnets.
     *
     * Element count: #(availabilityZones) · #(publicGroups)
     *
     * @experimental
     */
    readonly publicSubnetIds?: string[];
    /**
     * (experimental) Name of public subnet groups.
     *
     * Element count: #(publicGroups)
     *
     * @experimental
     */
    readonly publicSubnetNames?: string[];
    /**
     * (experimental) Route Table IDs of public subnet groups.
     *
     * Element count: #(availabilityZones) · #(publicGroups)
     *
     * @experimental
     */
    readonly publicSubnetRouteTableIds?: string[];
    /**
     * (experimental) IDs of all private subnets.
     *
     * Element count: #(availabilityZones) · #(privateGroups)
     *
     * @experimental
     */
    readonly privateSubnetIds?: string[];
    /**
     * (experimental) Name of private subnet groups.
     *
     * Element count: #(privateGroups)
     *
     * @experimental
     */
    readonly privateSubnetNames?: string[];
    /**
     * (experimental) Route Table IDs of private subnet groups.
     *
     * Element count: #(availabilityZones) · #(privateGroups)
     *
     * @experimental
     */
    readonly privateSubnetRouteTableIds?: string[];
    /**
     * (experimental) IDs of all isolated subnets.
     *
     * Element count: #(availabilityZones) · #(isolatedGroups)
     *
     * @experimental
     */
    readonly isolatedSubnetIds?: string[];
    /**
     * (experimental) Name of isolated subnet groups.
     *
     * Element count: #(isolatedGroups)
     *
     * @experimental
     */
    readonly isolatedSubnetNames?: string[];
    /**
     * (experimental) Route Table IDs of isolated subnet groups.
     *
     * Element count: #(availabilityZones) · #(isolatedGroups)
     *
     * @experimental
     */
    readonly isolatedSubnetRouteTableIds?: string[];
    /**
     * (experimental) The VPN gateway ID.
     *
     * @experimental
     */
    readonly vpnGatewayId?: string;
    /**
     * (experimental) The subnet groups discovered for the given VPC.
     *
     * Unlike the above properties, this will include asymmetric subnets,
     * if the VPC has any.
     * This property will only be populated if {@link VpcContextQuery.returnAsymmetricSubnets}
     * is true.
     *
     * @default - no subnet groups will be returned unless {@link VpcContextQuery.returnAsymmetricSubnets} is true
     * @experimental
     */
    readonly subnetGroups?: VpcSubnetGroup[];
}
