"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NestedCloudAssemblyArtifact = void 0;
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
const cloud_assembly_1 = require("../cloud-assembly");
/**
 * (experimental) Asset manifest is a description of a set of assets which need to be built and published.
 *
 * @experimental
 */
class NestedCloudAssemblyArtifact extends cloud_artifact_1.CloudArtifact {
    /**
     * @experimental
     */
    constructor(assembly, name, artifact) {
        var _a;
        super(assembly, name, artifact);
        const properties = (this.manifest.properties || {});
        this.directoryName = properties.directoryName;
        this.displayName = (_a = properties.displayName) !== null && _a !== void 0 ? _a : name;
    }
    /**
     * (experimental) Full path to the nested assembly directory.
     *
     * @experimental
     */
    get fullPath() {
        return path.join(this.assembly.directory, this.directoryName);
    }
    /**
     * (experimental) The nested Assembly.
     *
     * @experimental
     */
    get nestedAssembly() {
        if (!this._nestedAssembly) {
            this._nestedAssembly = new cloud_assembly_1.CloudAssembly(this.fullPath);
        }
        return this._nestedAssembly;
    }
}
exports.NestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact;
//# sourceMappingURL=data:application/json;base64,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