import * as iam from "../../../aws-iam";
import * as logs from "../../../aws-logs";
import * as cdk from "../../../core";
import { Construct } from 'constructs';
/**
 * AWS SDK service metadata.
 */
export declare type AwsSdkMetadata = {
    [key: string]: any;
};
/**
 * (experimental) Reference to the physical resource id that can be passed to the AWS operation as a parameter.
 *
 * @experimental
 */
export declare class PhysicalResourceIdReference {
    /**
     * (experimental) toJSON serialization to replace `PhysicalResourceIdReference` with a magic string.
     *
     * @experimental
     */
    toJSON(): string;
}
/**
 * (experimental) Physical ID of the custom resource.
 *
 * @experimental
 */
export declare class PhysicalResourceId {
    readonly responsePath?: string | undefined;
    readonly id?: string | undefined;
    /**
     * (experimental) Extract the physical resource id from the path (dot notation) to the data in the API call response.
     *
     * @experimental
     */
    static fromResponse(responsePath: string): PhysicalResourceId;
    /**
     * (experimental) Explicit physical resource id.
     *
     * @experimental
     */
    static of(id: string): PhysicalResourceId;
    /**
     * @param responsePath Path to a response data element to be used as the physical id.
     * @param id Literal string to be used as the physical id.
     */
    private constructor();
}
/**
 * (experimental) An AWS SDK call.
 *
 * @experimental
 */
export interface AwsSdkCall {
    /**
     * (experimental) The service to call.
     *
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     * @experimental
     */
    readonly service: string;
    /**
     * (experimental) The service action to call.
     *
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     * @experimental
     */
    readonly action: string;
    /**
     * (experimental) The parameters for the service action.
     *
     * @default - no parameters
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html
     * @experimental
     */
    readonly parameters?: any;
    /**
     * (experimental) The physical resource id of the custom resource for this call.
     *
     * Mandatory for onCreate or onUpdate calls.
     *
     * @default - no physical resource id
     * @experimental
     */
    readonly physicalResourceId?: PhysicalResourceId;
    /**
     * (experimental) The regex pattern to use to catch API errors.
     *
     * The `code` property of the
     * `Error` object will be tested against this pattern. If there is a match an
     * error will not be thrown.
     *
     * @default - do not catch errors
     * @experimental
     */
    readonly ignoreErrorCodesMatching?: string;
    /**
     * (experimental) API version to use for the service.
     *
     * @default - use latest available API version
     * @see https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/locking-api-versions.html
     * @experimental
     */
    readonly apiVersion?: string;
    /**
     * (experimental) The region to send service requests to.
     *
     * **Note: Cross-region operations are generally considered an anti-pattern.**
     * **Consider first deploying a stack in that region.**
     *
     * @default - the region where this custom resource is deployed
     * @experimental
     */
    readonly region?: string;
    /**
     * (experimental) Restrict the data returned by the custom resource to a specific path in the API response.
     *
     * Use this to limit the data returned by the custom
     * resource if working with API calls that could potentially result in custom
     * response objects exceeding the hard limit of 4096 bytes.
     *
     * Example for ECS / updateService: 'service.deploymentConfiguration.maximumPercent'
     *
     * @default - return all data
     * @experimental
     */
    readonly outputPath?: string;
}
/**
 * (experimental) Options for the auto-generation of policies based on the configured SDK calls.
 *
 * @experimental
 */
export interface SdkCallsPolicyOptions {
    /**
     * (experimental) The resources that the calls will have access to.
     *
     * It is best to use specific resource ARN's when possible. However, you can also use `AwsCustomResourcePolicy.ANY_RESOURCE`
     * to allow access to all resources. For example, when `onCreate` is used to create a resource which you don't
     * know the physical name of in advance.
     *
     * Note that will apply to ALL SDK calls.
     *
     * @experimental
     */
    readonly resources: string[];
}
/**
 * (experimental) The IAM Policy that will be applied to the different calls.
 *
 * @experimental
 */
export declare class AwsCustomResourcePolicy {
    readonly statements: iam.PolicyStatement[];
    readonly resources?: string[] | undefined;
    /**
     * (experimental) Use this constant to configure access to any resource.
     *
     * @experimental
     */
    static readonly ANY_RESOURCE: string[];
    /**
     * (experimental) Explicit IAM Policy Statements.
     *
     * @param statements the statements to propagate to the SDK calls.
     * @experimental
     */
    static fromStatements(statements: iam.PolicyStatement[]): AwsCustomResourcePolicy;
    /**
     * (experimental) Generate IAM Policy Statements from the configured SDK calls.
     *
     * Each SDK call with be translated to an IAM Policy Statement in the form of: `call.service:call.action` (e.g `s3:PutObject`).
     *
     * @param options options for the policy generation.
     * @experimental
     */
    static fromSdkCalls(options: SdkCallsPolicyOptions): AwsCustomResourcePolicy;
    /**
     * @param statements statements for explicit policy.
     * @param resources resources for auto-generated from SDK calls.
     */
    private constructor();
}
/**
 * (experimental) Properties for AwsCustomResource.
 *
 * Note that at least onCreate, onUpdate or onDelete must be specified.
 *
 * @experimental
 */
export interface AwsCustomResourceProps {
    /**
     * (experimental) Cloudformation Resource type.
     *
     * @default - Custom::AWS
     * @experimental
     */
    readonly resourceType?: string;
    /**
     * (experimental) The AWS SDK call to make when the resource is created.
     *
     * @default - the call when the resource is updated
     * @experimental
     */
    readonly onCreate?: AwsSdkCall;
    /**
     * (experimental) The AWS SDK call to make when the resource is updated.
     *
     * @default - no call
     * @experimental
     */
    readonly onUpdate?: AwsSdkCall;
    /**
     * (experimental) The AWS SDK call to make when the resource is deleted.
     *
     * @default - no call
     * @experimental
     */
    readonly onDelete?: AwsSdkCall;
    /**
     * (experimental) The policy that will be added to the execution role of the Lambda function implementing this custom resource provider.
     *
     * The custom resource also implements `iam.IGrantable`, making it possible
     * to use the `grantXxx()` methods.
     *
     * As this custom resource uses a singleton Lambda function, it's important
     * to note the that function's role will eventually accumulate the
     * permissions/grants from all resources.
     *
     * @see Policy.fromSdkCalls
     * @experimental
     */
    readonly policy: AwsCustomResourcePolicy;
    /**
     * (experimental) The execution role for the Lambda function implementing this custom resource provider.
     *
     * This role will apply to all `AwsCustomResource`
     * instances in the stack. The role must be assumable by the
     * `lambda.amazonaws.com` service principal.
     *
     * @default - a new role is created
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The timeout for the Lambda function implementing this custom resource.
     *
     * @default Duration.minutes(2)
     * @experimental
     */
    readonly timeout?: cdk.Duration;
    /**
     * (experimental) The number of days log events of the Lambda function implementing this custom resource are kept in CloudWatch Logs.
     *
     * @default logs.RetentionDays.INFINITE
     * @experimental
     */
    readonly logRetention?: logs.RetentionDays;
    /**
     * (experimental) Whether to install the latest AWS SDK v2. Allows to use the latest API calls documented at https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html.
     *
     * The installation takes around 60 seconds.
     *
     * @default true
     * @experimental
     */
    readonly installLatestAwsSdk?: boolean;
    /**
     * (experimental) A name for the Lambda function implementing this custom resource.
     *
     * @default - AWS CloudFormation generates a unique physical ID and uses that
     * ID for the function's name. For more information, see Name Type.
     * @experimental
     */
    readonly functionName?: string;
}
/**
 * (experimental) Defines a custom resource that is materialized using specific AWS API calls.
 *
 * Use this to bridge any gap that might exist in the CloudFormation Coverage.
 * You can specify exactly which calls are invoked for the 'CREATE', 'UPDATE' and 'DELETE' life cycle events.
 *
 * @experimental
 */
export declare class AwsCustomResource extends cdk.Construct implements iam.IGrantable {
    private static breakIgnoreErrorsCircuit;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: iam.IPrincipal;
    private readonly customResource;
    private readonly props;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AwsCustomResourceProps);
    /**
     * (experimental) Returns response data for the AWS SDK call.
     *
     * Example for S3 / listBucket : 'Buckets.0.Name'
     *
     * Use `Token.asXxx` to encode the returned `Reference` as a specific type or
     * use the convenience `getDataString` for string attributes.
     *
     * Note that you cannot use this method if `ignoreErrorCodesMatching`
     * is configured for any of the SDK calls. This is because in such a case,
     * the response data might not exist, and will cause a CloudFormation deploy time error.
     *
     * @param dataPath the path to the data.
     * @experimental
     */
    getResponseFieldReference(dataPath: string): cdk.Reference;
    /**
     * (experimental) Returns response data for the AWS SDK call as string.
     *
     * Example for S3 / listBucket : 'Buckets.0.Name'
     *
     * Note that you cannot use this method if `ignoreErrorCodesMatching`
     * is configured for any of the SDK calls. This is because in such a case,
     * the response data might not exist, and will cause a CloudFormation deploy time error.
     *
     * @param dataPath the path to the data.
     * @experimental
     */
    getResponseField(dataPath: string): string;
}
