/**
 * (experimental) Inspector that maintains an attribute bag.
 *
 * @experimental
 */
export declare class TreeInspector {
    /**
     * (experimental) Represents the bag of attributes as key-value pairs.
     *
     * @experimental
     */
    readonly attributes: {
        [key: string]: any;
    };
    /**
     * (experimental) Adds attribute to bag.
     *
     * Keys should be added by convention to prevent conflicts
     * i.e. L1 constructs will contain attributes with keys prefixed with aws:cdk:cloudformation
     *
     * @param key - key for metadata.
     * @param value - value of metadata.
     * @experimental
     */
    addAttribute(key: string, value: any): void;
}
/**
 * (experimental) Interface for examining a construct and exposing metadata.
 *
 * @experimental
 */
export interface IInspectable {
    /**
     * (experimental) Examines construct.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: TreeInspector): void;
}
