import { DockerImageAssetLocation, DockerImageAssetSource, FileAssetLocation, FileAssetSource } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { Stack } from '../stack';
import { StackSynthesizer } from './stack-synthesizer';
export declare const BOOTSTRAP_QUALIFIER_CONTEXT = "@aws-cdk/core:bootstrapQualifier";
/**
 * (experimental) Configuration properties for DefaultStackSynthesizer.
 *
 * @experimental
 */
export interface DefaultStackSynthesizerProps {
    /**
     * (experimental) Name of the S3 bucket to hold file assets.
     *
     * You must supply this if you have given a non-standard name to the staging bucket.
     *
     * The placeholders `${Qualifier}`, `${AWS::AccountId}` and `${AWS::Region}` will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     *
     * @default DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME
     * @experimental
     */
    readonly fileAssetsBucketName?: string;
    /**
     * (experimental) Name of the ECR repository to hold Docker Image assets.
     *
     * You must supply this if you have given a non-standard name to the ECR repository.
     *
     * The placeholders `${Qualifier}`, `${AWS::AccountId}` and `${AWS::Region}` will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     *
     * @default DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME
     * @experimental
     */
    readonly imageAssetsRepositoryName?: string;
    /**
     * (experimental) The role to use to publish file assets to the S3 bucket in this environment.
     *
     * You must supply this if you have given a non-standard name to the publishing role.
     *
     * The placeholders `${Qualifier}`, `${AWS::AccountId}` and `${AWS::Region}` will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     *
     * @default DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN
     * @experimental
     */
    readonly fileAssetPublishingRoleArn?: string;
    /**
     * (experimental) External ID to use when assuming role for file asset publishing.
     *
     * @default - No external ID
     * @experimental
     */
    readonly fileAssetPublishingExternalId?: string;
    /**
     * (experimental) The role to use to publish image assets to the ECR repository in this environment.
     *
     * You must supply this if you have given a non-standard name to the publishing role.
     *
     * The placeholders `${Qualifier}`, `${AWS::AccountId}` and `${AWS::Region}` will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     *
     * @default DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN
     * @experimental
     */
    readonly imageAssetPublishingRoleArn?: string;
    /**
     * (experimental) External ID to use when assuming role for image asset publishing.
     *
     * @default - No external ID
     * @experimental
     */
    readonly imageAssetPublishingExternalId?: string;
    /**
     * (experimental) The role to assume to initiate a deployment in this environment.
     *
     * You must supply this if you have given a non-standard name to the publishing role.
     *
     * The placeholders `${Qualifier}`, `${AWS::AccountId}` and `${AWS::Region}` will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     *
     * @default DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN
     * @experimental
     */
    readonly deployRoleArn?: string;
    /**
     * (experimental) The role CloudFormation will assume when deploying the Stack.
     *
     * You must supply this if you have given a non-standard name to the execution role.
     *
     * The placeholders `${Qualifier}`, `${AWS::AccountId}` and `${AWS::Region}` will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     *
     * @default DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN
     * @experimental
     */
    readonly cloudFormationExecutionRole?: string;
    /**
     * (deprecated) Name of the CloudFormation Export with the asset key name.
     *
     * You must supply this if you have given a non-standard name to the KMS key export
     *
     * The placeholders `${Qualifier}`, `${AWS::AccountId}` and `${AWS::Region}` will
     * be replaced with the values of qualifier and the stack's account and region,
     * respectively.
     *
     * @default DefaultStackSynthesizer.DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME
     * @deprecated This property is not used anymore
     */
    readonly fileAssetKeyArnExportName?: string;
    /**
     * (experimental) Qualifier to disambiguate multiple environments in the same account.
     *
     * You can use this and leave the other naming properties empty if you have deployed
     * the bootstrap environment with standard names but only differnet qualifiers.
     *
     * @default - Value of context key '
     * @experimental
     * @aws-cdk /core:bootstrapQualifier' if set, otherwise `DefaultStackSynthesizer.DEFAULT_QUALIFIER`
     */
    readonly qualifier?: string;
    /**
     * (experimental) Whether to add a Rule to the stack template verifying the bootstrap stack version.
     *
     * This generally should be left set to `true`, unless you explicitly
     * want to be able to deploy to an unbootstrapped environment.
     *
     * @default true
     * @experimental
     */
    readonly generateBootstrapVersionRule?: boolean;
}
/**
 * (experimental) Uses conventionally named roles and reify asset storage locations.
 *
 * This synthesizer is the only StackSynthesizer that generates
 * an asset manifest, and is required to deploy CDK applications using the
 * `@aws-cdk/app-delivery` CI/CD library.
 *
 * Requires the environment to have been bootstrapped with Bootstrap Stack V2.
 *
 * @experimental
 */
export declare class DefaultStackSynthesizer extends StackSynthesizer {
    private readonly props;
    /**
     * (experimental) Default ARN qualifier.
     *
     * @experimental
     */
    static readonly DEFAULT_QUALIFIER = "hnb659fds";
    /**
     * (experimental) Default CloudFormation role ARN.
     *
     * @experimental
     */
    static readonly DEFAULT_CLOUDFORMATION_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-cfn-exec-role-${AWS::AccountId}-${AWS::Region}";
    /**
     * (experimental) Default deploy role ARN.
     *
     * @experimental
     */
    static readonly DEFAULT_DEPLOY_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-deploy-role-${AWS::AccountId}-${AWS::Region}";
    /**
     * (experimental) Default asset publishing role ARN for file (S3) assets.
     *
     * @experimental
     */
    static readonly DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-file-publishing-role-${AWS::AccountId}-${AWS::Region}";
    /**
     * (experimental) Default asset publishing role ARN for image (ECR) assets.
     *
     * @experimental
     */
    static readonly DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-image-publishing-role-${AWS::AccountId}-${AWS::Region}";
    /**
     * (experimental) Default image assets repository name.
     *
     * @experimental
     */
    static readonly DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME = "cdk-${Qualifier}-container-assets-${AWS::AccountId}-${AWS::Region}";
    /**
     * (experimental) Default file assets bucket name.
     *
     * @experimental
     */
    static readonly DEFAULT_FILE_ASSETS_BUCKET_NAME = "cdk-${Qualifier}-assets-${AWS::AccountId}-${AWS::Region}";
    /**
     * (experimental) Name of the CloudFormation Export with the asset key name.
     *
     * @experimental
     */
    static readonly DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME = "CdkBootstrap-${Qualifier}-FileAssetKeyArn";
    private _stack?;
    private bucketName?;
    private repositoryName?;
    private _deployRoleArn?;
    private _cloudFormationExecutionRoleArn?;
    private fileAssetPublishingRoleArn?;
    private imageAssetPublishingRoleArn?;
    private qualifier?;
    private readonly files;
    private readonly dockerImages;
    /**
     * @experimental
     */
    constructor(props?: DefaultStackSynthesizerProps);
    /**
     * (experimental) Bind to the stack this environment is going to be used on.
     *
     * Must be called before any of the other methods are called.
     *
     * @experimental
     */
    bind(stack: Stack): void;
    /**
     * (experimental) Register a File Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     *
     * @experimental
     */
    addFileAsset(asset: FileAssetSource): FileAssetLocation;
    /**
     * (experimental) Register a Docker Image Asset.
     *
     * Returns the parameters that can be used to refer to the asset inside the template.
     *
     * @experimental
     */
    addDockerImageAsset(asset: DockerImageAssetSource): DockerImageAssetLocation;
    /**
     * (experimental) Synthesize the associated stack to the session.
     *
     * @experimental
     */
    synthesize(session: ISynthesisSession): void;
    /**
     * (experimental) Returns the ARN of the deploy Role.
     *
     * @experimental
     */
    get deployRoleArn(): string;
    /**
     * (experimental) Returns the ARN of the CFN execution Role.
     *
     * @experimental
     */
    get cloudFormationExecutionRoleArn(): string;
    /**
     * @experimental
     */
    protected get stack(): Stack | undefined;
    /**
     * Add the stack's template as one of the manifest assets
     *
     * This will make it get uploaded to S3 automatically by S3-assets. Return
     * the manifest URL.
     *
     * (We can't return the location returned from `addFileAsset`, as that
     * contains CloudFormation intrinsics which can't go into the manifest).
     */
    private addStackTemplateToAssetManifest;
    /**
     * Write an asset manifest to the Cloud Assembly, return the artifact IDs written
     */
    private writeAssetManifest;
    private get manifestEnvName();
}
