/**
 * (experimental) Represents the amount of digital storage.
 *
 * The amount can be specified either as a literal value (e.g: `10`) which
 * cannot be negative, or as an unresolved number token.
 *
 * When the amount is passed as a token, unit conversion is not possible.
 *
 * @experimental
 */
export declare class Size {
    /**
     * (experimental) Create a Storage representing an amount kibibytes.
     *
     * 1 KiB = 1024 bytes
     *
     * @experimental
     */
    static kibibytes(amount: number): Size;
    /**
     * (experimental) Create a Storage representing an amount mebibytes.
     *
     * 1 MiB = 1024 KiB
     *
     * @experimental
     */
    static mebibytes(amount: number): Size;
    /**
     * (experimental) Create a Storage representing an amount gibibytes.
     *
     * 1 GiB = 1024 MiB
     *
     * @experimental
     */
    static gibibytes(amount: number): Size;
    /**
     * (experimental) Create a Storage representing an amount tebibytes.
     *
     * 1 TiB = 1024 GiB
     *
     * @experimental
     */
    static tebibytes(amount: number): Size;
    /**
     * (experimental) Create a Storage representing an amount pebibytes.
     *
     * 1 PiB = 1024 TiB
     *
     * @experimental
     */
    static pebibyte(amount: number): Size;
    private readonly amount;
    private readonly unit;
    private constructor();
    /**
     * (experimental) Return this storage as a total number of kibibytes.
     *
     * @experimental
     */
    toKibibytes(opts?: SizeConversionOptions): number;
    /**
     * (experimental) Return this storage as a total number of mebibytes.
     *
     * @experimental
     */
    toMebibytes(opts?: SizeConversionOptions): number;
    /**
     * (experimental) Return this storage as a total number of gibibytes.
     *
     * @experimental
     */
    toGibibytes(opts?: SizeConversionOptions): number;
    /**
     * (experimental) Return this storage as a total number of tebibytes.
     *
     * @experimental
     */
    toTebibytes(opts?: SizeConversionOptions): number;
    /**
     * (experimental) Return this storage as a total number of pebibytes.
     *
     * @experimental
     */
    toPebibytes(opts?: SizeConversionOptions): number;
}
/**
 * (experimental) Rounding behaviour when converting between units of `Size`.
 *
 * @experimental
 */
export declare enum SizeRoundingBehavior {
    /**
     * (experimental) Fail the conversion if the result is not an integer.
     *
     * @experimental
     */
    FAIL = 0,
    /**
     * (experimental) If the result is not an integer, round it to the closest integer less than the result.
     *
     * @experimental
     */
    FLOOR = 1,
    /**
     * (experimental) Don't round.
     *
     * Return even if the result is a fraction.
     *
     * @experimental
     */
    NONE = 2
}
/**
 * (experimental) Options for how to convert time to a different unit.
 *
 * @experimental
 */
export interface SizeConversionOptions {
    /**
     * (experimental) How conversions should behave when it encounters a non-integer result.
     *
     * @default SizeRoundingBehavior.FAIL
     * @experimental
     */
    readonly rounding?: SizeRoundingBehavior;
}
