import { CopyOptions, FingerprintOptions } from './options';
export * from './options';
/**
 * (experimental) File system utilities.
 *
 * @experimental
 */
export declare class FileSystem {
    /**
     * (experimental) Copies an entire directory structure.
     *
     * @param srcDir Source directory.
     * @param destDir Destination directory.
     * @param options options.
     * @param rootDir Root directory to calculate exclusions from.
     * @experimental
     */
    static copyDirectory(srcDir: string, destDir: string, options?: CopyOptions, rootDir?: string): void;
    /**
     * (experimental) Produces fingerprint based on the contents of a single file or an entire directory tree.
     *
     * The fingerprint will also include:
     * 1. An extra string if defined in `options.extra`.
     * 2. The set of exclude patterns, if defined in `options.exclude`
     * 3. The symlink follow mode value.
     *
     * @param fileOrDirectory The directory or file to fingerprint.
     * @param options Fingerprinting options.
     * @experimental
     */
    static fingerprint(fileOrDirectory: string, options?: FingerprintOptions): string;
    /**
     * (experimental) Checks whether a directory is empty.
     *
     * @param dir The directory to check.
     * @experimental
     */
    static isEmpty(dir: string): boolean;
    /**
     * (experimental) The real path of the system temp directory.
     *
     * @experimental
     */
    static get tmpdir(): string;
    /**
     * (experimental) Creates a unique temporary directory in the **system temp directory**.
     *
     * @param prefix A prefix for the directory name.
     * @experimental
     */
    static mkdtemp(prefix: string): string;
    private static _tmpdir?;
}
