import { Construct } from '../lib/construct-compat';
/**
 * (experimental) Features that are implemented behind a flag in order to preserve backwards compatibility for existing apps.
 *
 * The list of flags are available in the
 * `@aws-cdk/cx-api` module.
 *
 * The state of the flag for this application is stored as a CDK context variable.
 *
 * @experimental
 */
export declare class FeatureFlags {
    private readonly construct;
    /**
     * (experimental) Inspect feature flags on the construct node's context.
     *
     * @experimental
     */
    static of(scope: Construct): FeatureFlags;
    private constructor();
    /**
     * (experimental) Check whether a feature flag is enabled.
     *
     * If configured, the flag is present in
     * the construct node context. Falls back to the defaults defined in the `cx-api`
     * module.
     *
     * @experimental
     */
    isEnabled(featureFlag: string): boolean | undefined;
}
