/**
 * (experimental) Associate the CreationPolicy attribute with a resource to prevent its status from reaching create complete until AWS CloudFormation receives a specified number of success signals or the timeout period is exceeded.
 *
 * To signal a
 * resource, you can use the cfn-signal helper script or SignalResource API. AWS CloudFormation publishes valid signals
 * to the stack events so that you track the number of signals sent.
 *
 * The creation policy is invoked only when AWS CloudFormation creates the associated resource. Currently, the only
 * AWS CloudFormation resources that support creation policies are AWS::AutoScaling::AutoScalingGroup, AWS::EC2::Instance,
 * and AWS::CloudFormation::WaitCondition.
 *
 * Use the CreationPolicy attribute when you want to wait on resource configuration actions before stack creation proceeds.
 * For example, if you install and configure software applications on an EC2 instance, you might want those applications to
 * be running before proceeding. In such cases, you can add a CreationPolicy attribute to the instance, and then send a success
 * signal to the instance after the applications are installed and configured. For a detailed example, see Deploying Applications
 * on Amazon EC2 with AWS CloudFormation.
 *
 * @experimental
 */
export interface CfnCreationPolicy {
    /**
     * (experimental) For an Auto Scaling group replacement update, specifies how many instances must signal success for the update to succeed.
     *
     * @experimental
     */
    readonly autoScalingCreationPolicy?: CfnResourceAutoScalingCreationPolicy;
    /**
     * (experimental) When AWS CloudFormation creates the associated resource, configures the number of required success signals and the length of time that AWS CloudFormation waits for those signals.
     *
     * @experimental
     */
    readonly resourceSignal?: CfnResourceSignal;
}
/**
 * (experimental) For an Auto Scaling group replacement update, specifies how many instances must signal success for the update to succeed.
 *
 * @experimental
 */
export interface CfnResourceAutoScalingCreationPolicy {
    /**
     * (experimental) Specifies the percentage of instances in an Auto Scaling replacement update that must signal success for the update to succeed.
     *
     * You can specify a value from 0 to 100. AWS CloudFormation rounds to the nearest tenth of a percent.
     * For example, if you update five instances with a minimum successful percentage of 50, three instances must signal success.
     * If an instance doesn't send a signal within the time specified by the Timeout property, AWS CloudFormation assumes that the
     * instance wasn't created.
     *
     * @experimental
     */
    readonly minSuccessfulInstancesPercent?: number;
}
/**
 * (experimental) When AWS CloudFormation creates the associated resource, configures the number of required success signals and the length of time that AWS CloudFormation waits for those signals.
 *
 * @experimental
 */
export interface CfnResourceSignal {
    /**
     * (experimental) The number of success signals AWS CloudFormation must receive before it sets the resource status as CREATE_COMPLETE.
     *
     * If the resource receives a failure signal or doesn't receive the specified number of signals before the timeout period
     * expires, the resource creation fails and AWS CloudFormation rolls the stack back.
     *
     * @experimental
     */
    readonly count?: number;
    /**
     * (experimental) The length of time that AWS CloudFormation waits for the number of signals that was specified in the Count property.
     *
     * The timeout period starts after AWS CloudFormation starts creating the resource, and the timeout expires no sooner
     * than the time you specify but can occur shortly thereafter. The maximum time that you can specify is 12 hours.
     *
     * @experimental
     */
    readonly timeout?: string;
}
/**
 * (experimental) With the DeletionPolicy attribute you can preserve or (in some cases) backup a resource when its stack is deleted.
 *
 * You specify a DeletionPolicy attribute for each resource that you want to control. If a resource has no DeletionPolicy
 * attribute, AWS CloudFormation deletes the resource by default. Note that this capability also applies to update operations
 * that lead to resources being removed.
 *
 * @experimental
 */
export declare enum CfnDeletionPolicy {
    /**
     * (experimental) AWS CloudFormation deletes the resource and all its content if applicable during stack deletion.
     *
     * You can add this
     * deletion policy to any resource type. By default, if you don't specify a DeletionPolicy, AWS CloudFormation deletes
     * your resources. However, be aware of the following considerations:
     *
     * @experimental
     */
    DELETE = "Delete",
    /**
     * (experimental) AWS CloudFormation keeps the resource without deleting the resource or its contents when its stack is deleted.
     *
     * You can add this deletion policy to any resource type. Note that when AWS CloudFormation completes the stack deletion,
     * the stack will be in Delete_Complete state; however, resources that are retained continue to exist and continue to incur
     * applicable charges until you delete those resources.
     *
     * @experimental
     */
    RETAIN = "Retain",
    /**
     * (experimental) For resources that support snapshots (AWS::EC2::Volume, AWS::ElastiCache::CacheCluster, AWS::ElastiCache::ReplicationGroup, AWS::RDS::DBInstance, AWS::RDS::DBCluster, and AWS::Redshift::Cluster), AWS CloudFormation creates a snapshot for the resource before deleting it.
     *
     * Note that when AWS CloudFormation completes the stack deletion, the stack will be in the
     * Delete_Complete state; however, the snapshots that are created with this policy continue to exist and continue to
     * incur applicable charges until you delete those snapshots.
     *
     * @experimental
     */
    SNAPSHOT = "Snapshot"
}
/**
 * (experimental) Use the UpdatePolicy attribute to specify how AWS CloudFormation handles updates to the AWS::AutoScaling::AutoScalingGroup resource.
 *
 * AWS CloudFormation invokes one of three update policies depending on the type of change you make or whether a
 * scheduled action is associated with the Auto Scaling group.
 *
 * @experimental
 */
export interface CfnUpdatePolicy {
    /**
     * (experimental) Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
     *
     * During replacement,
     * AWS CloudFormation retains the old group until it finishes creating the new one. If the update fails, AWS CloudFormation
     * can roll back to the old Auto Scaling group and delete the new Auto Scaling group.
     *
     * @experimental
     */
    readonly autoScalingReplacingUpdate?: CfnAutoScalingReplacingUpdate;
    /**
     * (experimental) To specify how AWS CloudFormation handles rolling updates for an Auto Scaling group, use the AutoScalingRollingUpdate policy.
     *
     * Rolling updates enable you to specify whether AWS CloudFormation updates instances that are in an Auto Scaling
     * group in batches or all at once.
     *
     * @experimental
     */
    readonly autoScalingRollingUpdate?: CfnAutoScalingRollingUpdate;
    /**
     * (experimental) To specify how AWS CloudFormation handles updates for the MinSize, MaxSize, and DesiredCapacity properties when the AWS::AutoScaling::AutoScalingGroup resource has an associated scheduled action, use the AutoScalingScheduledAction policy.
     *
     * @experimental
     */
    readonly autoScalingScheduledAction?: CfnAutoScalingScheduledAction;
    /**
     * (experimental) To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
     *
     * @experimental
     */
    readonly codeDeployLambdaAliasUpdate?: CfnCodeDeployLambdaAliasUpdate;
    /**
     * (experimental) To modify a replication group's shards by adding or removing shards, rather than replacing the entire AWS::ElastiCache::ReplicationGroup resource, use the UseOnlineResharding update policy.
     *
     * @experimental
     */
    readonly useOnlineResharding?: boolean;
    /**
     * (experimental) To upgrade an Amazon ES domain to a new version of Elasticsearch rather than replacing the entire AWS::Elasticsearch::Domain resource, use the EnableVersionUpgrade update policy.
     *
     * @experimental
     */
    readonly enableVersionUpgrade?: boolean;
}
/**
 * (experimental) To specify how AWS CloudFormation handles rolling updates for an Auto Scaling group, use the AutoScalingRollingUpdate policy.
 *
 * Rolling updates enable you to specify whether AWS CloudFormation updates instances that are in an Auto Scaling
 * group in batches or all at once.
 *
 * @experimental
 */
export interface CfnAutoScalingRollingUpdate {
    /**
     * (experimental) Specifies the maximum number of instances that AWS CloudFormation updates.
     *
     * @experimental
     */
    readonly maxBatchSize?: number;
    /**
     * (experimental) Specifies the minimum number of instances that must be in service within the Auto Scaling group while AWS CloudFormation updates old instances.
     *
     * @experimental
     */
    readonly minInstancesInService?: number;
    /**
     * (experimental) Specifies the percentage of instances in an Auto Scaling rolling update that must signal success for an update to succeed.
     *
     * You can specify a value from 0 to 100. AWS CloudFormation rounds to the nearest tenth of a percent. For example, if you
     * update five instances with a minimum successful percentage of 50, three instances must signal success.
     *
     * If an instance doesn't send a signal within the time specified in the PauseTime property, AWS CloudFormation assumes
     * that the instance wasn't updated.
     *
     * If you specify this property, you must also enable the WaitOnResourceSignals and PauseTime properties.
     *
     * @experimental
     */
    readonly minSuccessfulInstancesPercent?: number;
    /**
     * (experimental) The amount of time that AWS CloudFormation pauses after making a change to a batch of instances to give those instances time to start software applications.
     *
     * For example, you might need to specify PauseTime when scaling up the number of
     * instances in an Auto Scaling group.
     *
     * If you enable the WaitOnResourceSignals property, PauseTime is the amount of time that AWS CloudFormation should wait
     * for the Auto Scaling group to receive the required number of valid signals from added or replaced instances. If the
     * PauseTime is exceeded before the Auto Scaling group receives the required number of signals, the update fails. For best
     * results, specify a time period that gives your applications sufficient time to get started. If the update needs to be
     * rolled back, a short PauseTime can cause the rollback to fail.
     *
     * Specify PauseTime in the ISO8601 duration format (in the format PT#H#M#S, where each # is the number of hours, minutes,
     * and seconds, respectively). The maximum PauseTime is one hour (PT1H).
     *
     * @experimental
     */
    readonly pauseTime?: string;
    /**
     * (experimental) Specifies the Auto Scaling processes to suspend during a stack update.
     *
     * Suspending processes prevents Auto Scaling from
     * interfering with a stack update. For example, you can suspend alarming so that Auto Scaling doesn't execute scaling
     * policies associated with an alarm. For valid values, see the ScalingProcesses.member.N parameter for the SuspendProcesses
     * action in the Auto Scaling API Reference.
     *
     * @experimental
     */
    readonly suspendProcesses?: string[];
    /**
     * (experimental) Specifies whether the Auto Scaling group waits on signals from new instances during an update.
     *
     * Use this property to
     * ensure that instances have completed installing and configuring applications before the Auto Scaling group update proceeds.
     * AWS CloudFormation suspends the update of an Auto Scaling group after new EC2 instances are launched into the group.
     * AWS CloudFormation must receive a signal from each new instance within the specified PauseTime before continuing the update.
     * To signal the Auto Scaling group, use the cfn-signal helper script or SignalResource API.
     *
     * To have instances wait for an Elastic Load Balancing health check before they signal success, add a health-check
     * verification by using the cfn-init helper script. For an example, see the verify_instance_health command in the Auto Scaling
     * rolling updates sample template.
     *
     * @experimental
     */
    readonly waitOnResourceSignals?: boolean;
}
/**
 * (experimental) Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
 *
 * During replacement,
 * AWS CloudFormation retains the old group until it finishes creating the new one. If the update fails, AWS CloudFormation
 * can roll back to the old Auto Scaling group and delete the new Auto Scaling group.
 *
 * While AWS CloudFormation creates the new group, it doesn't detach or attach any instances. After successfully creating
 * the new Auto Scaling group, AWS CloudFormation deletes the old Auto Scaling group during the cleanup process.
 *
 * When you set the WillReplace parameter, remember to specify a matching CreationPolicy. If the minimum number of
 * instances (specified by the MinSuccessfulInstancesPercent property) don't signal success within the Timeout period
 * (specified in the CreationPolicy policy), the replacement update fails and AWS CloudFormation rolls back to the old
 * Auto Scaling group.
 *
 * @experimental
 */
export interface CfnAutoScalingReplacingUpdate {
    /**
     * @experimental
     */
    readonly willReplace?: boolean;
}
/**
 * (experimental) With scheduled actions, the group size properties of an Auto Scaling group can change at any time.
 *
 * When you update a
 * stack with an Auto Scaling group and scheduled action, AWS CloudFormation always sets the group size property values of
 * your Auto Scaling group to the values that are defined in the AWS::AutoScaling::AutoScalingGroup resource of your template,
 * even if a scheduled action is in effect.
 *
 * If you do not want AWS CloudFormation to change any of the group size property values when you have a scheduled action in
 * effect, use the AutoScalingScheduledAction update policy to prevent AWS CloudFormation from changing the MinSize, MaxSize,
 * or DesiredCapacity properties unless you have modified these values in your template.\
 *
 * @experimental
 */
export interface CfnAutoScalingScheduledAction {
    /**
     * @experimental
     */
    readonly ignoreUnmodifiedGroupSizeProperties?: boolean;
}
/**
 * (experimental) To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
 *
 * @experimental
 */
export interface CfnCodeDeployLambdaAliasUpdate {
    /**
     * (experimental) The name of the AWS CodeDeploy application.
     *
     * @experimental
     */
    readonly applicationName: string;
    /**
     * (experimental) The name of the AWS CodeDeploy deployment group.
     *
     * This is where the traffic-shifting policy is set.
     *
     * @experimental
     */
    readonly deploymentGroupName: string;
    /**
     * (experimental) The name of the Lambda function to run before traffic routing starts.
     *
     * @experimental
     */
    readonly beforeAllowTrafficHook?: string;
    /**
     * (experimental) The name of the Lambda function to run after traffic routing completes.
     *
     * @experimental
     */
    readonly afterAllowTrafficHook?: string;
}
