import { Construct } from './construct-compat';
/**
 * (experimental) Accessor for pseudo parameters.
 *
 * Since pseudo parameters need to be anchored to a stack somewhere in the
 * construct tree, this class takes an scope parameter; the pseudo parameter
 * values can be obtained as properties from an scoped object.
 *
 * @experimental
 */
export declare class Aws {
    /**
     * @experimental
     */
    static readonly ACCOUNT_ID: string;
    /**
     * @experimental
     */
    static readonly URL_SUFFIX: string;
    /**
     * @experimental
     */
    static readonly NOTIFICATION_ARNS: string[];
    /**
     * @experimental
     */
    static readonly PARTITION: string;
    /**
     * @experimental
     */
    static readonly REGION: string;
    /**
     * @experimental
     */
    static readonly STACK_ID: string;
    /**
     * @experimental
     */
    static readonly STACK_NAME: string;
    /**
     * @experimental
     */
    static readonly NO_VALUE: string;
    private constructor();
}
/**
 * (experimental) Accessor for scoped pseudo parameters.
 *
 * These pseudo parameters are anchored to a stack somewhere in the construct
 * tree, and their values will be exported automatically.
 *
 * @experimental
 */
export declare class ScopedAws {
    private readonly scope;
    /**
     * @experimental
     */
    constructor(scope: Construct);
    /**
     * @experimental
     */
    get accountId(): string;
    /**
     * @experimental
     */
    get urlSuffix(): string;
    /**
     * @experimental
     */
    get notificationArns(): string[];
    /**
     * @experimental
     */
    get partition(): string;
    /**
     * @experimental
     */
    get region(): string;
    /**
     * @experimental
     */
    get stackId(): string;
    /**
     * @experimental
     */
    get stackName(): string;
    private asString;
}
