import { CfnElement } from './cfn-element';
import { Construct } from './construct-compat';
import { IResolvable, IResolveContext } from './resolvable';
/**
 * @experimental
 */
export interface CfnParameterProps {
    /**
     * (experimental) The data type for the parameter (DataType).
     *
     * @default String
     * @experimental
     */
    readonly type?: string;
    /**
     * (experimental) A value of the appropriate type for the template to use if no value is specified when a stack is created.
     *
     * If you define constraints for the parameter, you must specify
     * a value that adheres to those constraints.
     *
     * @default - No default value for parameter.
     * @experimental
     */
    readonly default?: any;
    /**
     * (experimental) A regular expression that represents the patterns to allow for String types.
     *
     * @default - No constraints on patterns allowed for parameter.
     * @experimental
     */
    readonly allowedPattern?: string;
    /**
     * (experimental) An array containing the list of values allowed for the parameter.
     *
     * @default - No constraints on values allowed for parameter.
     * @experimental
     */
    readonly allowedValues?: string[];
    /**
     * (experimental) A string that explains a constraint when the constraint is violated.
     *
     * For example, without a constraint description, a parameter that has an allowed
     * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
     * an invalid value:
     *
     * @default - No description with customized error message when user specifies invalid values.
     * @experimental
     */
    readonly constraintDescription?: string;
    /**
     * (experimental) A string of up to 4000 characters that describes the parameter.
     *
     * @default - No description for the parameter.
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) An integer value that determines the largest number of characters you want to allow for String types.
     *
     * @default - None.
     * @experimental
     */
    readonly maxLength?: number;
    /**
     * (experimental) A numeric value that determines the largest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @experimental
     */
    readonly maxValue?: number;
    /**
     * (experimental) An integer value that determines the smallest number of characters you want to allow for String types.
     *
     * @default - None.
     * @experimental
     */
    readonly minLength?: number;
    /**
     * (experimental) A numeric value that determines the smallest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @experimental
     */
    readonly minValue?: number;
    /**
     * (experimental) Whether to mask the parameter value when anyone makes a call that describes the stack.
     *
     * If you set the value to ``true``, the parameter value is masked with asterisks (``*****``).
     *
     * @default - Parameter values are not masked.
     * @experimental
     */
    readonly noEcho?: boolean;
}
/**
 * (experimental) A CloudFormation parameter.
 *
 * Use the optional Parameters section to customize your templates.
 * Parameters enable you to input custom values to your template each time you create or
 * update a stack.
 *
 * @experimental
 */
export declare class CfnParameter extends CfnElement {
    private _type;
    private _default?;
    private _allowedPattern?;
    private _allowedValues?;
    private _constraintDescription?;
    private _description?;
    private _maxLength?;
    private _maxValue?;
    private _minLength?;
    private _minValue?;
    private _noEcho?;
    /**
     * (experimental) Creates a parameter construct.
     *
     * Note that the name (logical ID) of the parameter will derive from it's `coname` and location
     * within the stack. Therefore, it is recommended that parameters are defined at the stack level.
     *
     * @param scope The parent construct.
     * @param props The parameter properties.
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: CfnParameterProps);
    /**
     * (experimental) The data type for the parameter (DataType).
     *
     * @default String
     * @experimental
     */
    get type(): string;
    /**
     * (experimental) The data type for the parameter (DataType).
     *
     * @default String
     * @experimental
     */
    set type(type: string);
    /**
     * (experimental) A value of the appropriate type for the template to use if no value is specified when a stack is created.
     *
     * If you define constraints for the parameter, you must specify
     * a value that adheres to those constraints.
     *
     * @default - No default value for parameter.
     * @experimental
     */
    get default(): any;
    /**
     * (experimental) A value of the appropriate type for the template to use if no value is specified when a stack is created.
     *
     * If you define constraints for the parameter, you must specify
     * a value that adheres to those constraints.
     *
     * @default - No default value for parameter.
     * @experimental
     */
    set default(value: any);
    /**
     * (experimental) A regular expression that represents the patterns to allow for String types.
     *
     * @default - No constraints on patterns allowed for parameter.
     * @experimental
     */
    get allowedPattern(): string | undefined;
    /**
     * (experimental) A regular expression that represents the patterns to allow for String types.
     *
     * @default - No constraints on patterns allowed for parameter.
     * @experimental
     */
    set allowedPattern(pattern: string | undefined);
    /**
     * (experimental) An array containing the list of values allowed for the parameter.
     *
     * @default - No constraints on values allowed for parameter.
     * @experimental
     */
    get allowedValues(): string[] | undefined;
    /**
     * (experimental) An array containing the list of values allowed for the parameter.
     *
     * @default - No constraints on values allowed for parameter.
     * @experimental
     */
    set allowedValues(values: string[] | undefined);
    /**
     * (experimental) A string that explains a constraint when the constraint is violated.
     *
     * For example, without a constraint description, a parameter that has an allowed
     * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
     * an invalid value:
     *
     * @default - No description with customized error message when user specifies invalid values.
     * @experimental
     */
    get constraintDescription(): string | undefined;
    /**
     * (experimental) A string that explains a constraint when the constraint is violated.
     *
     * For example, without a constraint description, a parameter that has an allowed
     * pattern of [A-Za-z0-9]+ displays the following error message when the user specifies
     * an invalid value:
     *
     * @default - No description with customized error message when user specifies invalid values.
     * @experimental
     */
    set constraintDescription(desc: string | undefined);
    /**
     * (experimental) A string of up to 4000 characters that describes the parameter.
     *
     * @default - No description for the parameter.
     * @experimental
     */
    get description(): string | undefined;
    /**
     * (experimental) A string of up to 4000 characters that describes the parameter.
     *
     * @default - No description for the parameter.
     * @experimental
     */
    set description(desc: string | undefined);
    /**
     * (experimental) An integer value that determines the largest number of characters you want to allow for String types.
     *
     * @default - None.
     * @experimental
     */
    get maxLength(): number | undefined;
    /**
     * (experimental) An integer value that determines the largest number of characters you want to allow for String types.
     *
     * @default - None.
     * @experimental
     */
    set maxLength(len: number | undefined);
    /**
     * (experimental) An integer value that determines the smallest number of characters you want to allow for String types.
     *
     * @default - None.
     * @experimental
     */
    get minLength(): number | undefined;
    /**
     * (experimental) An integer value that determines the smallest number of characters you want to allow for String types.
     *
     * @default - None.
     * @experimental
     */
    set minLength(len: number | undefined);
    /**
     * (experimental) A numeric value that determines the largest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @experimental
     */
    get maxValue(): number | undefined;
    /**
     * (experimental) A numeric value that determines the largest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @experimental
     */
    set maxValue(len: number | undefined);
    /**
     * (experimental) A numeric value that determines the smallest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @experimental
     */
    get minValue(): number | undefined;
    /**
     * (experimental) A numeric value that determines the smallest numeric value you want to allow for Number types.
     *
     * @default - None.
     * @experimental
     */
    set minValue(len: number | undefined);
    /**
     * (experimental) Indicates if this parameter is configured with "NoEcho" enabled.
     *
     * @experimental
     */
    get noEcho(): boolean;
    /**
     * (experimental) Indicates if this parameter is configured with "NoEcho" enabled.
     *
     * @experimental
     */
    set noEcho(echo: boolean);
    /**
     * (experimental) The parameter value as a Token.
     *
     * @experimental
     */
    get value(): IResolvable;
    /**
     * (experimental) The parameter value, if it represents a string.
     *
     * @experimental
     */
    get valueAsString(): string;
    /**
     * (experimental) The parameter value, if it represents a string list.
     *
     * @experimental
     */
    get valueAsList(): string[];
    /**
     * (experimental) The parameter value, if it represents a number.
     *
     * @experimental
     */
    get valueAsNumber(): number;
    /**
     * @experimental
     */
    resolve(_context: IResolveContext): any;
}
