import { CfnElement } from './cfn-element';
import { Construct } from './construct-compat';
/**
 * @experimental
 */
export interface CfnOutputProps {
    /**
     * (experimental) A String type that describes the output value.
     *
     * The description can be a maximum of 4 K in length.
     *
     * @default - No description.
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The value of the property returned by the aws cloudformation describe-stacks command.
     *
     * The value of an output can include literals, parameter references, pseudo-parameters,
     * a mapping value, or intrinsic functions.
     *
     * @experimental
     */
    readonly value: string;
    /**
     * (experimental) The name used to export the value of this output across stacks.
     *
     * To import the value from another stack, use `Fn.importValue(exportName)`.
     *
     * @default - the output is not exported
     * @experimental
     */
    readonly exportName?: string;
    /**
     * (experimental) A condition to associate with this output value.
     *
     * If the condition evaluates
     * to `false`, this output value will not be included in the stack.
     *
     * @default - No condition is associated with the output.
     * @experimental
     */
    readonly condition?: CfnCondition;
}
/**
 * @experimental
 */
export declare class CfnOutput extends CfnElement {
    private _description?;
    private _condition?;
    private _value?;
    private _exportName?;
    /**
     * (experimental) Creates an CfnOutput value for this stack.
     *
     * @param scope The parent construct.
     * @param props CfnOutput properties.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CfnOutputProps);
    /**
     * (experimental) A String type that describes the output value.
     *
     * The description can be a maximum of 4 K in length.
     *
     * @default - No description.
     * @experimental
     */
    get description(): string | undefined;
    /**
     * (experimental) A String type that describes the output value.
     *
     * The description can be a maximum of 4 K in length.
     *
     * @default - No description.
     * @experimental
     */
    set description(description: string | undefined);
    /**
     * (experimental) The value of the property returned by the aws cloudformation describe-stacks command.
     *
     * The value of an output can include literals, parameter references, pseudo-parameters,
     * a mapping value, or intrinsic functions.
     *
     * @experimental
     */
    get value(): any;
    /**
     * (experimental) The value of the property returned by the aws cloudformation describe-stacks command.
     *
     * The value of an output can include literals, parameter references, pseudo-parameters,
     * a mapping value, or intrinsic functions.
     *
     * @experimental
     */
    set value(value: any);
    /**
     * (experimental) A condition to associate with this output value.
     *
     * If the condition evaluates
     * to `false`, this output value will not be included in the stack.
     *
     * @default - No condition is associated with the output.
     * @experimental
     */
    get condition(): CfnCondition | undefined;
    /**
     * (experimental) A condition to associate with this output value.
     *
     * If the condition evaluates
     * to `false`, this output value will not be included in the stack.
     *
     * @default - No condition is associated with the output.
     * @experimental
     */
    set condition(condition: CfnCondition | undefined);
    /**
     * (experimental) The name used to export the value of this output across stacks.
     *
     * To import the value from another stack, use `Fn.importValue(exportName)`.
     *
     * @default - the output is not exported
     * @experimental
     */
    get exportName(): string | undefined;
    /**
     * (experimental) The name used to export the value of this output across stacks.
     *
     * To import the value from another stack, use `Fn.importValue(exportName)`.
     *
     * @default - the output is not exported
     * @experimental
     */
    set exportName(exportName: string | undefined);
}
import { CfnCondition } from './cfn-condition';
