/**
 * (experimental) Bundling options.
 *
 * @experimental
 */
export interface BundlingOptions {
    /**
     * (experimental) The Docker image where the command will run.
     *
     * @experimental
     */
    readonly image: BundlingDockerImage;
    /**
     * (experimental) The command to run in the Docker container.
     *
     * @default - run the command defined in the image
     * @see https://docs.docker.com/engine/reference/run/
     * @experimental
     * @example
     *
     * ['npm', 'install']
     */
    readonly command?: string[];
    /**
     * (experimental) Additional Docker volumes to mount.
     *
     * @default - no additional volumes are mounted
     * @experimental
     */
    readonly volumes?: DockerVolume[];
    /**
     * (experimental) The environment variables to pass to the Docker container.
     *
     * @default - no environment variables.
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) Working directory inside the Docker container.
     *
     * @default /asset-input
     * @experimental
     */
    readonly workingDirectory?: string;
    /**
     * (experimental) The user to use when running the Docker container.
     *
     * user | user:group | uid | uid:gid | user:gid | uid:group
     *
     * @default - uid:gid of the current user or 1000:1000 on Windows
     * @see https://docs.docker.com/engine/reference/run/#user
     * @experimental
     */
    readonly user?: string;
    /**
     * (experimental) Local bundling provider.
     *
     * The provider implements a method `tryBundle()` which should return `true`
     * if local bundling was performed. If `false` is returned, docker bundling
     * will be done.
     *
     * @default - bundling will only be performed in a Docker container
     * @experimental
     */
    readonly local?: ILocalBundling;
}
/**
 * (experimental) Local bundling.
 *
 * @experimental
 */
export interface ILocalBundling {
    /**
     * (experimental) This method is called before attempting docker bundling to allow the bundler to be executed locally.
     *
     * If the local bundler exists, and bundling
     * was performed locally, return `true`. Otherwise, return `false`.
     *
     * @param outputDir the directory where the bundled asset should be output.
     * @param options bundling options for this asset.
     * @experimental
     */
    tryBundle(outputDir: string, options: BundlingOptions): boolean;
}
/**
 * (experimental) A Docker image used for asset bundling.
 *
 * @experimental
 */
export declare class BundlingDockerImage {
    readonly image: string;
    private readonly _imageHash?;
    /**
     * (experimental) Reference an image on DockerHub or another online registry.
     *
     * @param image the image name.
     * @experimental
     */
    static fromRegistry(image: string): BundlingDockerImage;
    /**
     * (experimental) Reference an image that's built directly from sources on disk.
     *
     * @param path The path to the directory containing the Docker file.
     * @param options Docker build options.
     * @experimental
     */
    static fromAsset(path: string, options?: DockerBuildOptions): BundlingDockerImage;
    /** @param image The Docker image */
    private constructor();
    /**
     * (experimental) Provides a stable representation of this image for JSON serialization.
     *
     * @returns The overridden image name if set or image hash name in that order
     * @experimental
     */
    toJSON(): string;
}
/**
 * (experimental) A Docker volume.
 *
 * @experimental
 */
export interface DockerVolume {
    /**
     * (experimental) The path to the file or directory on the host machine.
     *
     * @experimental
     */
    readonly hostPath: string;
    /**
     * (experimental) The path where the file or directory is mounted in the container.
     *
     * @experimental
     */
    readonly containerPath: string;
    /**
     * (experimental) Mount consistency.
     *
     * Only applicable for macOS
     *
     * @default DockerConsistency.DELEGATED
     * @see https://docs.docker.com/storage/bind-mounts/#configure-mount-consistency-for-macos
     * @experimental
     */
    readonly consistency?: DockerVolumeConsistency;
}
/**
 * (experimental) Supported Docker volume consistency types.
 *
 * Only valid on macOS due to the way file storage works on Mac
 *
 * @experimental
 */
export declare enum DockerVolumeConsistency {
    /**
     * (experimental) Read/write operations inside the Docker container are applied immediately on the mounted host machine volumes.
     *
     * @experimental
     */
    CONSISTENT = "consistent",
    /**
     * (experimental) Read/write operations on mounted Docker volumes are first written inside the container and then synchronized to the host machine.
     *
     * @experimental
     */
    DELEGATED = "delegated",
    /**
     * (experimental) Read/write operations on mounted Docker volumes are first applied on the host machine and then synchronized to the container.
     *
     * @experimental
     */
    CACHED = "cached"
}
/**
 * (experimental) Docker build options.
 *
 * @experimental
 */
export interface DockerBuildOptions {
    /**
     * (experimental) Build args.
     *
     * @default - no build args
     * @experimental
     */
    readonly buildArgs?: {
        [key: string]: string;
    };
}
