import { IConstruct } from './construct-compat';
/**
 * (experimental) Represents an Aspect.
 *
 * @experimental
 */
export interface IAspect {
    /**
     * (experimental) All aspects can visit an IConstruct.
     *
     * @experimental
     */
    visit(node: IConstruct): void;
}
/**
 * (experimental) Aspects can be applied to CDK tree scopes and can operate on the tree before synthesis.
 *
 * @experimental
 */
export declare class Aspects {
    private readonly scope;
    /**
     * (experimental) Returns the `Aspects` object associated with a construct scope.
     *
     * @param scope The scope for which these aspects will apply.
     * @experimental
     */
    static of(scope: IConstruct): Aspects;
    private constructor();
    /**
     * (experimental) Adds an aspect to apply this scope before synthesis.
     *
     * @param aspect The aspect to add.
     * @experimental
     */
    add(aspect: IAspect): void;
    /**
     * (experimental) The list of aspects which were directly applied on this scope.
     *
     * @experimental
     */
    get aspects(): IAspect[];
}
