import { IConstruct } from 'constructs';
/**
 * (experimental) Includes API for attaching annotations such as warning messages to constructs.
 *
 * @experimental
 */
export declare class Annotations {
    private readonly scope;
    /**
     * (experimental) Returns the annotations API for a construct scope.
     *
     * @param scope The scope.
     * @experimental
     */
    static of(scope: IConstruct): Annotations;
    private constructor();
    /**
     * (experimental) Adds a warning metadata entry to this construct.
     *
     * The CLI will display the warning when an app is synthesized, or fail if run
     * in --strict mode.
     *
     * @param message The warning message.
     * @experimental
     */
    addWarning(message: string): void;
    /**
     * (experimental) Adds an info metadata entry to this construct.
     *
     * The CLI will display the info message when apps are synthesized.
     *
     * @param message The info message.
     * @experimental
     */
    addInfo(message: string): void;
    /**
     * (experimental) Adds an { "error": <message> } metadata entry to this construct.
     *
     * The toolkit will fail synthesis when errors are reported.
     *
     * @param message The error message.
     * @experimental
     */
    addError(message: string): void;
    /**
     * (experimental) Adds a deprecation warning for a specific API.
     *
     * Deprecations will be added only once per construct as a warning and will be
     * deduplicated based on the `api`.
     *
     * If the environment variable `CDK_BLOCK_DEPRECATIONS` is set, this method
     * will throw an error instead with the deprecation message.
     *
     * @param api The API being deprecated in the format `module.Class.property` (e.g. `@aws-cdk/core.Construct.node`).
     * @param message The deprecation message to display, with information about alternatives.
     * @experimental
     */
    addDeprecation(api: string, message: string): void;
    /**
     * Adds a message metadata entry to the construct node, to be displayed by the CDK CLI.
     * @param level The message level
     * @param message The message itself
     */
    private addMessage;
    /**
     * Returns the set of deprecations reported on this construct.
     */
    private get deprecationsReported();
}
