/**
 * Common properties for asset metadata.
 */
interface BaseAssetMetadataEntry {
    /**
     * Requested packaging style
     */
    readonly packaging: string;
    /**
     * (experimental) Logical identifier for the asset.
     *
     * @experimental
     */
    readonly id: string;
    /**
     * (experimental) The hash of the asset source.
     *
     * @experimental
     */
    readonly sourceHash: string;
    /**
     * (experimental) Path on disk to the asset.
     *
     * @experimental
     */
    readonly path: string;
}
/**
 * (experimental) Metadata Entry spec for files.
 *
 * @experimental
 */
export interface FileAssetMetadataEntry extends BaseAssetMetadataEntry {
    /**
     * (experimental) Requested packaging style.
     *
     * @experimental
     */
    readonly packaging: 'zip' | 'file';
    /**
     * (experimental) Name of parameter where S3 bucket should be passed in.
     *
     * @experimental
     */
    readonly s3BucketParameter: string;
    /**
     * (experimental) Name of parameter where S3 key should be passed in.
     *
     * @experimental
     */
    readonly s3KeyParameter: string;
    /**
     * (experimental) The name of the parameter where the hash of the bundled asset should be passed in.
     *
     * @experimental
     */
    readonly artifactHashParameter: string;
}
/**
 * (experimental) Metadata Entry spec for stack tag.
 *
 * @experimental
 */
export interface Tag {
    /**
     * (experimental) Tag key.
     *
     * (In the actual file on disk this will be cased as "Key", and the structure is
     * patched to match this structure upon loading:
     * https://github.com/aws/aws-cdk/blob/4aadaa779b48f35838cccd4e25107b2338f05547/packages/%40aws-cdk/cloud-assembly-schema/lib/manifest.ts#L137)
     *
     * @experimental
     */
    readonly key: string;
    /**
     * (experimental) Tag value.
     *
     * (In the actual file on disk this will be cased as "Value", and the structure is
     * patched to match this structure upon loading:
     * https://github.com/aws/aws-cdk/blob/4aadaa779b48f35838cccd4e25107b2338f05547/packages/%40aws-cdk/cloud-assembly-schema/lib/manifest.ts#L137)
     *
     * @experimental
     */
    readonly value: string;
}
/**
 * (experimental) Metadata Entry spec for container images.
 *
 * @experimental
 */
export interface ContainerImageAssetMetadataEntry extends BaseAssetMetadataEntry {
    /**
     * (experimental) Type of asset.
     *
     * @experimental
     */
    readonly packaging: 'container-image';
    /**
     * (deprecated) ECR Repository name and repo digest (separated by "@sha256:") where this image is stored.
     *
     * @default undefined If not specified, `repositoryName` and `imageTag` are
     * required because otherwise how will the stack know where to find the asset,
     * ha?
     * @deprecated specify `repositoryName` and `imageTag` instead, and then you
     * know where the image will go.
     */
    readonly imageNameParameter?: string;
    /**
     * (experimental) ECR repository name, if omitted a default name based on the asset's ID is used instead.
     *
     * Specify this property if you need to statically address the
     * image, e.g. from a Kubernetes Pod. Note, this is only the repository name,
     * without the registry and the tag parts.
     *
     * @default - this parameter is REQUIRED after 1.21.0
     * @experimental
     */
    readonly repositoryName?: string;
    /**
     * (experimental) The docker image tag to use for tagging pushed images.
     *
     * This field is
     * required if `imageParameterName` is ommited (otherwise, the app won't be
     * able to find the image).
     *
     * @default - this parameter is REQUIRED after 1.21.0
     * @experimental
     */
    readonly imageTag?: string;
    /**
     * (experimental) Build args to pass to the `docker build` command.
     *
     * @default no build args are passed
     * @experimental
     */
    readonly buildArgs?: {
        [key: string]: string;
    };
    /**
     * (experimental) Docker target to build to.
     *
     * @default no build target
     * @experimental
     */
    readonly target?: string;
    /**
     * (experimental) Path to the Dockerfile (relative to the directory).
     *
     * @default - no file is passed
     * @experimental
     */
    readonly file?: string;
}
/**
 * @see ArtifactMetadataEntryType.ASSET
 */
export declare type AssetMetadataEntry = FileAssetMetadataEntry | ContainerImageAssetMetadataEntry;
/**
 * @see ArtifactMetadataEntryType.INFO
 * @see ArtifactMetadataEntryType.WARN
 * @see ArtifactMetadataEntryType.ERROR
 */
export declare type LogMessageMetadataEntry = string;
/**
 * @see ArtifactMetadataEntryType.LOGICAL_ID
 */
export declare type LogicalIdMetadataEntry = string;
/**
 * @see ArtifactMetadataEntryType.STACK_TAGS
 */
export declare type StackTagsMetadataEntry = Tag[];
/**
 * Union type for all metadata entries that might exist in the manifest.
 */
export declare type MetadataEntryData = AssetMetadataEntry | LogMessageMetadataEntry | LogicalIdMetadataEntry | StackTagsMetadataEntry;
/**
 * (experimental) Type of artifact metadata entry.
 *
 * @experimental
 */
export declare enum ArtifactMetadataEntryType {
    /**
     * (experimental) Asset in metadata.
     *
     * @experimental
     */
    ASSET = "aws:cdk:asset",
    /**
     * (experimental) Metadata key used to print INFO-level messages by the toolkit when an app is syntheized.
     *
     * @experimental
     */
    INFO = "aws:cdk:info",
    /**
     * (experimental) Metadata key used to print WARNING-level messages by the toolkit when an app is syntheized.
     *
     * @experimental
     */
    WARN = "aws:cdk:warning",
    /**
     * (experimental) Metadata key used to print ERROR-level messages by the toolkit when an app is syntheized.
     *
     * @experimental
     */
    ERROR = "aws:cdk:error",
    /**
     * (experimental) Represents the CloudFormation logical ID of a resource at a certain path.
     *
     * @experimental
     */
    LOGICAL_ID = "aws:cdk:logicalId",
    /**
     * (experimental) Represents tags of a stack.
     *
     * @experimental
     */
    STACK_TAGS = "aws:cdk:stack-tags"
}
/**
 * (experimental) A metadata entry in a cloud assembly artifact.
 *
 * @experimental
 */
export interface MetadataEntry {
    /**
     * (experimental) The type of the metadata entry.
     *
     * @experimental
     */
    readonly type: string;
    /**
     * (experimental) The data.
     *
     * @default - no data.
     * @experimental
     */
    readonly data?: MetadataEntryData;
    /**
     * (experimental) A stack trace for when the entry was created.
     *
     * @default - no trace.
     * @experimental
     */
    readonly trace?: string[];
}
export {};
