import { AwsDestination } from './aws-destination';
/**
 * (experimental) A file asset.
 *
 * @experimental
 */
export interface FileAsset {
    /**
     * (experimental) Source description for file assets.
     *
     * @experimental
     */
    readonly source: FileSource;
    /**
     * (experimental) Destinations for this file asset.
     *
     * @experimental
     */
    readonly destinations: {
        [id: string]: FileDestination;
    };
}
/**
 * (experimental) Packaging strategy for file assets.
 *
 * @experimental
 */
export declare enum FileAssetPackaging {
    /**
     * (experimental) Upload the given path as a file.
     *
     * @experimental
     */
    FILE = "file",
    /**
     * (experimental) The given path is a directory, zip it and upload.
     *
     * @experimental
     */
    ZIP_DIRECTORY = "zip"
}
/**
 * (experimental) Describe the source of a file asset.
 *
 * @experimental
 */
export interface FileSource {
    /**
     * (experimental) The filesystem object to upload.
     *
     * This path is relative to the asset manifest location.
     *
     * @experimental
     */
    readonly path: string;
    /**
     * (experimental) Packaging method.
     *
     * @default FILE
     * @experimental
     */
    readonly packaging?: FileAssetPackaging;
}
/**
 * (experimental) Where in S3 a file asset needs to be published.
 *
 * @experimental
 */
export interface FileDestination extends AwsDestination {
    /**
     * (experimental) The name of the bucket.
     *
     * @experimental
     */
    readonly bucketName: string;
    /**
     * (experimental) The destination object key.
     *
     * @experimental
     */
    readonly objectKey: string;
}
