import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::WorkSpaces::Workspace`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html
 * @external
 */
export interface CfnWorkspaceProps {
    /**
     * `AWS::WorkSpaces::Workspace.BundleId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-bundleid
     * @external
     */
    readonly bundleId: string;
    /**
     * `AWS::WorkSpaces::Workspace.DirectoryId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-directoryid
     * @external
     */
    readonly directoryId: string;
    /**
     * `AWS::WorkSpaces::Workspace.UserName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-username
     * @external
     */
    readonly userName: string;
    /**
     * `AWS::WorkSpaces::Workspace.RootVolumeEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-rootvolumeencryptionenabled
     * @external
     */
    readonly rootVolumeEncryptionEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::WorkSpaces::Workspace.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::WorkSpaces::Workspace.UserVolumeEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-uservolumeencryptionenabled
     * @external
     */
    readonly userVolumeEncryptionEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::WorkSpaces::Workspace.VolumeEncryptionKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-volumeencryptionkey
     * @external
     */
    readonly volumeEncryptionKey?: string;
    /**
     * `AWS::WorkSpaces::Workspace.WorkspaceProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-workspaceproperties
     * @external
     */
    readonly workspaceProperties?: CfnWorkspace.WorkspacePropertiesProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::WorkSpaces::Workspace`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html
 * @external
 * @cloudformationResource AWS::WorkSpaces::Workspace
 */
export declare class CfnWorkspace extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::WorkSpaces::Workspace";
    /**
     * `AWS::WorkSpaces::Workspace.BundleId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-bundleid
     * @external
     */
    bundleId: string;
    /**
     * `AWS::WorkSpaces::Workspace.DirectoryId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-directoryid
     * @external
     */
    directoryId: string;
    /**
     * `AWS::WorkSpaces::Workspace.UserName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-username
     * @external
     */
    userName: string;
    /**
     * `AWS::WorkSpaces::Workspace.RootVolumeEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-rootvolumeencryptionenabled
     * @external
     */
    rootVolumeEncryptionEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::WorkSpaces::Workspace.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::WorkSpaces::Workspace.UserVolumeEncryptionEnabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-uservolumeencryptionenabled
     * @external
     */
    userVolumeEncryptionEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::WorkSpaces::Workspace.VolumeEncryptionKey`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-volumeencryptionkey
     * @external
     */
    volumeEncryptionKey: string | undefined;
    /**
     * `AWS::WorkSpaces::Workspace.WorkspaceProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html#cfn-workspaces-workspace-workspaceproperties
     * @external
     */
    workspaceProperties: CfnWorkspace.WorkspacePropertiesProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::WorkSpaces::Workspace`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnWorkspaceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::WorkSpaces::Workspace`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-workspaces-workspace.html
 * @external
 * @cloudformationResource AWS::WorkSpaces::Workspace
 */
export declare namespace CfnWorkspace {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html
     * @external
     */
    interface WorkspacePropertiesProperty {
        /**
         * `CfnWorkspace.WorkspacePropertiesProperty.ComputeTypeName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-computetypename
         * @external
         */
        readonly computeTypeName?: string;
        /**
         * `CfnWorkspace.WorkspacePropertiesProperty.RootVolumeSizeGib`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-rootvolumesizegib
         * @external
         */
        readonly rootVolumeSizeGib?: number;
        /**
         * `CfnWorkspace.WorkspacePropertiesProperty.RunningMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-runningmode
         * @external
         */
        readonly runningMode?: string;
        /**
         * `CfnWorkspace.WorkspacePropertiesProperty.RunningModeAutoStopTimeoutInMinutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-runningmodeautostoptimeoutinminutes
         * @external
         */
        readonly runningModeAutoStopTimeoutInMinutes?: number;
        /**
         * `CfnWorkspace.WorkspacePropertiesProperty.UserVolumeSizeGib`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-workspaces-workspace-workspaceproperties.html#cfn-workspaces-workspace-workspaceproperties-uservolumesizegib
         * @external
         */
        readonly userVolumeSizeGib?: number;
    }
}
