import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::Transfer::Server`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html
 * @external
 */
export interface CfnServerProps {
    /**
     * `AWS::Transfer::Server.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-certificate
     * @external
     */
    readonly certificate?: string;
    /**
     * `AWS::Transfer::Server.EndpointDetails`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-endpointdetails
     * @external
     */
    readonly endpointDetails?: CfnServer.EndpointDetailsProperty | cdk.IResolvable;
    /**
     * `AWS::Transfer::Server.EndpointType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-endpointtype
     * @external
     */
    readonly endpointType?: string;
    /**
     * `AWS::Transfer::Server.IdentityProviderDetails`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-identityproviderdetails
     * @external
     */
    readonly identityProviderDetails?: CfnServer.IdentityProviderDetailsProperty | cdk.IResolvable;
    /**
     * `AWS::Transfer::Server.IdentityProviderType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-identityprovidertype
     * @external
     */
    readonly identityProviderType?: string;
    /**
     * `AWS::Transfer::Server.LoggingRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-loggingrole
     * @external
     */
    readonly loggingRole?: string;
    /**
     * `AWS::Transfer::Server.Protocols`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-protocols
     * @external
     */
    readonly protocols?: string[];
    /**
     * `AWS::Transfer::Server.SecurityPolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-securitypolicyname
     * @external
     */
    readonly securityPolicyName?: string;
    /**
     * `AWS::Transfer::Server.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Transfer::Server`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html
 * @external
 * @cloudformationResource AWS::Transfer::Server
 */
export declare class CfnServer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Transfer::Server";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ServerId
     */
    readonly attrServerId: string;
    /**
     * `AWS::Transfer::Server.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-certificate
     * @external
     */
    certificate: string | undefined;
    /**
     * `AWS::Transfer::Server.EndpointDetails`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-endpointdetails
     * @external
     */
    endpointDetails: CfnServer.EndpointDetailsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Transfer::Server.EndpointType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-endpointtype
     * @external
     */
    endpointType: string | undefined;
    /**
     * `AWS::Transfer::Server.IdentityProviderDetails`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-identityproviderdetails
     * @external
     */
    identityProviderDetails: CfnServer.IdentityProviderDetailsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Transfer::Server.IdentityProviderType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-identityprovidertype
     * @external
     */
    identityProviderType: string | undefined;
    /**
     * `AWS::Transfer::Server.LoggingRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-loggingrole
     * @external
     */
    loggingRole: string | undefined;
    /**
     * `AWS::Transfer::Server.Protocols`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-protocols
     * @external
     */
    protocols: string[] | undefined;
    /**
     * `AWS::Transfer::Server.SecurityPolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-securitypolicyname
     * @external
     */
    securityPolicyName: string | undefined;
    /**
     * `AWS::Transfer::Server.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html#cfn-transfer-server-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Transfer::Server`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnServerProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Transfer::Server`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html
 * @external
 * @cloudformationResource AWS::Transfer::Server
 */
export declare namespace CfnServer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html
     * @external
     */
    interface EndpointDetailsProperty {
        /**
         * `CfnServer.EndpointDetailsProperty.AddressAllocationIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-addressallocationids
         * @external
         */
        readonly addressAllocationIds?: string[];
        /**
         * `CfnServer.EndpointDetailsProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-subnetids
         * @external
         */
        readonly subnetIds?: string[];
        /**
         * `CfnServer.EndpointDetailsProperty.VpcEndpointId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-vpcendpointid
         * @external
         */
        readonly vpcEndpointId?: string;
        /**
         * `CfnServer.EndpointDetailsProperty.VpcId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-endpointdetails.html#cfn-transfer-server-endpointdetails-vpcid
         * @external
         */
        readonly vpcId?: string;
    }
}
/**
 * A CloudFormation `AWS::Transfer::Server`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-server.html
 * @external
 * @cloudformationResource AWS::Transfer::Server
 */
export declare namespace CfnServer {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html
     * @external
     */
    interface IdentityProviderDetailsProperty {
        /**
         * `CfnServer.IdentityProviderDetailsProperty.InvocationRole`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-invocationrole
         * @external
         */
        readonly invocationRole: string;
        /**
         * `CfnServer.IdentityProviderDetailsProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-server-identityproviderdetails.html#cfn-transfer-server-identityproviderdetails-url
         * @external
         */
        readonly url: string;
    }
}
/**
 * Properties for defining a `AWS::Transfer::User`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html
 * @external
 */
export interface CfnUserProps {
    /**
     * `AWS::Transfer::User.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-role
     * @external
     */
    readonly role: string;
    /**
     * `AWS::Transfer::User.ServerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-serverid
     * @external
     */
    readonly serverId: string;
    /**
     * `AWS::Transfer::User.UserName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-username
     * @external
     */
    readonly userName: string;
    /**
     * `AWS::Transfer::User.HomeDirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectory
     * @external
     */
    readonly homeDirectory?: string;
    /**
     * `AWS::Transfer::User.HomeDirectoryMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorymappings
     * @external
     */
    readonly homeDirectoryMappings?: Array<CfnUser.HomeDirectoryMapEntryProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Transfer::User.HomeDirectoryType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorytype
     * @external
     */
    readonly homeDirectoryType?: string;
    /**
     * `AWS::Transfer::User.Policy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-policy
     * @external
     */
    readonly policy?: string;
    /**
     * `AWS::Transfer::User.SshPublicKeys`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-sshpublickeys
     * @external
     */
    readonly sshPublicKeys?: string[];
    /**
     * `AWS::Transfer::User.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Transfer::User`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html
 * @external
 * @cloudformationResource AWS::Transfer::User
 */
export declare class CfnUser extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Transfer::User";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ServerId
     */
    readonly attrServerId: string;
    /**
     * @external
     * @cloudformationAttribute UserName
     */
    readonly attrUserName: string;
    /**
     * `AWS::Transfer::User.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-role
     * @external
     */
    role: string;
    /**
     * `AWS::Transfer::User.ServerId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-serverid
     * @external
     */
    serverId: string;
    /**
     * `AWS::Transfer::User.UserName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-username
     * @external
     */
    userName: string;
    /**
     * `AWS::Transfer::User.HomeDirectory`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectory
     * @external
     */
    homeDirectory: string | undefined;
    /**
     * `AWS::Transfer::User.HomeDirectoryMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorymappings
     * @external
     */
    homeDirectoryMappings: Array<CfnUser.HomeDirectoryMapEntryProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Transfer::User.HomeDirectoryType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-homedirectorytype
     * @external
     */
    homeDirectoryType: string | undefined;
    /**
     * `AWS::Transfer::User.Policy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-policy
     * @external
     */
    policy: string | undefined;
    /**
     * `AWS::Transfer::User.SshPublicKeys`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-sshpublickeys
     * @external
     */
    sshPublicKeys: string[] | undefined;
    /**
     * `AWS::Transfer::User.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html#cfn-transfer-user-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Transfer::User`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Transfer::User`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-transfer-user.html
 * @external
 * @cloudformationResource AWS::Transfer::User
 */
export declare namespace CfnUser {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-user-homedirectorymapentry.html
     * @external
     */
    interface HomeDirectoryMapEntryProperty {
        /**
         * `CfnUser.HomeDirectoryMapEntryProperty.Entry`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-user-homedirectorymapentry.html#cfn-transfer-user-homedirectorymapentry-entry
         * @external
         */
        readonly entry: string;
        /**
         * `CfnUser.HomeDirectoryMapEntryProperty.Target`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-transfer-user-homedirectorymapentry.html#cfn-transfer-user-homedirectorymapentry-target
         * @external
         */
        readonly target: string;
    }
}
