"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schedule = void 0;
/**
 * (experimental) Schedule for canary runs.
 *
 * @experimental
 */
class Schedule {
    constructor(
    /**
     * The Schedule expression
     */
    expressionString) {
        this.expressionString = expressionString;
    }
    /**
     * (experimental) The canary will be executed once.
     *
     * @experimental
     */
    static once() {
        return new Schedule('rate(0 minutes)');
    }
    /**
     * (experimental) Construct a schedule from a literal schedule expression.
     *
     * The expression must be in a `rate(number units)` format.
     * For example, `Schedule.expression('rate(10 minutes)')`
     *
     * @param expression The expression to use.
     * @experimental
     */
    static expression(expression) {
        return new Schedule(expression);
    }
    /**
     * (experimental) Construct a schedule from an interval.
     *
     * Allowed values: 0 (for a single run) or between 1 and 60 minutes.
     * To specify a single run, you can use `Schedule.once()`.
     *
     * @param interval The interval at which to run the canary.
     * @experimental
     */
    static rate(interval) {
        const minutes = interval.toMinutes();
        if (minutes > 60) {
            throw new Error('Schedule duration must be between 1 and 60 minutes');
        }
        if (minutes === 0) {
            return Schedule.once();
        }
        if (minutes === 1) {
            return new Schedule('rate(1 minute)');
        }
        return new Schedule(`rate(${minutes} minutes)`);
    }
}
exports.Schedule = Schedule;
//# sourceMappingURL=data:application/json;base64,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