import { Duration } from "../../core";
import { Chain } from './chain';
import { State } from './states/state';
/**
 * (experimental) Interface for states that can have 'next' states.
 *
 * @experimental
 */
export interface INextable {
    /**
     * (experimental) Go to the indicated state after this state.
     *
     * @returns The chain of states built up
     * @experimental
     */
    next(state: IChainable): Chain;
}
/**
 * (experimental) Interface for objects that can be used in a Chain.
 *
 * @experimental
 */
export interface IChainable {
    /**
     * (experimental) Descriptive identifier for this chainable.
     *
     * @experimental
     */
    readonly id: string;
    /**
     * (experimental) The start state of this chainable.
     *
     * @experimental
     */
    readonly startState: State;
    /**
     * (experimental) The chainable end state(s) of this chainable.
     *
     * @experimental
     */
    readonly endStates: INextable[];
}
/**
 * (experimental) Predefined error strings Error names in Amazon States Language - https://states-language.net/spec.html#appendix-a Error handling in Step Functions - https://docs.aws.amazon.com/step-functions/latest/dg/concepts-error-handling.html.
 *
 * @experimental
 */
export declare class Errors {
    /**
     * (experimental) Matches any Error.
     *
     * @experimental
     */
    static readonly ALL = "States.ALL";
    /**
     * (experimental) A Task State either ran longer than the “TimeoutSeconds” value, or failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
     *
     * @experimental
     */
    static readonly TIMEOUT = "States.Timeout";
    /**
     * (experimental) A Task State failed during the execution.
     *
     * @experimental
     */
    static readonly TASKS_FAILED = "States.TaskFailed";
    /**
     * (experimental) A Task State failed because it had insufficient privileges to execute the specified code.
     *
     * @experimental
     */
    static readonly PERMISSIONS = "States.Permissions";
    /**
     * (experimental) A Task State’s “ResultPath” field cannot be applied to the input the state received.
     *
     * @experimental
     */
    static readonly RESULT_PATH_MATCH_FAILURE = "States.ResultPathMatchFailure";
    /**
     * (experimental) Within a state’s “Parameters” field, the attempt to replace a field whose name ends in “.$” using a Path failed.
     *
     * @experimental
     */
    static readonly PARAMETER_PATH_FAILURE = "States.ParameterPathFailure";
    /**
     * (experimental) A branch of a Parallel state failed.
     *
     * @experimental
     */
    static readonly BRANCH_FAILED = "States.BranchFailed";
    /**
     * (experimental) A Choice state failed to find a match for the condition field extracted from its input.
     *
     * @experimental
     */
    static readonly NO_CHOICE_MATCHED = "States.NoChoiceMatched";
}
/**
 * (experimental) Retry details.
 *
 * @experimental
 */
export interface RetryProps {
    /**
     * (experimental) Errors to retry.
     *
     * A list of error strings to retry, which can be either predefined errors
     * (for example Errors.NoChoiceMatched) or a self-defined error.
     *
     * @default All errors
     * @experimental
     */
    readonly errors?: string[];
    /**
     * (experimental) How many seconds to wait initially before retrying.
     *
     * @default Duration.seconds(1)
     * @experimental
     */
    readonly interval?: Duration;
    /**
     * (experimental) How many times to retry this particular error.
     *
     * May be 0 to disable retry for specific errors (in case you have
     * a catch-all retry policy).
     *
     * @default 3
     * @experimental
     */
    readonly maxAttempts?: number;
    /**
     * (experimental) Multiplication for how much longer the wait interval gets on every retry.
     *
     * @default 2
     * @experimental
     */
    readonly backoffRate?: number;
}
/**
 * (experimental) Error handler details.
 *
 * @experimental
 */
export interface CatchProps {
    /**
     * (experimental) Errors to recover from by going to the given state.
     *
     * A list of error strings to retry, which can be either predefined errors
     * (for example Errors.NoChoiceMatched) or a self-defined error.
     *
     * @default All errors
     * @experimental
     */
    readonly errors?: string[];
    /**
     * (experimental) JSONPath expression to indicate where to inject the error data.
     *
     * May also be the special value DISCARD, which will cause the error
     * data to be discarded.
     *
     * @default $
     * @experimental
     */
    readonly resultPath?: string;
}
/**
 * Special string value to discard state input, output or result
 */
export declare const DISCARD = "DISCARD";
