import * as cloudwatch from "../../aws-cloudwatch";
import * as iam from "../../aws-iam";
import { Duration } from "../../core";
import { Task } from './states/task';
/**
 * (experimental) Interface for resources that can be used as tasks.
 *
 * @experimental
 */
export interface IStepFunctionsTask {
    /**
     * (experimental) Called when the task object is used in a workflow.
     *
     * @experimental
     */
    bind(task: Task): StepFunctionsTaskConfig;
}
/**
 * (experimental) Properties that define what kind of task should be created.
 *
 * @experimental
 */
export interface StepFunctionsTaskConfig {
    /**
     * (experimental) The resource that represents the work to be executed.
     *
     * Either the ARN of a Lambda Function or Activity, or a special
     * ARN.
     *
     * @experimental
     */
    readonly resourceArn: string;
    /**
     * (experimental) Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
     *
     * The meaning of these parameters is task-dependent.
     *
     * Its values will be merged with the `parameters` property which is configured directly
     * on the Task state.
     *
     * @default No parameters
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters
     * @experimental
     */
    readonly parameters?: {
        [name: string]: any;
    };
    /**
     * (experimental) Maximum time between heart beats.
     *
     * If the time between heart beats takes longer than this, a 'Timeout' error is raised.
     *
     * This is only relevant when using an Activity type as resource.
     *
     * @default No heart beat timeout
     * @experimental
     */
    readonly heartbeat?: Duration;
    /**
     * (experimental) Additional policy statements to add to the execution role.
     *
     * @default No policy roles
     * @experimental
     */
    readonly policyStatements?: iam.PolicyStatement[];
    /**
     * (experimental) Prefix for singular metric names of activity actions.
     *
     * @default No such metrics
     * @experimental
     */
    readonly metricPrefixSingular?: string;
    /**
     * (experimental) Prefix for plural metric names of activity actions.
     *
     * @default No such metrics
     * @experimental
     */
    readonly metricPrefixPlural?: string;
    /**
     * (experimental) The dimensions to attach to metrics.
     *
     * @default No metrics
     * @experimental
     */
    readonly metricDimensions?: cloudwatch.DimensionHash;
}
/**
 * (experimental) Three ways to call an integrated service: Request Response, Run a Job and Wait for a Callback with Task Token.
 *
 * @default FIRE_AND_FORGET
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
 *
 * Here, they are named as FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN respectly.
 * @experimental
 */
export declare enum ServiceIntegrationPattern {
    /**
     * (experimental) Call a service and progress to the next state immediately after the API call completes.
     *
     * @experimental
     */
    FIRE_AND_FORGET = "FIRE_AND_FORGET",
    /**
     * (experimental) Call a service and wait for a job to complete.
     *
     * @experimental
     */
    SYNC = "SYNC",
    /**
     * (experimental) Call a service with a task token and wait until that token is returned by SendTaskSuccess/SendTaskFailure with paylaod.
     *
     * @experimental
     */
    WAIT_FOR_TASK_TOKEN = "WAIT_FOR_TASK_TOKEN"
}
