import * as cdk from "../../../core";
import { Construct } from 'constructs';
import { Chain } from '../chain';
import { IChainable, INextable } from '../types';
import { State } from './state';
/**
 * (experimental) Represents the Wait state which delays a state machine from continuing for a specified time.
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/amazon-states-language-wait-state.html
 * @experimental
 */
export declare class WaitTime {
    private readonly json;
    /**
     * (experimental) Wait a fixed amount of time.
     *
     * @experimental
     */
    static duration(duration: cdk.Duration): WaitTime;
    /**
     * (experimental) Wait until the given ISO8601 timestamp.
     *
     * @experimental
     * @example
     *
     * 2016-03-14T01:59:00Z
     */
    static timestamp(timestamp: string): WaitTime;
    /**
     * (experimental) Wait for a number of seconds stored in the state object.
     *
     * @experimental
     * @example
     *
     * $.waitSeconds
     */
    static secondsPath(path: string): WaitTime;
    /**
     * (experimental) Wait until a timestamp found in the state object.
     *
     * @experimental
     * @example
     *
     * $.waitTimestamp
     */
    static timestampPath(path: string): WaitTime;
    private constructor();
}
/**
 * (experimental) Properties for defining a Wait state.
 *
 * @experimental
 */
export interface WaitProps {
    /**
     * (experimental) An optional description for this state.
     *
     * @default No comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) Wait duration.
     *
     * @experimental
     */
    readonly time: WaitTime;
}
/**
 * (experimental) Define a Wait state in the state machine.
 *
 * A Wait state can be used to delay execution of the state machine for a while.
 *
 * @experimental
 */
export declare class Wait extends State implements INextable {
    /**
     * (experimental) Continuable states of this Chainable.
     *
     * @experimental
     */
    readonly endStates: INextable[];
    private readonly time;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: WaitProps);
    /**
     * (experimental) Continue normal execution with the given state.
     *
     * @experimental
     */
    next(next: IChainable): Chain;
    /**
     * (experimental) Return the Amazon States Language object for this state.
     *
     * @experimental
     */
    toStateJson(): object;
}
