import * as cloudwatch from "../../../aws-cloudwatch";
import * as iam from "../../../aws-iam";
import * as cdk from "../../../core";
import { Construct } from 'constructs';
import { Chain } from '../chain';
import { StateGraph } from '../state-graph';
import { CatchProps, IChainable, INextable, RetryProps } from '../types';
import { State } from './state';
/**
 * (experimental) Props that are common to all tasks.
 *
 * @experimental
 */
export interface TaskStateBaseProps {
    /**
     * (experimental) An optional description for this state.
     *
     * @default - No comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) JSONPath expression to select part of the state to be the input to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * input to be the empty object {}.
     *
     * @default - The entire task input (JSON path '$')
     * @experimental
     */
    readonly inputPath?: string;
    /**
     * (experimental) JSONPath expression to select select a portion of the state output to pass to the next state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * output to be the empty object {}.
     *
     * @default - The entire JSON node determined by the state input, the task result,
     * and resultPath is passed to the next state (JSON path '$')
     * @experimental
     */
    readonly outputPath?: string;
    /**
     * (experimental) JSONPath expression to indicate where to inject the state's output.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the state's
     * input to become its output.
     *
     * @default - Replaces the entire input with the result (JSON path '$')
     * @experimental
     */
    readonly resultPath?: string;
    /**
     * (experimental) Timeout for the state machine.
     *
     * @default - None
     * @experimental
     */
    readonly timeout?: cdk.Duration;
    /**
     * (experimental) Timeout for the heartbeat.
     *
     * @default - None
     * @experimental
     */
    readonly heartbeat?: cdk.Duration;
    /**
     * (experimental) AWS Step Functions integrates with services directly in the Amazon States Language.
     *
     * You can control these AWS services using service integration patterns
     *
     * @default IntegrationPattern.REQUEST_RESPONSE
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token
     * @experimental
     */
    readonly integrationPattern?: IntegrationPattern;
}
/**
 * (experimental) Define a Task state in the state machine.
 *
 * Reaching a Task state causes some work to be executed, represented by the
 * Task's resource property. Task constructs represent a generic Amazon
 * States Language Task.
 *
 * For some resource types, more specific subclasses of Task may be available
 * which are more convenient to use.
 *
 * @experimental
 */
export declare abstract class TaskStateBase extends State implements INextable {
    /**
     * (experimental) Continuable states of this Chainable.
     *
     * @experimental
     */
    readonly endStates: INextable[];
    /**
     * @experimental
     */
    protected abstract readonly taskMetrics?: TaskMetricsConfig;
    /**
     * @experimental
     */
    protected abstract readonly taskPolicies?: iam.PolicyStatement[];
    private readonly timeout?;
    private readonly heartbeat?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: TaskStateBaseProps);
    /**
     * (experimental) Add retry configuration for this state.
     *
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     *
     * @experimental
     */
    addRetry(props?: RetryProps): TaskStateBase;
    /**
     * (experimental) Add a recovery handler for this state.
     *
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     *
     * @experimental
     */
    addCatch(handler: IChainable, props?: CatchProps): TaskStateBase;
    /**
     * (experimental) Continue normal execution with the given state.
     *
     * @experimental
     */
    next(next: IChainable): Chain;
    /**
     * (experimental) Return the Amazon States Language object for this state.
     *
     * @experimental
     */
    toStateJson(): object;
    /**
     * (experimental) Return the given named metric for this Task.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The interval, in milliseconds, between the time the Task starts and the time it closes.
     *
     * @default - average over 5 minutes
     * @experimental
     */
    metricRunTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The interval, in milliseconds, for which the activity stays in the schedule state.
     *
     * @default - average over 5 minutes
     * @experimental
     */
    metricScheduleTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The interval, in milliseconds, between the time the activity is scheduled and the time it closes.
     *
     * @default - average over 5 minutes
     * @experimental
     */
    metricTime(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times this activity is scheduled.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricScheduled(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times this activity times out.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricTimedOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times this activity is started.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricStarted(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times this activity succeeds.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricSucceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times this activity fails.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of times the heartbeat times out for this activity.
     *
     * @default - sum over 5 minutes
     * @experimental
     */
    metricHeartbeatTimedOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Called whenever this state is bound to a graph.
     *
     * Can be overridden by subclasses.
     *
     * @experimental
     */
    protected whenBoundToGraph(graph: StateGraph): void;
    private taskMetric;
    private renderTaskBase;
}
/**
 * (experimental) Task Metrics.
 *
 * @experimental
 */
export interface TaskMetricsConfig {
    /**
     * (experimental) Prefix for singular metric names of activity actions.
     *
     * @default - No such metrics
     * @experimental
     */
    readonly metricPrefixSingular?: string;
    /**
     * (experimental) Prefix for plural metric names of activity actions.
     *
     * @default - No such metrics
     * @experimental
     */
    readonly metricPrefixPlural?: string;
    /**
     * (experimental) The dimensions to attach to metrics.
     *
     * @default - No metrics
     * @experimental
     */
    readonly metricDimensions?: cloudwatch.DimensionHash;
}
/**
 * (experimental) AWS Step Functions integrates with services directly in the Amazon States Language.
 *
 * You can control these AWS services using service integration patterns:
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html
 * @experimental
 */
export declare enum IntegrationPattern {
    /**
     * (experimental) Step Functions will wait for an HTTP response and then progress to the next state.
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-default
     * @experimental
     */
    REQUEST_RESPONSE = "REQUEST_RESPONSE",
    /**
     * (experimental) Step Functions can wait for a request to complete before progressing to the next state.
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync
     * @experimental
     */
    RUN_JOB = "RUN_JOB",
    /**
     * (experimental) Callback tasks provide a way to pause a workflow until a task token is returned.
     *
     * You must set a task token when using the callback pattern
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token
     * @experimental
     */
    WAIT_FOR_TASK_TOKEN = "WAIT_FOR_TASK_TOKEN"
}
