import { Construct } from 'constructs';
import { INextable } from '../types';
import { State } from './state';
/**
 * (experimental) Properties for defining a Succeed state.
 *
 * @experimental
 */
export interface SucceedProps {
    /**
     * (experimental) An optional description for this state.
     *
     * @default No comment
     * @experimental
     */
    readonly comment?: string;
    /**
     * (experimental) JSONPath expression to select part of the state to be the input to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * input to be the empty object {}.
     *
     * @default $
     * @experimental
     */
    readonly inputPath?: string;
    /**
     * (experimental) JSONPath expression to select part of the state to be the output to this state.
     *
     * May also be the special value JsonPath.DISCARD, which will cause the effective
     * output to be the empty object {}.
     *
     * @default $
     * @experimental
     */
    readonly outputPath?: string;
}
/**
 * (experimental) Define a Succeed state in the state machine.
 *
 * Reaching a Succeed state terminates the state execution in success.
 *
 * @experimental
 */
export declare class Succeed extends State {
    /**
     * (experimental) Continuable states of this Chainable.
     *
     * @experimental
     */
    readonly endStates: INextable[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: SucceedProps);
    /**
     * (experimental) Return the Amazon States Language object for this state.
     *
     * @experimental
     */
    toStateJson(): object;
}
