import * as cloudwatch from "../../aws-cloudwatch";
/**
 * (experimental) Metrics on the rate limiting performed on state machine execution.
 *
 * These rate limits are shared across all state machines.
 *
 * @experimental
 */
export declare class StateTransitionMetric {
    /**
     * (experimental) Return the given named metric for the service's state transition metrics.
     *
     * @default average over 5 minutes
     * @experimental
     */
    static metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of available state transitions.
     *
     * @default average over 5 minutes
     * @experimental
     */
    static metricProvisionedBucketSize(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the provisioned steady-state execution rate.
     *
     * @default average over 5 minutes
     * @experimental
     */
    static metricProvisionedRefillRate(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of available state transitions per second.
     *
     * @default average over 5 minutes
     * @experimental
     */
    static metricConsumedCapacity(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the number of throttled state transitions.
     *
     * @default sum over 5 minutes
     * @experimental
     */
    static metricThrottledEvents(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
