import * as cdk from "../../core";
import { Chain } from './chain';
import { Parallel, ParallelProps } from './states/parallel';
import { State } from './states/state';
import { IChainable, INextable } from './types';
/**
 * (experimental) Base class for reusable state machine fragments.
 *
 * @experimental
 */
export declare abstract class StateMachineFragment extends cdk.Construct implements IChainable {
    /**
     * (experimental) The start state of this state machine fragment.
     *
     * @experimental
     */
    abstract readonly startState: State;
    /**
     * (experimental) The states to chain onto if this fragment is used.
     *
     * @experimental
     */
    abstract readonly endStates: INextable[];
    /**
     * (experimental) Descriptive identifier for this chainable.
     *
     * @experimental
     */
    get id(): string;
    /**
     * (experimental) Prefix the IDs of all states in this state machine fragment.
     *
     * Use this to avoid multiple copies of the state machine all having the
     * same state IDs.
     *
     * @param prefix The prefix to add.
     * @experimental
     */
    prefixStates(prefix?: string): StateMachineFragment;
    /**
     * (experimental) Wrap all states in this state machine fragment up into a single state.
     *
     * This can be used to add retry or error handling onto this state
     * machine fragment.
     *
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     *
     * @experimental
     */
    toSingleState(options?: SingleStateOptions): Parallel;
    /**
     * (experimental) Continue normal execution with the given state.
     *
     * @experimental
     */
    next(next: IChainable): Chain;
}
/**
 * (experimental) Options for creating a single state.
 *
 * @experimental
 */
export interface SingleStateOptions extends ParallelProps {
    /**
     * (experimental) ID of newly created containing state.
     *
     * @default Construct ID of the StateMachineFragment
     * @experimental
     */
    readonly stateId?: string;
    /**
     * (experimental) String to prefix all stateIds in the state machine with.
     *
     * @default stateId
     * @experimental
     */
    readonly prefixStates?: string;
}
