"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chain = void 0;
const parallel_1 = require("./states/parallel");
/**
 * (experimental) A collection of states to chain onto.
 *
 * A Chain has a start and zero or more chainable ends. If there are
 * zero ends, calling next() on the Chain will fail.
 *
 * @experimental
 */
class Chain {
    constructor(startState, endStates, lastAdded) {
        this.lastAdded = lastAdded;
        this.id = lastAdded.id;
        this.startState = startState;
        this.endStates = endStates;
    }
    /**
     * (experimental) Begin a new Chain from one chainable.
     *
     * @experimental
     */
    static start(state) {
        return new Chain(state.startState, state.endStates, state);
    }
    /**
     * (experimental) Make a Chain with the start from one chain and the ends from another.
     *
     * @experimental
     */
    static sequence(start, next) {
        return new Chain(start.startState, next.endStates, next);
    }
    /**
     * (experimental) Make a Chain with specific start and end states, and a last-added Chainable.
     *
     * @experimental
     */
    static custom(startState, endStates, lastAdded) {
        return new Chain(startState, endStates, lastAdded);
    }
    /**
     * (experimental) Continue normal execution with the given state.
     *
     * @experimental
     */
    next(next) {
        if (this.endStates.length === 0) {
            throw new Error(`Cannot add to chain: last state in chain (${this.lastAdded.id}) does not allow it`);
        }
        for (const endState of this.endStates) {
            endState.next(next);
        }
        return new Chain(this.startState, next.endStates, next);
    }
    /**
     * (experimental) Return a single state that encompasses all states in the chain.
     *
     * This can be used to add error handling to a sequence of states.
     *
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     *
     * @experimental
     */
    toSingleState(id, props = {}) {
        return new parallel_1.Parallel(this.startState, id, props).branch(this);
    }
}
exports.Chain = Chain;
//# sourceMappingURL=data:application/json;base64,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