import * as iam from "../../../aws-iam";
import * as sfn from "../../../aws-stepfunctions";
import { Construct } from 'constructs';
/**
 * (experimental) Properties for StartExecution.
 *
 * @experimental
 */
export interface StepFunctionsStartExecutionProps extends sfn.TaskStateBaseProps {
    /**
     * (experimental) The Step Functions state machine to start the execution on.
     *
     * @experimental
     */
    readonly stateMachine: sfn.IStateMachine;
    /**
     * (experimental) The JSON input for the execution, same as that of StartExecution.
     *
     * @default - The state input (JSON path '$')
     * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
     * @experimental
     */
    readonly input?: sfn.TaskInput;
    /**
     * (experimental) The name of the execution, same as that of StartExecution.
     *
     * @default - None
     * @see https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html
     * @experimental
     */
    readonly name?: string;
}
/**
 * (experimental) A Step Functions Task to call StartExecution on another state machine.
 *
 * It supports three service integration patterns: FIRE_AND_FORGET, SYNC and WAIT_FOR_TASK_TOKEN.
 *
 * @experimental
 */
export declare class StepFunctionsStartExecution extends sfn.TaskStateBase {
    private readonly props;
    private static readonly SUPPORTED_INTEGRATION_PATTERNS;
    /**
     * @experimental
     */
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    /**
     * @experimental
     */
    protected readonly taskPolicies?: iam.PolicyStatement[];
    private readonly integrationPattern;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: StepFunctionsStartExecutionProps);
    /**
     * As StateMachineArn is extracted automatically from the state machine object included in the constructor,
     *
     * the scoped access policy should be generated accordingly.
     *
     * This means the action of StartExecution should be restricted on the given state machine, instead of being granted to all the resources (*).
     */
    private createScopedAccessPolicy;
}
